/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_OGG

#include "../../player.h"
#include "../../other.h"

int
vorbis_read_config (char *file, audio_data_vorbis * vorbis)
{
  cfg_t *cfg;
  int a;

  cfg_opt_t opts[] = {
    CFG_INT ("rate", 44100, CFGF_NONE),
    CFG_INT ("quality", 8, CFGF_NONE),
    CFG_INT ("bitrate", 96, CFGF_NONE),
    CFG_INT ("channels", OUT_STEREO, CFGF_NONE),

    CFG_INT ("lowpass", 0, CFGF_NONE),
    CFG_INT ("highpass", 0, CFGF_NONE),

    CFG_STR ("file", NULL, CFGF_NONE),
    CFG_END ()
  };

  memset (vorbis, 0, sizeof (audio_data_vorbis));

  cfg = cfg_init (opts, CFGF_NOCASE);
  a = cfg_parse (cfg, file);

  if (a != 0)
    {
      if (a == CFG_FILE_ERROR)
	msg_error (_("No vorbis config file."));
      else if (a == CFG_PARSE_ERROR)
	msg_error (_("Error of parsing vorbis file."));

      return 1;
    }

  msg (_("Read vorbis config file."));

  vorbis->rate = cfg_getint (cfg, "rate");
  vorbis->quality = cfg_getint (cfg, "quality");
  vorbis->bitrate = cfg_getint (cfg, "bitrate");
  vorbis->channels = cfg_getint (cfg, "channels");
  vorbis->lowpass = cfg_getint (cfg, "lowpass");
  vorbis->highpass = cfg_getint (cfg, "highpass");

  if (!cfg_getstr (cfg, "file") || !*(cfg_getstr (cfg, "file")))
    {
      msg_error (_("No output file in config file!"));
      cfg_free (cfg);
      return 1;
    }

  if (!(vorbis->file = strdup (cfg_getstr (cfg, "file"))))
    fatal (_("Error: memory."));

  vorbis->vorbis = NULL;

  vorbis->fd = NULL;

  cfg_free (cfg);

  return 0;
}

#endif
