package Scoop;
use strict;
my $DEBUG = 0;

sub comment_dig {
	my $S = shift;

	my $sid = $S->{CGI}->param('sid');
	my $pid = $S->{CGI}->param('pid');
	my $cid = $S->{CGI}->param('cid');
	my $tool = $S->{CGI}->param('tool');
	my $mode = $S->{CGI}->param('mode');
	my $showrate = $S->{CGI}->param('showrate');
	my $check_comment = $S->{CGI}->param('pending');
	my ($dynamic, $dynamicmode);
	if ($S->{UI}->{VARS}->{allow_dynamic_comment_mode}) {
		$dynamic = ($S->{CGI}->param('op') eq 'dynamic') ? 1 : 0;
		$dynamicmode = $S->{CGI}->param('dynamicmode');
	} else {
		$dynamic = 0;
		$dynamicmode = 0;
	}

	# some variables for use in the plethora of conditionals below
	my $section = $S->_get_story_section($sid);
	my $sect_post_perm;
	my $sect_read_perm;

	# make sure you treat it properly if its a poll
	if ($S->_does_poll_exist($sid)) {
		$sect_post_perm = $S->have_perm('poll_post_comments');
		$sect_read_perm = $S->have_perm('poll_read_comments');
	} else {
		$sect_post_perm = $S->have_section_perm('norm_post_comments',$section);
		$sect_read_perm = $S->have_section_perm('norm_read_comments',$section);
	}

	$S->{UI}->{BLOCKS}->{subtitle} = 'Comments %%bars%% ';
	
	# Set variables for the dynamic template, and coerce into dynamic mode
	# if we're in a dynamic page
	if ($S->{UI}->{VARS}->{allow_dynamic_comment_mode} && $dynamic) {
		$S->_setup_dynamic_blocks($sid);
		$S->{UI}->{VARS}->{dynamicmode} = ($dynamicmode? 1 : 0);
		$S->{UI}->{VARS}->{mainpid} = 0; # No longer used
		$mode = 'dynamic';
	}

	my ($rv, $sth) = $S->db_select({
		WHAT => 'title',
		FROM => 'stories',
		WHERE => qq|sid = "$sid"|});
	$S->{UI}->{BLOCKS}->{subtitle} .= $sth->fetchrow;
	$sth->finish;
	$S->{UI}->{BLOCKS}->{subtitle} =~ s/</&lt;/g;
	$S->{UI}->{BLOCKS}->{subtitle} =~ s/>/&gt;/g;

	#Make sure comment controls are set
	#$S->_set_comment_mode();

	if ($tool eq 'delete' && $S->have_perm( 'comment_delete' )) {
		$S->_delete_comment($sid, $cid, $pid);
	}

	$mode = 'Preview' if $S->{CGI}->param('spellcheck');

	# Check formkey
	unless ($S->check_formkey()) {
		$S->{UI}->{BLOCKS}->{COMM_ERR} = qq|
		<TABLE CELLPADDING=1 CELLSPACING=0 BORDER=0 width="100%">
			<TR><TD>%%norm_font%%<FONT color="FF0000"><B>Form key invalid. This is probably because you clicked 'Post' or 'Preview' more than once. DO NOT HIT 'BACK'! If you're sure you haven't already posted this once, go ahead and post (or preview) from this screen.</B></FONT>%%norm_font_end%%<P></TD></TR>
		</TABLE>|;
		$mode = 'Preview';
	}

	if ($tool eq 'post' && $mode eq 'Post') {
		my $err;
		if ($S->have_perm( 'comment_post' )) {

			# Check for editorial/topical
			if ( $S->{CGI}->param('pending') == -1) {
				$err .= qq|
					%%norm_font%%<FONT color="FF0000"><B>Before posting your comment you must either choose for it to be editorial or topical.</B></font>%%norm_font_end%%<P>|;
				$mode = 'Preview';
			} 
			
			# Check for subject line
			my $check_subj = $S->{CGI}->param('subject');
			$check_subj =~ s/\&nbsp\;//gi;	# Filter spaces out for the check
			unless ( $check_subj && ($check_subj =~ /\w+/) ) {
				$err .= qq|
					%%norm_font%%<FONT color="FF0000"><B>Please enter a subject for your comment.</B></font>%%norm_font_end%%<P>|;
				$mode = 'Preview';
			}

			# Now try to post.
			if ($mode ne 'Preview') {
				if (my $new_cid = $S->post_comment()) {
					$cid = $new_cid;
					$mode = 'confirm';
				} else {
					$err .= qq|
						%%norm_font%%<B>Post Failed.</B> |.$S->{DBH}->errstr."%%norm_font_end%%<P>";
					$err .= $S->{DBH}->errstr . "<br>\n" if $S->{DBH}->errstr;
					my $checker_error = $S->html_checker->errors_as_string;
					$err .= $checker_error . "\n" if $checker_error;
					$err .= "%%norm_font_end%%<P>";
					$mode = 'Preview';
				}
			}
		} else {
			$err .= qq|
				%%norm_font%%<B>Post Failed.</B> |.$S->{DBH}->errstr."%%norm_font_end%%<P>";
			$mode = 'Preview';
		}
		

		$err .= $S->{DBH}->errstr . "<br>\n" if $S->{DBH}->errstr;
		my $checker_error = $S->html_checker->errors_as_string;
		$err .= $checker_error . "\n" if $checker_error;
		$err .= "%%norm_font_end%%<P>";

		$S->{UI}->{BLOCKS}->{COMM_ERR} = qq|
		  <TABLE CELLPADDING=1 CELLSPACING=0 BORDER=0 width="100%">
			<TR><TD>$err</TD></TR>
		  </TABLE>| if ($err);
	} 
	
	if ($cid && $cid =~ /\d+/) {
		my ($rv, $sth) = $S->db_select({
			WHAT => 'pid',
			FROM => 'comments',
			WHERE => qq|cid = $cid AND sid = "$sid"|});
		my $id = $sth->fetchrow_hashref;
		$sth->finish;
		$pid = $id->{pid};
	} 
	
	# Make sure the mode reflects the current mode, for post_form
	$S->{PARAMS}->{'mode'} = $mode;
	
	if ($tool eq 'post' && ($mode eq 'Preview' || $mode eq '') && $S->have_perm( 'comment_post' ) && $sect_post_perm ) {
		$S->{UI}->{BLOCKS}->{CONTENT} .= qq|
		  <TABLE CELLPADDING=1 CELLSPACING=0 BORDER=0 width="100\%">
			<TR>
			<TD BGCOLOR="%%title_bgcolor%%" WIDTH="100%">
				%%title_font%%<B>Replying To:</B>%%title_font_end%%
			</TD>
		</TR>
		<TR>
			<TD>|;
		if (!$cid) {
			$S->{UI}->{BLOCKS}->{CONTENT} .= $S->displaystory($sid);
		} else {
			$S->{UI}->{BLOCKS}->{CONTENT} .= $S->display_comments($sid, $pid, 'alone');
		}
		$S->{UI}->{BLOCKS}->{CONTENT} .= qq|
			</TD></TR>
			<TR><TD>|;
		$S->{UI}->{BLOCKS}->{CONTENT} .= '<TR><TD>'.$S->post_form().'</TD></TR></TABLE>';
	} elsif ($tool eq 'post' && $mode eq 'confirm' && $S->have_perm( 'comment_post' ) && $sect_post_perm ) {
		$S->{UI}->{BLOCKS}->{CONTENT} .= $S->comment_controls($sid, 'top');
		#$S->{UI}->{BLOCKS}->{BOXES} .= $S->comment_choices_box($sid);
		#$S->{UI}->{BLOCKS}->{BOXES} .= '<P>';
		$S->{UI}->{BLOCKS}->{CONTENT} .= qq|
			  <TABLE CELLPADDING=1 CELLSPACING=0 BORDER=0 width="100\%">|;
		if ($S->{UI}->{VARS}->{use_mojo} && $S->{TRUSTLEV} == 0) {
			$S->{UI}->{BLOCKS}->{CONTENT} .= qq|
			   <TR>
				<TD BGCOLOR="%%title_bgcolor%%" WIDTH="100%">
					%%title_font%%$S->{UI}->{BLOCKS}->{untrusted_post_message}%%title_font_end%%
				</TD>
			</TR>
			<TR>
				<TD>|;
		} else {
			$S->{UI}->{BLOCKS}->{CONTENT} .= qq|
			<TR>
				<TD BGCOLOR="%%title_bgcolor%%" WIDTH="100%">
					%%title_font%%<A NAME="here">Comment posted!</A> Thank you for contributing.%%title_font_end%%
				</TD>
			</TR>
			<TR>
				<TD>|;
		}
		
		$S->{UI}->{BLOCKS}->{CONTENT} .= $S->display_comments($sid, $pid, 'alone', $cid);
		$S->{UI}->{BLOCKS}->{CONTENT} .= qq|
			</TD></TR></TABLE>|;
	} elsif (!$S->have_perm('moderate') && ($S->_check_story_mode($sid) <= -2)) {
		$S->{UI}->{BLOCKS}->{CONTENT} = qq|<p><b>%%norm_font%%Sorry, you don't have permission to see comments in the queue.%%norm_font_end%%</b></p>|;
	} elsif ( $sect_read_perm ) {
		if ($dynamic && !$dynamicmode) {
			# In collapsed mode, just show the comment counts
			$S->{UI}->{BLOCKS}->{CONTENT} = $S->display_comments($sid, $pid, 'collapsed');
		} else {
			# Get all relevant ratings
			my $rate = $S->session('ratingchoice');

			my $comments = $S->display_comments($sid, $pid, $mode);

			if ($showrate) {
				$comments .= '%%BOX,show_comment_raters%%';
			}

			if (!$dynamic) {
				$S->{UI}->{BLOCKS}->{CONTENT} .= $S->comment_controls($sid, 'top');
			}

			$S->{UI}->{BLOCKS}->{CONTENT} .= qq|$comments|;

			if ($comments && !$dynamic) {
				$S->{UI}->{BLOCKS}->{CONTENT} .= '<P>';
				$S->{UI}->{BLOCKS}->{CONTENT} .= $S->comment_controls($sid, 'top');
			}
			#$S->{UI}->{BLOCKS}->{BOXES} .= $S->comment_choices_box($sid);
			#$S->{UI}->{BLOCKS}->{BOXES} .= '<P>';
		}
	} else {
		if ( $tool eq 'post' && $S->have_section_perm('deny_post_comments', $section )) {
			$S->{UI}->{BLOCKS}->{CONTENT} = qq|
				<b>%%norm_font%%You don't have permission to post comments to this section.%%norm_font_end%%</b>|;
		} elsif ( $tool ne 'post' && $S->have_section_perm('deny_read_comments', $section )) {
			$S->{UI}->{BLOCKS}->{CONTENT} = qq|
				<b>%%norm_font%%You don't have permission to read comments in this section.%%norm_font_end%%</b>|;
		} else {
			$S->{UI}->{BLOCKS}->{CONTENT} = qq|<b>%%norm_font%%Sorry, I couldn't find that story.%%norm_font_end%%</b>|;
		}

	}

	return;
}

sub _setup_dynamic_blocks {
	my $S = shift;
	my $sid = shift;

	my $collapse_symbol = $S->js_quote($S->{UI}->{BLOCKS}->{dynamic_collapse_link});
	my $expand_symbol = $S->js_quote($S->{UI}->{BLOCKS}->{dynamic_expand_link});
	my $loading_symbol = $S->js_quote($S->{UI}->{BLOCKS}->{dynamic_loading_link});
	my $loading_message = $S->js_quote($S->{UI}->{BLOCKS}->{dynamic_loading_message});
	my $rootdir = $S->js_quote($S->{UI}->{VARS}->{rootdir}) || '/';
	my $sidesc = $S->js_quote($sid);

	$S->{UI}->{BLOCKS}->{dynamicmode_javascript} = $S->{UI}->{BLOCKS}->{dynamic_js_tag};
	# Sorry about the ugly indentation here, but some less
	# intelligent JS parsers (like Konqueror 2.x's) won't execute
	# JS statements that don't start at the beginning of the line
	$S->{UI}->{BLOCKS}->{dynamicmode_javascript} .= qq|
<SCRIPT LANGUAGE="JavaScript" TYPE="text/javascript"><!--
collapse_symbol = '$collapse_symbol';
expand_symbol = '$expand_symbol';
loading_symbol = '$loading_symbol';
loading_message = '$loading_message';
rootdir = '$rootdir';
sid = '$sidesc';
//--></SCRIPT>|;
	$S->{UI}->{BLOCKS}->{dynamicmode_iframe} = qq|<IFRAME WIDTH=0 HEIGHT=0 BORDER=0 STYLE="width:0;height:0;border:0" ID="dynamic" NAME="dynamic" SRC="about:blank"></IFRAME>|;
}

sub _delete_comment {
	my $S = shift;
	my ($sid, $cid, $pid) = @_;
	
	$pid = 0 unless $pid;
	
	# First, get the uid of comment poster
	my ($rv, $sth) = $S->db_select({
		WHAT => 'uid',
		FROM => 'comments',
		WHERE => qq|cid = "$cid" AND sid = "$sid"|});
	
	my $uid = $sth->fetchrow();
	
	# Then delete the comment
	$rv = $S->db_delete({
		FROM => 'comments',
		WHERE => qq|cid = "$cid" AND sid = "$sid"|});
	
	return unless ($rv);
	
	# Then reparent children of this comment
	$S->db_update({
		WHAT => 'comments',
		SET => qq|pid = $pid|,
		WHERE => qq|sid = "$sid" AND pid = "$cid"|});
	
	# Drop ratings for comment and recalculate mojo
	$S->_delete_ratings($sid, $cid, $uid);

	# Drop the commentcount cache value.
	$S->_count_cache_drop($sid);
	
	
	# Ok, now we've done it up right.
	return 1;
}
		
sub set_comment_display_defaults {
	my $S = shift;

    ##
    ##     SET DEFAULTS
    ##

    # orders: 'newest' 'oldest'
    if (! $S->session('commentorder')){
            if (  ($S->{UI}->{VARS}->{default_comment_order} eq 'oldest')
               || ($S->{UI}->{VARS}->{default_comment_order} eq 'newest')) {
               $S->session('commentorder', $S->{UI}->{VARS}->{default_comment_order});
            } else {
				$S->session('commentorder', 'newest');
			}
    }

    # ratings: 'unrate_highest' 'highest' 'lowest' 'dontcare'
    if (! $S->session('commentrating')){
            if (  ($S->{UI}->{VARS}->{default_comment_sort} eq 'unrate_highest')
               || ($S->{UI}->{VARS}->{default_comment_sort} eq 'highest')
               || ($S->{UI}->{VARS}->{default_comment_sort} eq 'lowest')
               || ($S->{UI}->{VARS}->{default_comment_sort} eq 'dontcare')) {
                    $S->session('commentrating', $S->{UI}->{VARS}->{default_comment_sort});
            } else {
				$S->session('commentrating', 'dontcare');
			}
    }
    
    # types: 'mixed' 'topical' 'editorial' 'all'
    if (! $S->session('commenttype')){
            if (  ($S->{UI}->{VARS}->{default_comment_view} eq 'mixed')
               || ($S->{UI}->{VARS}->{default_comment_view} eq 'topical')
               || ($S->{UI}->{VARS}->{default_comment_view} eq 'editorial')
               || ($S->{UI}->{VARS}->{default_comment_view} eq 'all')) {
                    $S->session('commenttype', $S->{UI}->{VARS}->{default_comment_view});
            } else {
				$S->session('commenttype', 'mixed');
			}
    }

    # modes: 'nested' 'flat' 'minimal' 'threaded' 'dthreaded' 'dminimal'
    if (! $S->session('commentmode')) {
		if (  ($S->{UI}->{VARS}->{default_comment_display} eq 'nested')
		   || ($S->{UI}->{VARS}->{default_comment_display} eq 'flat')
		   || ($S->{UI}->{VARS}->{default_comment_display} eq 'minimal')
		   || ($S->{UI}->{VARS}->{default_comment_display} eq 'dthreaded')
		   || ($S->{UI}->{VARS}->{default_comment_display} eq 'dminimal')
		   || ($S->{UI}->{VARS}->{default_comment_display} eq 'threaded')){
		     $S->session('commentmode', $S->{UI}->{VARS}->{default_comment_display});
		} else {
			$S->session('commentmode', 'threaded');
		}
    }

    ##
    ##      DONE SETTING DEFAULTS
    ##
}

			
sub display_comments {
	my $S = shift;
	my $sid = shift;
	my $pid = shift || 0;
	my $mode = shift;
	my $dispmode = $S->session('commentmode');
	my $type = $S->session('commenttype') || 'mixed';
	my $tool = $S->{CGI}->param('tool');
	my $qid = $S->{CGI}->param('qid');
	my $cgipid = $S->{CGI}->param('pid');
	my $cid = shift || $S->{CGI}->param('cid') || 0;
	my @cids = split /\D+/, $S->{CGI}->param('cids');
	my $op = $S->{CGI}->param('op');
	my ($start, $end, $level_start, $level_end, $item_start, $item_end) =
		$S->_get_comment_list_delimiters($sid, $dispmode);

	if($type eq 'none') {
		# If the user is trying to look at a particular comment,
		# fall back to mixed mode
		if($pid || $cid) {
			$type = 'mixed';
		} else {
			return '';
		}
	}

	my $dynamic;
	my $dynamicmode;
	if ($S->{UI}->{VARS}->{allow_dynamic_comment_mode}) {
		$dynamic = ($op eq 'dynamic') ? 1 : 0;
		$dynamicmode = $S->{CGI}->param('dynamicmode');
		if($dynamic) {
			if($dynamicmode) {
				# Expanded comment
				$mode = 'alone';
			} else {
				# Collapsed comment
				$mode = 'collapsed';
			}
		}
	} else {
		$dynamic = 0;
		$dynamicmode = 0;
	}


	if($S->_check_commentstatus($sid)==-1){	# If comments disabled, just bail out
		return '<b>Comments have been Disabled for this Article</b>';
	}	# This would only result from users viewing comments directly

	$S->_set_comment_order();
	$S->_set_comment_rating_thresh();
	$S->_set_comment_type();

	my $rating_choice;
	$S->_set_comment_rating_choice();
	
	$rating_choice = $S->session('ratingchoice');
	
	unless ($rating_choice) {
		if ($S->have_perm('comment_rate')) {
			$S->_set_comment_rating_choice('yes');
		}
	}

	# this is for attaching polls.  So the comments viewed with the poll 
	# are from the story that the poll was attached to.
	if ( $S->_does_poll_exist($sid) ) {
	
		# this if() is so that we only change the sid if its an attached poll,
		# not if its just a normal poll	
		if ( $S->get_sid_from_qid($sid) ) {
			$sid = $S->get_sid_from_qid($sid);
		}
	}

        my $select_this;
        my $order_by;
 	
	$S->set_comment_display_defaults();
	
	my $order = $S->session('commentorder') || 'newest';
	my $rating = $S->session('commentrating') || 'dontcare';
	
	if ($rating =~ /^unrate_/) {
		$order_by = qq|norate desc, |;
	}
	
	if ($rating =~ /highest/) {
		$order_by .= qq|points desc, |;
	} elsif ($rating eq 'lowest') {
		$order_by .= qq|points asc, |;
	}
	
	if ($order eq 'oldest') {
		$order_by .= qq|date asc|;
	} else {
		$order_by .= qq|date desc, cid desc|;
	}
	
	my $date_format = $S->date_format('date');
	my $short_date = $S->date_format('date', 'short');
	
	my $where = qq|sid = "$sid" AND cid > $pid|;
	
	my $storymode = $S->_check_story_mode($sid);
	
	if ($type eq 'topical' && $pid == 0) {
		$where .= qq| AND pending = 0|;
	} elsif ($type eq 'editorial' && $pid == 0) {
		$where .= qq| AND pending = 1|;
	} else {
		if (($storymode > -1 && $type ne 'all') && !$cid && $pid == 0) {
			$where .= qq| AND pending = 0|;
		}
	}
	
	$select_this = {
		DEBUG => 0,
		WHAT => qq|sid, cid, pid, $date_format as f_date, $short_date as mini_date, email, url, subject, comment, uid, points, lastmod AS numrate, points IN (NULL) AS norate, pending, sig_status, sig, commentip|,
 		FROM => 'comments',
		WHERE => qq|$where|,
 		ORDER_BY => $order_by
	};

	
	if ($mode eq 'alone' || $mode eq 'collapsed') {
		if(@cids) {
			my $cids = join ',', @cids;
			$select_this->{WHERE} = qq|sid = '$sid' AND cid IN ($cids)|;
			# Treat each comment we're fetching as toplevel
			$pid = 0;
		} else {
		$select_this->{WHERE} = qq|sid = "$sid" AND cid = $cid|;
	} 
	} 
	
	if ($cid && ($tool ne 'post') && ($mode ne 'alone') && ($mode ne 'collapsed')) {
		$select_this->{WHERE} = qq|sid = "$sid" AND cid >= $cid|;
	}
	
	my ($rv, $sth) = $S->db_select($select_this);
	$#{$S->{CURRENT_COMMENT_LIST}} = $rv;
	
	# Get all the comments
	my $i = 0;
	my %users;
	while (my $com = $sth->fetchrow_hashref()) {
		warn "Found comment: $com->{cid}\n" if ($DEBUG);

		# Set points and numrate to friendlier values if the comment
		# hasn't yet been rated
		$com->{points} = 'none'	unless defined($com->{points});
		$com->{numrate} = '0'	if ($com->{numrate} == '-1');

		# When grabbing a list of comments, treat them all as toplevel
		$com->{pid} = 0         if @cids;

		# Push this comment on the global list
		$S->{CURRENT_COMMENT_LIST}->[$i] = $com;
		# And add the index to its parent slot in the thread list
		push @{$S->{CURRENT_COMMENT_THREAD}->{$com->{pid}}}, $i;
		# And add the uid to the users list, so we can precache those
		$users{$com->{uid}} = 1;
		$i++;
	}
	$sth->finish();

	my $count_top = $cid || $pid;
	my $count = $S->_count_current_comments($count_top);
	warn "Count is $count\n" if ($DEBUG);
	$S->_set_comment_mode($count);
	warn "Set mode to ".$S->session('commentmode')."\n" if ($DEBUG);
	$dispmode = $S->session('commentmode');
	if ($dispmode eq 'dthreaded' || $dispmode eq 'dminimal') {
		$S->_setup_dynamic_blocks($sid);
	}
			
	# Prefetch user info
	my @u = keys(%users);
	$S->user_data(\@u);
	
	my $comment_start = "";

	# Make the initial rating form...
	$comment_start .= qq|<FORM NAME="rate" ACTION="%%rootdir%%/" METHOD="POST">
						<INPUT TYPE="hidden" NAME="sid" VALUE="$sid">
						<INPUT TYPE="hidden" NAME="op" VALUE="$op">
						<INPUT TYPE="hidden" NAME="pid" VALUE="$pid">| unless ($dynamic);
	
	# if it's a poll, add a line about the qid
	if ( $S->_does_poll_exist($sid) ) {
		$comment_start .= qq| <INPUT TYPE="hidden" NAME="qid" VALUE="$sid"> |;
	} elsif ( $qid ) {
		$comment_start .= qq| <INPUT TYPE="hidden" NAME="qid" VALUE="$qid"> |;
	}

	my $comments;
 	if (!$dynamic && ($dispmode eq 'minimal' || $dispmode eq 'dminimal')) {
 		$comments .= $start;
	} 	
	
	foreach my $i (@{$S->{CURRENT_COMMENT_THREAD}->{$pid}}) {
		warn "($pid) Looking at list item $i (cid: $S->{CURRENT_COMMENT_LIST}->[$i]->{cid}, pid: $S->{CURRENT_COMMENT_LIST}->[$i]->{pid})\n" if ($DEBUG);
		# Skip this if it's not the right level
		#if ($S->{CURRENT_COMMENT_LIST}->[$i]->{pid} != $pid) {
		#	warn "($pid) Wanted pid $pid. Skipping\n" if ($DEBUG);
		#	$i++;
		#	next;
		#} 
		if ($cid && ($S->{CURRENT_COMMENT_LIST}->[$i]->{cid} != $cid)) {
			warn "($pid) Right parent, but we want only one thread ($cid). Skipping.\n" if ($DEBUG);
			next;
		}
		
		# Skip the comment entirely if we don't have perm to see it
		if (($S->{UI}->{VARS}->{use_mojo}) &&
		    ($S->{CURRENT_COMMENT_LIST}->[$i]->{points} ne 'none') && 
			($S->{CURRENT_COMMENT_LIST}->[$i]->{points} < $S->{UI}->{VARS}->{rating_min}) &&
			($S->{TRUSTLEV} != 2) && 
			(!$S->have_perm('super_mojo'))) {
			warn "($pid) Permissions not granted. Skipping.\n" if ($DEBUG);
			next;
		}
				  
		
		# Otherwise, splice off this comment and get busy
		my $comment = $S->{CURRENT_COMMENT_LIST}->[$i];
		warn "($pid) We want this one! Formatting.\n" if ($DEBUG);
		
		# Set $i back to 0, because we don't know how many comments
		# we'll be pulling off the list after this...
		#$i = 0;
		
		$comment->{mode} = $mode;
		#$comment->{sid} = $sid;

		$comments .= qq|<DIV ID="$comment->{cid}">| if $dynamic;
		if($mode eq 'collapsed') {
			$comments .= $S->_get_comment_subject($sid, $pid, 'collapsed', $comment);
		} else {
		$comments .= $S->format_comment($comment);
		}
		$comments .= qq|</DIV>| if $dynamic;
	}

        if (!$dynamic && ($dispmode eq 'minimal' || $dispmode eq 'dminimal')) { 
                $comments .= $end;
        }

	#$sth->finish;
	
	my $comments_end = qq|</FORM>| unless $dynamic;
	
	if ($comments) {
		$comments = $comment_start.$comments.$comments_end;
	}
	delete $S->{CURRENT_COMMENT_LIST};
	delete $S->{CURRENT_COMMENT_THREAD};

	# I don't know why this line was here.
	# It made "seen stories" update on comment view
	# *only* if you weren't using the page cache.
	# I wrote it, but fucked if I know what I was thinking. --rusty
	#$S->update_seen_if_needed($sid) unless ($S->{UI}->{VARS}->{use_static_pages});   # does the seen stories work
	
	return $comments;
}


sub _count_current_comments {
	my $S = shift;
	my $pid = shift;
	my $count = shift || 0;
	
	if ($pid && !$count) {
		$count = 1;
	}
	
	foreach my $i (@{$S->{CURRENT_COMMENT_THREAD}->{$pid}}) {
		warn "($pid) Looking at list item $i (cid: $S->{CURRENT_COMMENT_LIST}->[$i]->{cid}, pid: $S->{CURRENT_COMMENT_LIST}->[$i]->{pid})\n" if ($DEBUG);

		if ($S->{CURRENT_COMMENT_LIST}->[$i]->{pid} != $pid) {
			warn "Wrong parent ($S->{CURRENT_COMMENT_LIST}->[$i]->{pid}). Skipping.\n" if ($DEBUG);
			next;
		}
		
		# Skip the comment entirely if we don't have perm to see it
		if (($S->{UI}->{VARS}->{use_mojo}) &&
		    ($S->{CURRENT_COMMENT_LIST}->[$i]->{points} ne 'none') && 
			($S->{CURRENT_COMMENT_LIST}->[$i]->{points} < $S->{UI}->{VARS}->{rating_min}) &&
			($S->{TRUSTLEV} != 2) && 
			(!$S->have_perm('super_mojo'))) {
			warn "($pid) Permissions not granted. Skipping.\n" if ($DEBUG);
			next;
		}
		
		$count++;
		warn "Incremented counter to $count, exploring thread\n" if ($DEBUG);
		$count = $S->_count_current_comments($S->{CURRENT_COMMENT_LIST}->[$i]->{cid}, $count);
	}
	
	return $count;
}

sub _get_comment_subject {
	my $S = shift;
	my $sid = shift;
	my $pid = shift;
	my $mode = shift;
	my $comment = shift;
	
	my $user = $S->user_data($comment->{uid});
	my $postername = $user->{nickname};
	my $ed_tag = '';
	if ($comment->{pending}) {
		$ed_tag = 'Editorial: ';
	}
			
	my $new = '';
	# Check for highest index
	if ($S->{UI}->{VARS}->{show_new_comments}) {
		if ($S->{UI}->{VARS}->{use_static_pages} && $S->{GID} eq 'Anonymous') {
			#$new = '%%new_'.$comment->{cid}.'%%';
			#warn "New is $new\n";
		} elsif ($S->{UID} >= 0) {
			my $highest = $S->story_highest_index($sid);
			if ($comment->{cid} > $highest) {
				$new = $S->{UI}->{BLOCKS}->{new_comment_marker};
		}
	}
	}

	my ($link,$open_link);
	my $openurl = "%%rootdir%%/comments/$sid";

	if(!$pid) {
		$openurl .= "/$comment->{cid}#$comment->{cid}";
	} else {
		$openurl .= "?pid=$pid#$comment->{cid}";
	}

	# Make the subject an expand link for dynamic mode, or an open link
	# otherwise.
	if($mode eq 'dminimal' || $mode eq 'dthreaded' || $mode eq 'collapsed') {
		$link = qq|javascript:void(toggle($comment->{cid}))|;
		$open_link = qq| [<a href="$openurl">open</a>]|;
	} else {
		$link = qq|$openurl|;
		$open_link = '';
	}

	my $member;
	if ($user->{sub}->{active}) {
		$member = $S->{UI}->{BLOCKS}->{"mark_$user->{perm_group}"};
		
	}

	# This should probably be made into a block
	return qq|%%norm_font%%$new $ed_tag<A CLASS="light" HREF="$link">$comment->{subject}</A> by $postername$member, %%norm_font_end%%%%smallfont%%$comment->{mini_date} (<B>$comment->{points} / $comment->{numrate}</B>)$open_link%%smallfont_end%%|;

}

sub _get_comment_list_delimiters {
	my $S = shift;
	my $sid = shift;
	my $dispmode = shift;
	my $depth = shift || 0;
	my $plus = $S->{UI}->{BLOCKS}->{dynamic_expand_link} || '+';
	my $minus = $S->{UI}->{BLOCKS}->{dynamic_collapse_link} || '-';
	my $pid = $S->{CGI}->param('pid');
	my $cid = $S->{CGI}->param('cid');

	my ($start, $end, $level_start, $level_end, $item_start, $item_end);

	if ($dispmode ne 'flat' && $dispmode ne 'nested' && $dispmode ne 'dthreaded' && $dispmode ne 'dminimal') {
		$start = '<UL>';
		$end = '</UL>';
		$level_start = '<UL>';
		$level_end = '</UL>';
		$item_start = '<LI>';
		$item_end = '</LI>';
	} elsif ($dispmode eq 'dthreaded' || $dispmode eq 'dminimal') {
		# We don't want to indent the first level
		if($depth <= 0) {
			$start = '';
			$end = '';
		} else {
			$start = '<DIV STYLE="margin-left: 2.5em">';
			$end = '</DIV>';
		}
		# If we're at the top level of a dthreaded thread, make a
		# collapse link. Otherwise, make an expand link.
		my($class,$text);
		if($depth <= 0
		   && ($dispmode eq 'dthreaded' || $pid || $cid)) {
			$class = 'dynexpanded';
			$text = $minus;
		} else {
			$class = 'dyncollapsed';
			$text = $plus;
		}

		$item_start = qq|<TABLE><TR>
			<TD VALIGN="top">%%norm_font%%<TT><A ID="toggle!cid!" STYLE="text-decoration:none" HREF="javascript:void(toggle(!cid!))">$text</A></TT>&nbsp;%%norm_font_end%%</TD>
			<TD><DIV CLASS="$class" ID="content!cid!">|;
		$item_end = qq|</DIV></TD></TR></TABLE>|;
	} elsif ($dispmode eq 'nested') {
		$start = '<DL>';
		$level_start = '<DT></DT><DD>';
		$end = '</DL>';
		$level_end = '</DD>';
	} 
		
	return ($start, $end, $level_start, $level_end, $item_start, $item_end);
}	

sub get_list {
	my $S = shift;
	my $sid = shift;
	my $pid = shift;
	my $dispmode = shift || $S->session('commentmode');
	my $depth = shift || 1;
	my $cid = $S->{CGI}->param('cid');
	my $plus = $S->{UI}->{BLOCKS}->{dynamic_expand_link} || '+';
	my $wait = $S->{UI}->{BLOCKS}->{dynamic_loading_link} || 'x';
	my @cids;
	
	my ($count, $newcount, $list, $nick, $start, $end, $level_start, $level_end, $item_start, $item_end);
	
	if (!$S->{UI}->{VARS}->{allow_dynamic_comment_mode}) {
		if ($dispmode eq 'dthreaded') {
			$dispmode = 'threaded';
		} elsif ($dispmode eq 'dminimal') {
			$dispmode = 'minimal';
		}
	}

	($start, $end, $level_start, $level_end, $item_start, $item_end) =
		$S->_get_comment_list_delimiters($sid, $dispmode, $depth);

	foreach my $i (@{$S->{CURRENT_COMMENT_THREAD}->{$pid}}) {
		warn "($pid) Looking at list item $i (cid: $S->{CURRENT_COMMENT_LIST}->[$i]->{cid}, pid: $S->{CURRENT_COMMENT_LIST}->[$i]->{pid})\n" if ($DEBUG);
		# Skip this if it's not the right level
		#if ($S->{CURRENT_COMMENT_LIST}->[$i]->{pid} != $pid) {
		#	warn "($pid) Wanted pid $pid. Skipping\n" if ($DEBUG);
		#	$i++;
		#	next;
		#} 
		
		# Remove the comment entirely if we don't have perm
		# to see it
		if (($S->{UI}->{VARS}->{use_mojo}) &&
		    ($S->{CURRENT_COMMENT_LIST}->[$i]->{points} ne 'none') && 
			($S->{CURRENT_COMMENT_LIST}->[$i]->{points} < $S->{UI}->{VARS}->{rating_min}) &&
			($S->{TRUSTLEV} != 2) && 
			(!$S->have_perm('super_mojo'))) {
			warn "($pid) Permission not valid. Skipping.\n" if ($DEBUG);
			#splice(@{$S->{CURRENT_COMMENT_LIST}}, $i, 1);
			next;
		}
				  
		
		# Otherwise, splice off this comment and get busy
		#my $S->{CURRENT_COMMENT_LIST}->[$i] = $S->{CURRENT_COMMENT_LIST}->[$i];
		warn "($pid) We want this one! Formatting.\n" if ($DEBUG);
		push @cids, $S->{CURRENT_COMMENT_LIST}->[$i]->{cid};

		# Set $i back to 0, because we don't know how many comments
		# we'll be pulling off the list after this...
		#$i = 0;
				 
		my $user = $S->user_data($S->{CURRENT_COMMENT_LIST}->[$i]->{uid});
		$S->{CURRENT_COMMENT_LIST}->[$i]->{points} = 'none'	unless defined($S->{CURRENT_COMMENT_LIST}->[$i]->{points});
		$S->{CURRENT_COMMENT_LIST}->[$i]->{numrate} = '0' if ($S->{CURRENT_COMMENT_LIST}->[$i]->{numrate} == '-1');


		if ($dispmode eq 'nested' || $dispmode eq 'flat') {
			$list .= $level_start;
			$list .= $S->format_comment($S->{CURRENT_COMMENT_LIST}->[$i]);
			$list .= $level_end;
		} else {
			my $item_start_subst = $item_start;
			$item_start_subst =~ s/!cid!/$S->{CURRENT_COMMENT_LIST}->[$i]->{cid}/g;
			$list .= $item_start_subst.$S->_get_comment_subject($sid, $pid, $dispmode, $S->{CURRENT_COMMENT_LIST}->[$i]).$item_end;
			}
			
		if ($dispmode ne 'nested' && $dispmode ne 'flat') {
		 	my($sublist,@subcids) = $S->get_list($sid, $S->{CURRENT_COMMENT_LIST}->[$i]->{cid}, $dispmode, $depth+1);
			$list .= $sublist;
			push @cids, (@subcids);
		}
			
	}
	
		$list = $start.$list.$end if ($list);

	if(@cids && ($dispmode eq 'dminimal' || $dispmode eq 'dthreaded')) {
		# Add a bit of script to save the replies list
		my $cids = join ',', @cids;
		if(scalar(@cids) == 1) {
			$cids .= ',null';
		}
		$list .= qq|
<SCRIPT LANGUAGE="JavaScript" TYPE="text/javascript"><!--
replies[$pid] = new Array($cids);
//--></SCRIPT>|;
	}
	return ($list,@cids);
}

sub anon_comment_warn {
	my $S = shift;
	my $subject = shift;
	if (!$S->have_perm( 'comment_post' )) {
		my $time = localtime;
		warn "<< WARNING >> Anonymous comment disallowed at $time. IP: $S->{REMOTE_IP}, Subject: $subject\n";
		return 0;
	}
	return 1;
}

sub fetch_highest_cid {
	my $S = shift;
	my $sid = shift;
	
	my ($rv, $sth) = $S->db_select({
		WHAT => 'cid',
		FROM => 'comments',
		WHERE => qq|sid = "$sid"|,
		ORDER_BY => 'cid DESC',
		LIMIT => 1
	});
	my $highest = $sth->fetchrow();
	$sth->finish();
	return $highest;
}


sub _comment_breakdown {
	my $S = shift;
	my $sid = shift;
	my ($topical, $editorial, $pending, $highest);
	
	my $resource = $sid.'_comments';
	my $element = $sid.'_commentcounts';
	
	if (my $cached = $S->cache->fetch_data({resource => $resource, 
	                                        element => $element})) {
		$topical   = $cached->{topical};
		$editorial = $cached->{editorial};
		$pending   = $cached->{pending};
		$highest   = $cached->{highest};
		
		return ($topical, $editorial, $pending, $highest);
	}
	
	my $cache_me;
	my ($rv, $sth) = $S->db_select({
		WHAT => 'pending, count(*)',
		FROM => 'comments',
		WHERE => qq|sid = "$sid"|,
		GROUP_BY => 'pending'
	});
	
	while (my $row = $sth->fetchrow_arrayref()) {
		($row->[0] == 0) ? $topical = $row->[1] : $editorial = $row->[1];
	}
	$sth->finish();
	$cache_me->{topical} = $topical || 0;
	$cache_me->{editorial} = $editorial || 0;
	
	if ($S->{UI}->{VARS}->{use_mojo}) {
		
		my ($rv, $sth) = $S->db_select({
			WHAT => 'COUNT(*)',
			FROM => 'comments',
			WHERE => qq|sid = "$sid" AND points < $S->{UI}->{VARS}->{rating_min}|
		});
		
		$pending = $sth->fetchrow() || 0;
		$sth->finish();
		$cache_me->{pending} = $pending;	
	}

	$highest = $S->fetch_highest_cid($sid);
	$cache_me->{highest} = $highest;
	
	$S->cache->cache_data({resource => $resource,
	                       element => $element,
	                       data => $cache_me});

	return ($topical, $editorial, $pending, $highest);
}

sub _commentcount {
	my $S = shift;
	my $sid = shift;
                
	my $count = 0;  
                
	my($a,$b,$c,$d) = $S->_comment_breakdown($sid);
	$count = $a + $b;
        
	return $count;
}

sub _comment_highest {
	my $S = shift;
	my $sid = shift;
	
	my ($a,$b,$c,$d) = $S->_comment_breakdown($sid);
	return $d;
}

sub _count_cache_drop {
	my $S = shift;
	my $sid = shift;
	my $resource = $sid.'_comments';
	my $element = $sid.'_commentcounts';
	
	# Drop our memory cache for this story
	$S->cache->clear({resource => $resource, element => $element});
	$S->cache->stamp_cache($resource, time(), 1);
	$S->_commentcount($sid);
	
	return;
}	

1;	
