###
### checklangs.tcl
###

# This script is not part of the Scid source code; it is a standalone
# program which verifies that every language file has the same
# translation commands in the same order as english.tcl.

array set codes {
  czech C
  deutsch D
  francais F
  hungary H
  italian I
  nederlan N
  norsk O
  polish P
  portbr B
  serbian Y
  spanish S
  swedish W
}

set languages {czech deutsch francais hungary italian nederlan norsk polish
                portbr spanish swedish serbian
}


proc checkfile {code langfile} {
  # Read this language file and the english file:

  set f [open english.tcl r]
  set data [read $f]
  close $f
  set englishData [split $data "\n"]
  set englishNames {}

  set f [open $langfile.tcl r]
  set data [read $f]
  close $f
  set langData [split $data "\n"]
  set langNames {}

  foreach line $langData {
    set fields [split $line]
    set command [lindex $fields 0]
    set lang [lindex $fields 1]
    set name [lindex $fields 2]
    if {$lang == $code  &&  ($command == "menuText" || $command == "translate")} {
      lappend langNames $command:$name
    }
  }

  set lastMatch -1
  foreach line $englishData {
    set fields [split $line]
    set command [lindex $fields 0]
    set lang [lindex $fields 1]
    set name [lindex $fields 2]
    if {$lang == "E"  &&  ($command == "menuText" || $command == "translate")} {
      set thisMatch [lsearch -exact $langNames $command:$name]
      if {$thisMatch < 0} {
        puts "$langfile - MISSING: $name"
      } else {
        if {$thisMatch != $lastMatch + 1} {
          puts "$langfile - OUT OF ORDER: $command $lang $name"
        }
        set lastMatch $thisMatch
      }
    }
  }
}

if {[llength $argv] == 0} { set argv $languages }

foreach language $argv {
  if {[info exists codes($language)]} {
    checkfile $codes($language) $language
  } else {
    puts "No such language file: $language"
  }
}

#foreach {code langfile} $languages {
#}