'\"
'\" Generated from file './img-pixmap.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1995-2003 Jan Nijtmans <nijtmans@users.sourceforge.com>
'\"
'\" -*- tcl -*- doctools
.so man.macros
.TH "img-pixmap" n 1.3  "Img"
.BS
.SH "NAME"
img-pixmap \- Img, Pixmap Image type (pixmap)
.SH "SYNOPSIS"
package require \fBTk \fR
.sp
package require \fBimg::pixmap  ?1.3?\fR
.sp
\fBimage\fR \fBcreate pixmap\fR ?\fIname\fR? ?\fIoptions\fR?\fR
.sp
\fIimageName\fR \fBoption\fR ?\fIarg arg ...\fR?\fR
.sp
\fIimageName\fR \fBcget\fR \fIoption\fR\fR
.sp
\fIimageName\fR \fBconfigure\fR ?\fBoption\fR? ?\fIvalue option value ...\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
The package \fBimg::pixmap\fR is a sub-package of
\fBImg\fR. It can be loaded as a part of the complete Img support,
via \fBpackage require Img\fR, or on its own, via
\fBpackage require img::pixmap\fR.
.PP
Like all packages of \fBImg\fR it does \fInot\fR provide new
commands, but extends the existing \fBTk\fR command \fBimage\fR.
.PP
In contrast to all other sub packages this packages does \fInot\fR
extend \fBTk\fR's \fBphoto\fR image type, but rather provides a
completely new image type, on the same level as \fBphoto\fR and
\fBbitmap\fR.
.SH "CREATING PIXMAPS"
Like all images, pixmaps are created using the \fBimage create\fR
command.
.TP
\fBimage\fR \fBcreate pixmap\fR ?\fIname\fR? ?\fIoptions\fR?\fR
Pixmaps support the following options:
.RS
.TP
\fB-data\fR \fIstring\fR
Specifies the contents of the source pixmap as a string. The string
must adhere to X11 pixmap format (e.g., as generated by the pixmap
program). If both the \fB-data\fR and \fB-file\fR options are
specified, the \fB-data\fR option takes precedence.
.TP
\fB-file\fR \fIname\fR
\fIname\fR gives the name of a file whose contents define the source
pixmap. The file must adhere to X11 pixmap format (e.g., as generated
by the pixmap program).
.RE
.SH "IMAGE COMMAND"
When a pixmap image is created, Tk also creates a new com mand whose
name is the same as the image.  This command may be used to invoke
various operations on the image.  It has the following general form:
.TP
\fIimageName\fR \fBoption\fR ?\fIarg arg ...\fR?\fR
\fBOption\fR and the args determine the exact behavior of the
command. The following commands are possible for pixmap images:
.TP
\fIimageName\fR \fBcget\fR \fIoption\fR\fR
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBimage create pixmap\fR command.
.TP
\fIimageName\fR \fBconfigure\fR ?\fBoption\fR? ?\fIvalue option value ...\fR?\fR
Query or modify the configuration options for the image. If no option
is specified, returns a list describing all of the available options
for \fIimageName\fR (see \fBTk_ConfigureInfo\fR for information on the
format of this list). If \fIoption\fR is specified with no
\fIvalue\fR, then the command returns a list describing the one named
option (this list will be identi cal to the corresponding sublist of
the value returned if no option is specified).  If one or more
\fIoption-value\fR pairs are specified, then the command modifies the
given option(s) to have the given value(s); in this case the command
returns an empty string. \fBOption\fR may have any of the values
accepted by the \fBimage create pixmap\fR command.
'\" -*- tcl -*- doctools = format-footer.inc
.SH "SEE ALSO"
img-bmp, img-gif, img-ico, img-intro, img-jpeg, img-pcx, img-pixmap, img-png, img-ppm, img-ps, img-sgi, img-sun, img-tga, img-tiff, img-window, img-xbm, img-xpm
.SH "KEYWORDS"
image handling, pixmap, tk
.SH "COPYRIGHT"
.nf
Copyright (c) 1995-2003 Jan Nijtmans <nijtmans@users.sourceforge.com>
.fi