// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __magnifier_h__
#define __magnifier_h__

#include "widget.h"

class Magnifier : public Widget {
private:
  Pixmap thumbnail;        // current gterm thumbnail pixmap
  double crosshairSize;    // size of crosshair (diameter)
  double crosshairAngle;   // angle of rotation (radians)
  GC crosshairGC;          // gc for crosshairs
  int useCrosshair;        // flag to render crosshair
  int needsUpdate;         // flag to indicate update needed

protected:
  virtual void clearPixmap() =0;

private:
  int updatePixmap(const BBox&); // renders image/graphics into pixmap
  void update();
  void invalidPixmap();

public:
  Magnifier(Tcl_Interp*, Tk_Canvas, Tk_Item*);

#if __GNUC__ >= 3
  int parse(istringstream&);          // parse subcommands
#else
  int parse(istrstream&);          // parse subcommands
#endif

  // SubCommandFunctions

  void crosshairCmd(int);
  void getBBoxCmd();
  void updateCmd(Pixmap);
  void updateCmd(Pixmap, double, double);
};

#endif

