// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "rgb.h"

// RGBColor

RGBColor::RGBColor()
{
  red = green = blue = 0;
}

RGBColor::RGBColor(float r, float g, float b)
{
  red = r;
  green = g;
  blue = b;
}

istream& operator>>(istream& s, RGBColor& c)
{
  s >> c.red >> c.green >> c.blue;
  return s;
}

ostream& operator<<(ostream& s, RGBColor& c)
{
  s.setf(ios::fixed, ios::floatfield);
  s << setw(8) << setprecision(6) 
    << c.red << " " << c.green << " " << c.blue << endl;
  return s;
}
