#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CreateMenuBar {} {
    global ds9
    global menu
    global debug
    global tcl_platform

    SetLanguage

    menu $ds9(mb) -selectcolor $menu(selectcolor)
    $ds9(mb) add cascade -label $menu(file) -menu $ds9(mb).file
    $ds9(mb) add cascade -label $menu(edit) -menu $ds9(mb).edit
    $ds9(mb) add cascade -label $menu(frame) -menu $ds9(mb).frame
    $ds9(mb) add cascade -label $menu(bin) -menu $ds9(mb).bin
    $ds9(mb) add cascade -label $menu(zoom) -menu $ds9(mb).zoom
    $ds9(mb) add cascade -label $menu(scale) -menu $ds9(mb).scale
    $ds9(mb) add cascade -label $menu(color) -menu $ds9(mb).color
    $ds9(mb) add cascade -label $menu(region) -menu $ds9(mb).region
    $ds9(mb) add cascade -label $menu(wcs) -menu $ds9(mb).wcs
    $ds9(mb) add cascade -label $menu(analysis) -menu $ds9(mb).analysis
    $ds9(mb) add cascade -label $menu(help) -menu $ds9(mb).help

    # File Menu

    menu $ds9(mb).file -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 File"
    $ds9(mb).file add command -label $menu(file,about) -command AboutBox
    $ds9(mb).file add separator
    $ds9(mb).file add command -label $menu(file,open) -command OpenFits
    $ds9(mb).file add cascade -label $menu(file,openother) \
	-menu $ds9(mb).file.open
    $ds9(mb).file add separator
    $ds9(mb).file add cascade -label $menu(file,preserve) \
	-menu $ds9(mb).file.preserve
    $ds9(mb).file add separator
    $ds9(mb).file add command -label $menu(file,saveimage) \
	-command SaveImageDialog
    $ds9(mb).file add command -label $menu(file,savefits) \
	-command SaveFitsDialog
    $ds9(mb).file add command -label $menu(file,savempeg) \
	-command SaveMPEGDialog

#    $ds9(mb).file add separator
#    $ds9(mb).file add command -label $menu(file,savestate) -command SaveState
#    $ds9(mb).file add command -label $menu(file,loadstate) -command LoadState
    $ds9(mb).file add separator
    $ds9(mb).file add command -label $menu(file,header) \
	-command DisplayHeaderMenu 
    $ds9(mb).file add separator
    $ds9(mb).file add command -label $menu(file,xpa) \
	-command DisplayXPAInfo
    $ds9(mb).file add command -label $menu(file,source) \
	-command OpenSource
    $ds9(mb).file add separator
    $ds9(mb).file add command -label $menu(file,print) -command Print
    $ds9(mb).file add command -label $menu(file,page) -command PageSetupDialog
    $ds9(mb).file add separator
    $ds9(mb).file add command -label $menu(file,exit) -command QuitDS9

    menu $ds9(mb).file.open -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 File Open"
    $ds9(mb).file.open add command -label "Open Array..." -command OpenArray
    $ds9(mb).file.open add command -label "Open URL..." -command OpenURL
    $ds9(mb).file.open add separator
    $ds9(mb).file.open add command -label "Open RGB Fits Image..." \
	-command OpenRGBImageFits
    $ds9(mb).file.open add command -label "Open RGB Fits Cube..." \
	-command OpenRGBCubeFits
    $ds9(mb).file.open add command -label "Open RGB Array..." \
	-command OpenRGBArray
    $ds9(mb).file.open add separator
    $ds9(mb).file.open add command -label "Open Multi Ext as Data Cube..." \
	-command OpenDataCubeFits
    $ds9(mb).file.open add separator
    $ds9(mb).file.open add command -label "Open Mosaic IRAF..." \
	-command OpenMosaicImageIRAFFits
    $ds9(mb).file.open add command -label "Open Mosaic IRAF Segment..." \
	-command OpenMosaicIRAFFits
    $ds9(mb).file.open add separator
    $ds9(mb).file.open add command -label "Open Mosaic WCS..." \
	-command OpenMosaicImageWCSFits
    $ds9(mb).file.open add command -label "Open Mosaic WCS Next..." \
	-command OpenMosaicImageNextWCSFits
    $ds9(mb).file.open add command -label "Open Mosaic WCS Segment..." \
	-command OpenMosaicWCSFits
    $ds9(mb).file.open add separator
    $ds9(mb).file.open add command -label "Open Mosaic WFPC2..." \
	-command OpenMosaicImageWFPC2Fits

    menu $ds9(mb).file.preserve -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 File Preserve"
    $ds9(mb).file.preserve add checkbutton -label "Scale" \
	-variable scale(preserve) -command PreserveScale
    $ds9(mb).file.preserve add checkbutton -label "Pan" \
	-variable panzoom(preserve) -command PreservePan
    $ds9(mb).file.preserve add checkbutton -label "Regions" \
	-variable marker(preserve) -command PreserveMarker

    # Edit Menu

    menu $ds9(mb).edit -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Edit"
    $ds9(mb).edit add command -label $menu(edit,undo) -command UndoFrame
    $ds9(mb).edit add separator
    $ds9(mb).edit add command -label $menu(edit,cut) -command CutFrame
    $ds9(mb).edit add command -label $menu(edit,copy) -command CopyFrame
    $ds9(mb).edit add command -label $menu(edit,paste) -command PasteFrame
    $ds9(mb).edit add separator
    $ds9(mb).edit add radiobutton -label $menu(edit,default) \
	-variable ds9(mode) -value none -command ChangeMode
    $ds9(mb).edit add radiobutton -label $menu(edit,pointer) \
	-variable ds9(mode) -value pointer -command ChangeMode
    $ds9(mb).edit add radiobutton -label $menu(edit,crosshair) \
	-variable ds9(mode) -value crosshair -command ChangeMode
    $ds9(mb).edit add radiobutton -label $menu(edit,colorbar) \
	-variable ds9(mode) -value colorbar -command ChangeMode
    $ds9(mb).edit add radiobutton -label $menu(edit,pan) \
	-variable ds9(mode) -value pan -command ChangeMode
    $ds9(mb).edit add radiobutton -label $menu(edit,zoom) \
	-variable ds9(mode) -value zoom -command ChangeMode
    $ds9(mb).edit add radiobutton -label $menu(edit,rotate) \
	-variable ds9(mode) -value rotate -command ChangeMode
    $ds9(mb).edit add radiobutton -label $menu(edit,examine) \
	-variable ds9(mode) -value examine -command ChangeMode
    $ds9(mb).edit add separator
    $ds9(mb).edit add cascade -label $menu(edit,preferences) \
	-menu $ds9(mb).prefs

    # Prefs Menu

    menu $ds9(mb).prefs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Preferences"
    $ds9(mb).prefs add cascade -label "File Menu" -menu $ds9(mb).prefs.file
    $ds9(mb).prefs add cascade -label "Edit Menu" -menu $ds9(mb).prefs.edit
    $ds9(mb).prefs add cascade -label "Frame Menu" -menu $ds9(mb).prefs.frame
    $ds9(mb).prefs add cascade -label "Bin Menu" -menu $ds9(mb).prefs.bin
    $ds9(mb).prefs add cascade -label "Zoom Menu" -menu $ds9(mb).prefs.zoom
    $ds9(mb).prefs add cascade -label "Scale Menu" -menu $ds9(mb).prefs.scale
    $ds9(mb).prefs add cascade -label "Color Menu" -menu $ds9(mb).prefs.color
    $ds9(mb).prefs add cascade -label "Region Menu" -menu $ds9(mb).prefs.region
    $ds9(mb).prefs add cascade -label "WCS Menu" -menu $ds9(mb).prefs.wcs
    $ds9(mb).prefs add cascade -label "Analysis Menu" \
	-menu $ds9(mb).prefs.analysis
    $ds9(mb).prefs add separator
#    $ds9(mb).prefs add cascade -label "Language" -menu $ds9(mb).prefs.language
    $ds9(mb).prefs add cascade -label "Background Color" \
	-menu $ds9(mb).prefs.bg
    $ds9(mb).prefs add cascade -label "Blank/Inf/NaN Color" \
	-menu $ds9(mb).prefs.nan
    $ds9(mb).prefs add cascade -label "View" -menu $ds9(mb).prefs.view
    $ds9(mb).prefs add cascade -label "Info Panel" -menu $ds9(mb).prefs.info
    $ds9(mb).prefs add cascade -label "Default Menu Font" \
	-menu $ds9(mb).prefs.font
    $ds9(mb).prefs add cascade -label "Mosaics" -menu $ds9(mb).prefs.mosaic
    $ds9(mb).prefs add cascade -label "Panner" -menu $ds9(mb).prefs.panner
    $ds9(mb).prefs add cascade -label "Magnifier" \
	-menu $ds9(mb).prefs.magnifier
    $ds9(mb).prefs add cascade -label "Truecolor Colorbar" \
	-menu $ds9(mb).prefs.colorbar
    $ds9(mb).prefs add cascade -label "Dialog Box" -menu $ds9(mb).prefs.dialog
    $ds9(mb).prefs add cascade -label "Pan" -menu $ds9(mb).prefs.pan
    $ds9(mb).prefs add cascade -label "Print Coordinates" \
	-menu $ds9(mb).prefs.coord
    $ds9(mb).prefs add cascade -label "Examine" -menu $ds9(mb).prefs.examine
    $ds9(mb).prefs add cascade -label "Misc" -menu $ds9(mb).prefs.misc
    $ds9(mb).prefs add command -label "HTTP..." -command HTTPDefaultDialog
    $ds9(mb).prefs add separator
    $ds9(mb).prefs add command -label "Save Preferences" -command SavePrefs
    $ds9(mb).prefs add command -label "Clear Preferences" -command ClearPrefs

    # File Prefs

    menu $ds9(mb).prefs.file -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.file add command -label "Print..." \
	-command "PrefsPrintDialog ps"
    $ds9(mb).prefs.file add command -label "Page Setup..." \
	-command PrefsPageSetupDialog

    # Frame Prefs

    menu $ds9(mb).prefs.frame -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.frame add cascade -label "Tile" \
	-menu $ds9(mb).prefs.frame.tile
    $ds9(mb).prefs.frame add cascade -label "Blink Interval" \
	-menu $ds9(mb).prefs.frame.blink
    $ds9(mb).prefs.frame add separator
    $ds9(mb).prefs.frame add checkbutton -label "Auto Size" \
	-variable canvas(auto) -command UpdateView
    $ds9(mb).prefs.frame add separator
    $ds9(mb).prefs.frame add radiobutton -label "256x256" \
	-variable canvas(size) -value 256 -command UpdateView
    $ds9(mb).prefs.frame add radiobutton -label "512x512" \
	-variable canvas(size) -value 512 -command UpdateView
    $ds9(mb).prefs.frame add radiobutton -label "1024x1024" \
	-variable canvas(size) -value 1024 -command UpdateView

    # Frame Tile Prefs

    menu $ds9(mb).prefs.frame.tile -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.frame.tile add radiobutton -label "Grid" \
	-variable prefs(tile,mode) -value grid
    $ds9(mb).prefs.frame.tile add radiobutton -label "Column" \
	-variable prefs(tile,mode) -value column
    $ds9(mb).prefs.frame.tile add radiobutton -label "Row" \
	-variable prefs(tile,mode) -value row

    # Frame Blink Prefs

    menu $ds9(mb).prefs.frame.blink -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.frame.blink add radiobutton -label ".125 Second" \
	-variable prefs(blink,interval) -value 125
    $ds9(mb).prefs.frame.blink add radiobutton -label ".25 Second" \
	-variable prefs(blink,interval) -value 250
    $ds9(mb).prefs.frame.blink add radiobutton -label ".5 Second" \
	-variable prefs(blink,interval) -value 500
    $ds9(mb).prefs.frame.blink add radiobutton -label "1 Second" \
	-variable prefs(blink,interval) -value 1000
    $ds9(mb).prefs.frame.blink add radiobutton -label "2 Seconds" \
	-variable prefs(blink,interval) -value 2000
    $ds9(mb).prefs.frame.blink add radiobutton -label "4 Seconds" \
	-variable prefs(blink,interval) -value 4000
    $ds9(mb).prefs.frame.blink add radiobutton -label "8 Seconds" \
	-variable prefs(blink,interval) -value 8000

    # Edit Prefs

    menu $ds9(mb).prefs.edit -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.edit add radiobutton -label "None" \
	-variable prefs(ds9,mode) -value none
    $ds9(mb).prefs.edit add radiobutton -label "Pointer" \
	-variable prefs(ds9,mode) -value pointer
    $ds9(mb).prefs.edit add radiobutton -label "Crosshair" \
	-variable prefs(ds9,mode) -value crosshair
    $ds9(mb).prefs.edit add radiobutton -label "Colorbar" \
	-variable prefs(ds9,mode) -value colorbar
    $ds9(mb).prefs.edit add radiobutton -label "Pan" \
	-variable prefs(ds9,mode) -value pan
    $ds9(mb).prefs.edit add radiobutton -label "Zoom" \
	-variable prefs(ds9,mode) -value zoom
    $ds9(mb).prefs.edit add radiobutton -label "Rotate" \
	-variable prefs(ds9,mode) -value rotate
    $ds9(mb).prefs.edit add radiobutton -label "Examine" \
	-variable prefs(ds9,mode) -value examine

    # Bin Prefs

    menu $ds9(mb).prefs.bin -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.bin add radiobutton -label "Average" \
	-variable prefs(bin,function) -value average
    $ds9(mb).prefs.bin add radiobutton -label "Sum" \
	-variable prefs(bin,function) -value sum
    $ds9(mb).prefs.bin add separator
    $ds9(mb).prefs.bin add radiobutton -label "Block 1" \
	-variable prefs(bin,factor) -value 1
    $ds9(mb).prefs.bin add radiobutton -label "Block 2" \
	-variable prefs(bin,factor) -value 2
    $ds9(mb).prefs.bin add radiobutton -label "Block 4" \
	-variable prefs(bin,factor) -value 4
    $ds9(mb).prefs.bin add radiobutton -label "Block 8" \
	-variable prefs(bin,factor) -value 8
    $ds9(mb).prefs.bin add radiobutton -label "Block 16" \
	-variable prefs(bin,factor) -value 16
    $ds9(mb).prefs.bin add radiobutton -label "Block 32" \
	-variable prefs(bin,factor) -value 32
    $ds9(mb).prefs.bin add radiobutton -label "Block 64" \
	-variable prefs(bin,factor) -value 64
    $ds9(mb).prefs.bin add radiobutton -label "Block 128" \
	-variable prefs(bin,factor) -value 128
    $ds9(mb).prefs.bin add separator
    $ds9(mb).prefs.bin add radiobutton -label "128x128" \
	-variable prefs(bin,buffersize) -value 128
    $ds9(mb).prefs.bin add radiobutton -label "256x256" \
	-variable prefs(bin,buffersize) -value 256
    $ds9(mb).prefs.bin add radiobutton -label "512x512" \
	-variable prefs(bin,buffersize) -value 512
    $ds9(mb).prefs.bin add radiobutton -label "1024x1024" \
	-variable prefs(bin,buffersize) -value 1024
    $ds9(mb).prefs.bin add radiobutton -label "2048x2048" \
	-variable prefs(bin,buffersize) -value 2048
    $ds9(mb).prefs.bin add radiobutton -label "4096x4096" \
	-variable prefs(bin,buffersize) -value 4096
    $ds9(mb).prefs.bin add separator
    $ds9(mb).prefs.bin add checkbutton -label "Smooth" \
	-variable prefs(bin,smooth)
    $ds9(mb).prefs.bin add separator
    $ds9(mb).prefs.bin add radiobutton -label "BoxCar" \
	-variable prefs(bin,smooth,function) -value boxcar
    $ds9(mb).prefs.bin add radiobutton -label "TopHat" \
	-variable prefs(bin,smooth,function) -value tophat
    $ds9(mb).prefs.bin add radiobutton -label "Gaussian" \
	-variable prefs(bin,smooth,function) -value gaussian

    # Zoom Prefs

    menu $ds9(mb).prefs.zoom -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.zoom add checkbutton -label "Align to WCS" \
	-variable prefs(wcs,align)
    $ds9(mb).prefs.zoom add cascade -label "Align Coord System" \
	-menu $ds9(mb).prefs.zoom.align
    $ds9(mb).prefs.zoom add separator
    $ds9(mb).prefs.zoom add radiobutton -label "1/32" \
	-variable prefs(zoom) -value 0.03125
    $ds9(mb).prefs.zoom add radiobutton -label "1/16" \
	-variable prefs(zoom) -value 0.0625
    $ds9(mb).prefs.zoom add radiobutton -label "1/8" \
	-variable prefs(zoom) -value 0.125
    $ds9(mb).prefs.zoom add radiobutton -label "1/4" \
	-variable prefs(zoom) -value 0.25
    $ds9(mb).prefs.zoom add radiobutton -label "1/2" \
	-variable prefs(zoom) -value 0.5
    $ds9(mb).prefs.zoom add radiobutton -label "1" \
	-variable prefs(zoom) -value 1
    $ds9(mb).prefs.zoom add radiobutton -label "2" \
	-variable prefs(zoom) -value 2
    $ds9(mb).prefs.zoom add radiobutton -label "4" \
	-variable prefs(zoom) -value 4
    $ds9(mb).prefs.zoom add radiobutton -label "8" \
	-variable prefs(zoom) -value 8
    $ds9(mb).prefs.zoom add radiobutton -label "16" \
	-variable prefs(zoom) -value 16
    $ds9(mb).prefs.zoom add radiobutton -label "32" \
	-variable prefs(zoom) -value 32
    $ds9(mb).prefs.zoom add separator
    $ds9(mb).prefs.zoom add radiobutton  -label "None" \
	-variable prefs(orient) -value none
    $ds9(mb).prefs.zoom add radiobutton  -label "Invert X" \
	-variable prefs(orient) -value x
    $ds9(mb).prefs.zoom add radiobutton -label "Invert Y" \
	-variable prefs(orient) -value y
    $ds9(mb).prefs.zoom add radiobutton -label "Invert X&Y" \
	-variable prefs(orient) -value xy
    $ds9(mb).prefs.zoom add separator
    $ds9(mb).prefs.zoom add radiobutton -label "0 deg" \
	-variable prefs(rotate) -value 0 
    $ds9(mb).prefs.zoom add radiobutton -label "90 deg" \
	-variable prefs(rotate) -value 90
    $ds9(mb).prefs.zoom add radiobutton -label "180 deg" \
	-variable prefs(rotate) -value 180
    $ds9(mb).prefs.zoom add radiobutton -label "270 deg" \
	-variable prefs(rotate) -value 270

    menu $ds9(mb).prefs.zoom.align -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.zoom.align add radiobutton -label "WCS" \
	-variable prefs(wcs,align,system) -value wcs
    $ds9(mb).prefs.zoom.align add cascade -label "Multiple WCS" \
	-menu $ds9(mb).prefs.zoom.align.wcs
    $ds9(mb).prefs.zoom.align add separator
    $ds9(mb).prefs.zoom.align add radiobutton -label "Equatorial B1950" \
	-variable prefs(wcs,align,sky) -value fk4
    $ds9(mb).prefs.zoom.align add radiobutton -label "Equatorial J2000" \
	-variable prefs(wcs,align,sky) -value fk5
    $ds9(mb).prefs.zoom.align add radiobutton -label "ICRS" \
	-variable prefs(wcs,align,sky) -value icrs
    $ds9(mb).prefs.zoom.align add radiobutton -label "Galactic" \
	-variable prefs(wcs,align,sky) -value galactic
    $ds9(mb).prefs.zoom.align add radiobutton -label "Ecliptic" \
	-variable prefs(wcs,align,sky) -value ecliptic

    menu $ds9(mb).prefs.zoom.align.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$ds9(mb).prefs.zoom.align.wcs add radiobutton -label "WCS $l" \
	    -variable prefs(wcs,align,system) -value "wcs$l"
    }

    # Scale Prefs

    menu $ds9(mb).prefs.scale -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.scale add radiobutton -label Linear \
	-variable prefs(scale) -value linear
    $ds9(mb).prefs.scale add radiobutton -label Log \
	-variable prefs(scale) -value log
    $ds9(mb).prefs.scale add radiobutton -label Squared \
	-variable prefs(scale) -value squared
    $ds9(mb).prefs.scale add radiobutton -label "Square Root" \
	-variable prefs(scale) -value sqrt
    $ds9(mb).prefs.scale add radiobutton -label "Histogram Equalization" \
	-variable prefs(scale) -value histequ
    $ds9(mb).prefs.scale add separator
    $ds9(mb).prefs.scale add radiobutton -label MinMax \
	-variable prefs(scale,mode) -value minmax
    $ds9(mb).prefs.scale add radiobutton -label "99.5%" \
	-variable prefs(scale,mode) -value 99.5
    $ds9(mb).prefs.scale add radiobutton -label "99%" \
	-variable prefs(scale,mode) -value 99
    $ds9(mb).prefs.scale add radiobutton -label "98%" \
	-variable prefs(scale,mode) -value 98
    $ds9(mb).prefs.scale add radiobutton -label "95%" \
	-variable prefs(scale,mode) -value 95
    $ds9(mb).prefs.scale add radiobutton -label "90%" \
	-variable prefs(scale,mode) -value 90
    $ds9(mb).prefs.scale add radiobutton -label "ZScale" \
	-variable prefs(scale,mode) -value zscale
    $ds9(mb).prefs.scale add radiobutton -label "ZMax" \
	-variable prefs(scale,mode) -value zmax
    $ds9(mb).prefs.scale add separator
    $ds9(mb).prefs.scale add cascade -label "Scope" \
	-menu $ds9(mb).prefs.scale.scope
    $ds9(mb).prefs.scale add cascade -label "MinMax" \
	-menu $ds9(mb).prefs.scale.minmax
    $ds9(mb).prefs.scale add separator
    $ds9(mb).prefs.scale add checkbutton -label "use DATASEC" \
	-variable prefs(scale,datasec)

    menu $ds9(mb).prefs.scale.scope -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.scale.scope add radiobutton \
	-label "Global" -variable prefs(scale,scope) -value global
    $ds9(mb).prefs.scale.scope add radiobutton \
	-label "Local" -variable prefs(scale,scope) -value local

    menu $ds9(mb).prefs.scale.minmax -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.scale.minmax add radiobutton \
	-label "Auto" -variable prefs(minmax,mode) -value auto
    $ds9(mb).prefs.scale.minmax add radiobutton \
	-label "Scan Data" -variable prefs(minmax,mode) -value scan
    $ds9(mb).prefs.scale.minmax add radiobutton \
	-label "Sample Data" -variable prefs(minmax,mode) -value sample
    $ds9(mb).prefs.scale.minmax add radiobutton \
	-label "DATAMIN DATAMAX" -variable prefs(minmax,mode) -value datamin
    $ds9(mb).prefs.scale.minmax add radiobutton \
	-label "IRAF-MIN IRAF-MAX" -variable prefs(minmax,mode) -value irafmin
    $ds9(mb).prefs.scale.minmax add separator
    $ds9(mb).prefs.scale.minmax add command -label "Sample Increment..." \
	-command "MinMaxSampleDialog prefs(minmax,sample) 0"

    # Color Prefs

    menu $ds9(mb).prefs.color -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.color add separator
    $ds9(mb).prefs.color add checkbutton -label "Invert Colormap" \
	-variable prefs(colorbar,invert)

    # Region Prefs

    menu $ds9(mb).prefs.region -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.region add cascade -label "Shape" \
	-menu $ds9(mb).prefs.region.shape
    $ds9(mb).prefs.region add cascade -label "Color" \
	-menu $ds9(mb).prefs.region.color
    $ds9(mb).prefs.region add cascade -label "Width" \
	-menu $ds9(mb).prefs.region.width
    $ds9(mb).prefs.region add cascade -label "Properties" \
	-menu $ds9(mb).prefs.region.properties
    $ds9(mb).prefs.region add cascade -label "Font" \
	-menu $ds9(mb).prefs.region.font
    $ds9(mb).prefs.region add separator
    $ds9(mb).prefs.region add command -label "Circle..." \
	-command CircleDefaultDialog
    $ds9(mb).prefs.region add command -label "Ellipse..." \
	-command EllipseDefaultDialog
    $ds9(mb).prefs.region add command -label "Box..." \
	-command BoxDefaultDialog
    $ds9(mb).prefs.region add command -label "Polygon..." \
	-command PolygonDefaultDialog
    $ds9(mb).prefs.region add command -label "Projection..." \
	-command ProjectionDefaultDialog
    $ds9(mb).prefs.region add separator
    $ds9(mb).prefs.region add command -label "Annulus..." \
	-command AnnulusDefaultDialog
    $ds9(mb).prefs.region add command -label "Elliptical Annulus..." \
	-command EllipseAnnulusDefaultDialog
    $ds9(mb).prefs.region add command -label "Box Annulus..." \
	-command BoxAnnulusDefaultDialog
    $ds9(mb).prefs.region add command -label "Panda..." \
	-command PandaDefaultDialog
    $ds9(mb).prefs.region add separator
    $ds9(mb).prefs.region add cascade -label "File Format" \
	-menu $ds9(mb).prefs.region.format
    $ds9(mb).prefs.region add cascade -label "File Coordinate" \
	-menu $ds9(mb).prefs.region.coord
    $ds9(mb).prefs.region add separator
    $ds9(mb).prefs.region add cascade -label "Default Dialog" \
	-menu $ds9(mb).prefs.region.dialog

    menu $ds9(mb).prefs.region.shape -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.region.shape add radiobutton \
	-label Circle -variable prefs(marker,shape) -value circle
    $ds9(mb).prefs.region.shape add radiobutton \
	-label Ellipse -variable prefs(marker,shape) -value ellipse
    $ds9(mb).prefs.region.shape add radiobutton \
	-label Box -variable prefs(marker,shape) -value box
    $ds9(mb).prefs.region.shape add radiobutton \
	-label Polygon -variable prefs(marker,shape) -value polygon
    $ds9(mb).prefs.region.shape add radiobutton \
	-label Line -variable prefs(marker,shape) -value line
    $ds9(mb).prefs.region.shape add radiobutton \
	-label Text -variable prefs(marker,shape) -value text
    $ds9(mb).prefs.region.shape add separator
    $ds9(mb).prefs.region.shape add radiobutton \
	-label Ruler -variable prefs(marker,shape) -value ruler
    $ds9(mb).prefs.region.shape add radiobutton \
	-label Compass -variable prefs(marker,shape) -value compass
    $ds9(mb).prefs.region.shape add radiobutton \
	-label Projection -variable prefs(marker,shape) -value projection
    $ds9(mb).prefs.region.shape add separator
    $ds9(mb).prefs.region.shape add radiobutton \
	-label Annulus -variable prefs(marker,shape) -value annulus
    $ds9(mb).prefs.region.shape add radiobutton \
	-label "Elliptical Annulus" -variable prefs(marker,shape) \
	-value "ellipse annulus"
    $ds9(mb).prefs.region.shape add radiobutton \
	-label "Box Annulus" -variable prefs(marker,shape) -value "box annulus"
    $ds9(mb).prefs.region.shape add radiobutton \
	-label Panda -variable prefs(marker,shape) -value panda
    $ds9(mb).prefs.region.shape add separator
    $ds9(mb).prefs.region.shape add radiobutton \
	-label "Circle Point" -variable prefs(marker,shape) \
	-value "circle point" 
    $ds9(mb).prefs.region.shape add radiobutton \
	-label "Box Point" -variable prefs(marker,shape) -value "box point"
    $ds9(mb).prefs.region.shape add radiobutton \
	-label "Diamond Point" -variable prefs(marker,shape) \
	-value "diamond point"
    $ds9(mb).prefs.region.shape add radiobutton \
	-label "Cross Point" -variable prefs(marker,shape) -value "cross point"
    $ds9(mb).prefs.region.shape add radiobutton \
	-label "X Point" -variable prefs(marker,shape) -value "x point"
    $ds9(mb).prefs.region.shape add radiobutton \
	-label "Arrow Point" -variable prefs(marker,shape) \
	-value "arrow point" 
    $ds9(mb).prefs.region.shape add radiobutton \
	-label "BoxCircle Point" -variable prefs(marker,shape) \
	-value "boxcircle point"

    menu $ds9(mb).prefs.region.color -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.region.color add radiobutton -label "Black" \
	-variable prefs(marker,color) -value black
    $ds9(mb).prefs.region.color add radiobutton -label "White" \
	-variable prefs(marker,color) -value white
    $ds9(mb).prefs.region.color add radiobutton -label "Red" \
	-variable prefs(marker,color) -value red
    $ds9(mb).prefs.region.color add radiobutton -label "Green" \
	-variable prefs(marker,color) -value green
    $ds9(mb).prefs.region.color add radiobutton -label "Blue" \
	-variable prefs(marker,color) -value blue
    $ds9(mb).prefs.region.color add radiobutton -label "Cyan" \
	-variable prefs(marker,color) -value cyan
    $ds9(mb).prefs.region.color add radiobutton -label "Magenta" \
	-variable prefs(marker,color) -value magenta
    $ds9(mb).prefs.region.color add radiobutton -label "Yellow" \
	-variable prefs(marker,color) -value yellow

    menu $ds9(mb).prefs.region.width -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Region Width"
    $ds9(mb).prefs.region.width add radiobutton -label "1" \
	-variable prefs(marker,width) -value 1
    $ds9(mb).prefs.region.width add radiobutton -label "2" \
	-variable prefs(marker,width) -value 2
    $ds9(mb).prefs.region.width add radiobutton -label "3" \
	-variable prefs(marker,width) -value 3
    $ds9(mb).prefs.region.width add radiobutton -label "4" \
	-variable prefs(marker,width) -value 4

    menu $ds9(mb).prefs.region.properties -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Region Properties"
    $ds9(mb).prefs.region.properties add checkbutton -label "Can Edit" \
	-variable prefs(marker,edit)
    $ds9(mb).prefs.region.properties add checkbutton -label "Can Move" \
	-variable prefs(marker,move)
    $ds9(mb).prefs.region.properties add checkbutton -label "Can Rotate" \
	-variable prefs(marker,rotate)
    $ds9(mb).prefs.region.properties add checkbutton -label "Can Delete" \
	-variable prefs(marker,delete)
    $ds9(mb).prefs.region.properties add checkbutton -label "Fixed in Size" \
	-variable prefs(marker,fixed)

    $ds9(mb).prefs.region.properties add separator
    $ds9(mb).prefs.region.properties add radiobutton -label Include \
	-variable prefs(marker,include) -value 1
    $ds9(mb).prefs.region.properties add radiobutton -label Exclude \
	-variable prefs(marker,include) -value 0
    $ds9(mb).prefs.region.properties add separator
    $ds9(mb).prefs.region.properties add radiobutton -label Source \
	-variable prefs(marker,source) -value 1
    $ds9(mb).prefs.region.properties add radiobutton -label Background \
	-variable prefs(marker,source) -value 0

    menu $ds9(mb).prefs.region.font -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Region Font"
    $ds9(mb).prefs.region.font add radiobutton -label "Times" \
	-variable prefs(marker,font) -value times
    $ds9(mb).prefs.region.font add radiobutton -label "Helvetica" \
	-variable prefs(marker,font) -value helvetica
    $ds9(mb).prefs.region.font add radiobutton -label "Symbol" \
	-variable prefs(marker,font) -value symbol
    $ds9(mb).prefs.region.font add radiobutton -label "Courier" \
	-variable prefs(marker,font) -value courier
    $ds9(mb).prefs.region.font add separator
    $ds9(mb).prefs.region.font add radiobutton -label "9" \
	-variable prefs(marker,font,size) -value 9
    $ds9(mb).prefs.region.font add radiobutton -label "10" \
	-variable prefs(marker,font,size) -value 10
    $ds9(mb).prefs.region.font add radiobutton -label "12" \
	-variable prefs(marker,font,size) -value 12
    $ds9(mb).prefs.region.font add radiobutton -label "14" \
	-variable prefs(marker,font,size) -value 14
    $ds9(mb).prefs.region.font add radiobutton -label "18" \
	-variable prefs(marker,font,size) -value 18
    $ds9(mb).prefs.region.font add radiobutton -label "24" \
	-variable prefs(marker,font,size) -value 24
    $ds9(mb).prefs.region.font add radiobutton -label "30" \
	-variable prefs(marker,font,size) -value 30
    $ds9(mb).prefs.region.font add radiobutton -label "36" \
	-variable prefs(marker,font,size) -value 36
    $ds9(mb).prefs.region.font add separator
    $ds9(mb).prefs.region.font add radiobutton -label "Plain" \
	-variable prefs(marker,font,style) -value normal
    $ds9(mb).prefs.region.font add radiobutton -label "Bold" \
	-variable prefs(marker,font,style) -value bold
    $ds9(mb).prefs.region.font add radiobutton -label "Italic" \
	-variable prefs(marker,font,style) -value italic

    menu $ds9(mb).prefs.region.format -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.region.format add radiobutton -label "DS9/Funtools" \
	-variable prefs(marker,format) -value ds9 \
	-command UpdateMarkerPrefsFormatMenu
    $ds9(mb).prefs.region.format add radiobutton -label "CIAO" \
	-variable prefs(marker,format) -value ciao \
	-command UpdateMarkerPrefsFormatMenu
    $ds9(mb).prefs.region.format add radiobutton -label "SAOtng" \
	-variable prefs(marker,format) -value saotng \
	-command UpdateMarkerPrefsFormatMenu
    $ds9(mb).prefs.region.format add radiobutton -label "SAOimage" \
	-variable prefs(marker,format) -value saoimage \
	-command UpdateMarkerPrefsFormatMenu
    $ds9(mb).prefs.region.format add radiobutton -label "IRAF PROS" \
	-variable prefs(marker,format) -value pros \
	-command UpdateMarkerPrefsFormatMenu
    $ds9(mb).prefs.region.format add radiobutton -label "X Y" \
	-variable prefs(marker,format) -value xy \
	-command UpdateMarkerPrefsFormatMenu
    $ds9(mb).prefs.region.format add separator
    $ds9(mb).prefs.region.format add checkbutton -label "Strip Output" \
	-variable prefs(marker,strip)
    $ds9(mb).prefs.region.format add checkbutton -label "List WCS" \
	-variable prefs(marker,wcs)

    menu $ds9(mb).prefs.region.coord -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.region.coord add radiobutton -label "WCS" \
	-variable prefs(marker,system) -value wcs
    $ds9(mb).prefs.region.coord add cascade -label "Multiple WCS" \
	-menu $ds9(mb).prefs.region.coord.wcs
    $ds9(mb).prefs.region.coord add separator
    $ds9(mb).prefs.region.coord add radiobutton -label "Image" \
	-variable prefs(marker,system) -value image
    $ds9(mb).prefs.region.coord add radiobutton -label "Physical" \
	-variable prefs(marker,system) -value physical
    if {$ds9(amp,det)} {
	$ds9(mb).prefs.region.coord add radiobutton -label "Amplifier" \
	    -variable prefs(marker,system) -value amplifier
	$ds9(mb).prefs.region.coord add radiobutton -label "Detector" \
	    -variable prefs(marker,system) -value detector
    }
    $ds9(mb).prefs.region.coord add separator
    $ds9(mb).prefs.region.coord add radiobutton -label "Equatorial B1950" \
	-variable prefs(marker,sky) -value fk4
    $ds9(mb).prefs.region.coord add radiobutton -label "Equatorial J2000" \
	-variable prefs(marker,sky) -value fk5
    $ds9(mb).prefs.region.coord add radiobutton -label "ICRS" \
	-variable prefs(marker,sky) -value icrs
    $ds9(mb).prefs.region.coord add radiobutton -label "Galactic" \
	-variable prefs(marker,sky) -value galactic
    $ds9(mb).prefs.region.coord add radiobutton -label "Ecliptic" \
	-variable prefs(marker,sky) -value ecliptic
    $ds9(mb).prefs.region.coord add separator
    $ds9(mb).prefs.region.coord add radiobutton -label "Degrees" \
	-variable prefs(marker,skyformat) -value degrees
    $ds9(mb).prefs.region.coord add radiobutton -label "Sexagesimal" \
	-variable prefs(marker,skyformat) -value sexagesimal

    menu $ds9(mb).prefs.region.coord.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$ds9(mb).prefs.region.coord.wcs add radiobutton -label "WCS $l" \
	    -variable prefs(marker,system) -value "wcs$l"
    }

    menu $ds9(mb).prefs.region.dialog -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.region.dialog add cascade -label "Coordinate System" \
	-menu $ds9(mb).prefs.region.dialog.sys
    $ds9(mb).prefs.region.dialog add cascade -label "Distance System" \
	-menu $ds9(mb).prefs.region.dialog.dist

    menu $ds9(mb).prefs.region.dialog.sys -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.region.dialog.sys add radiobutton -label "WCS" \
	-variable marker(dialog,system) -value wcs
    $ds9(mb).prefs.region.dialog.sys add cascade -label "Multiple WCS" \
	-menu $ds9(mb).prefs.region.dialog.sys.wcs
    $ds9(mb).prefs.region.dialog.sys add separator
    $ds9(mb).prefs.region.dialog.sys add radiobutton -label "Image" \
	-variable marker(dialog,system) -value image
    $ds9(mb).prefs.region.dialog.sys add radiobutton -label "Physical" \
	-variable marker(dialog,system) -value physical
    if {$ds9(amp,det)} {
	$ds9(mb).prefs.region.dialog.sys add radiobutton -label "Amplifier" \
	    -variable marker(dialog,system) -value amplifier
	$ds9(mb).prefs.region.dialog.sys add radiobutton -label "Detector" \
	    -variable marker(dialog,system) -value detector
    }
    $ds9(mb).prefs.region.dialog.sys add separator
    $ds9(mb).prefs.region.dialog.sys add radiobutton -label "Equatorial B1950"\
	-variable marker(dialog,sky) -value fk4
    $ds9(mb).prefs.region.dialog.sys add radiobutton -label "Equatorial J2000"\
	-variable marker(dialog,sky) -value fk5
    $ds9(mb).prefs.region.dialog.sys add radiobutton -label "ICRS" \
	-variable marker(dialog,sky) -value icrs
    $ds9(mb).prefs.region.dialog.sys add radiobutton -label "Galactic" \
	-variable marker(dialog,sky) -value galactic
    $ds9(mb).prefs.region.dialog.sys add radiobutton -label "Ecliptic" \
	-variable marker(dialog,sky) -value ecliptic
    $ds9(mb).prefs.region.dialog.sys add separator
    $ds9(mb).prefs.region.dialog.sys add radiobutton -label "Degrees" \
	-variable marker(dialog,skyformat) -value degrees
    $ds9(mb).prefs.region.dialog.sys add radiobutton -label "Sexagesimal" \
	-variable marker(dialog,skyformat) -value sexagesimal

    menu $ds9(mb).prefs.region.dialog.sys.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$ds9(mb).prefs.region.dialog.sys.wcs add radiobutton -label "WCS $l" \
	    -variable marker(dialog,system) -value "wcs$l"
    }

    menu $ds9(mb).prefs.region.dialog.dist -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.region.dialog.dist add radiobutton -label "WCS" \
	-variable marker(dialog,dist,system) -value wcs
    $ds9(mb).prefs.region.dialog.dist add cascade -label "Multiple WCS" \
	-menu $ds9(mb).prefs.region.dialog.dist.wcs
    $ds9(mb).prefs.region.dialog.dist add separator
    $ds9(mb).prefs.region.dialog.dist add radiobutton -label "Image" \
	-variable marker(dialog,dist,system) -value image
    $ds9(mb).prefs.region.dialog.dist add radiobutton -label "Physical" \
	-variable marker(dialog,dist,system) -value physical
    if {$ds9(amp,det)} {
	$ds9(mb).prefs.region.dialog.dist add radiobutton -label "Amplifier" \
	    -variable marker(dialog,dist,system) -value amplifier
	$ds9(mb).prefs.region.dialog.dist add radiobutton -label "Detector" \
	    -variable marker(dialog,dist,system) -value detector
    }
    $ds9(mb).prefs.region.dialog.dist add separator
    $ds9(mb).prefs.region.dialog.dist add radiobutton -label "Degrees" \
	-variable marker(dialog,dist,format) -value degrees
    $ds9(mb).prefs.region.dialog.dist add radiobutton -label "ArcMin" \
	-variable marker(dialog,dist,format) -value arcmin
    $ds9(mb).prefs.region.dialog.dist add radiobutton -label "ArcSec" \
	-variable marker(dialog,dist,format) -value arcsec

    menu $ds9(mb).prefs.region.dialog.dist.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$ds9(mb).prefs.region.dialog.dist.wcs add radiobutton -label "WCS $l" \
	    -variable marker(dialog,dist,system) -value "wcs$l"
    }

    # WCS Prefs

    menu $ds9(mb).prefs.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.wcs add radiobutton -label "WCS" \
	-variable prefs(wcs,system) -value wcs
    $ds9(mb).prefs.wcs add cascade -label "Multiple WCS" \
	-menu $ds9(mb).prefs.wcs.wcs
    $ds9(mb).prefs.wcs add separator
    $ds9(mb).prefs.wcs add radiobutton -label "Equatorial B1950" \
	-variable prefs(wcs,sky) -value fk4
    $ds9(mb).prefs.wcs add radiobutton -label "Equatorial J2000" \
	-variable prefs(wcs,sky) -value fk5
    $ds9(mb).prefs.wcs add radiobutton -label "ICRS" \
	-variable prefs(wcs,sky) -value icrs
    $ds9(mb).prefs.wcs add radiobutton -label "Galactic" \
	-variable prefs(wcs,sky) -value galactic
    $ds9(mb).prefs.wcs add radiobutton -label "Ecliptic" \
	-variable prefs(wcs,sky) -value ecliptic
    $ds9(mb).prefs.wcs add separator
    $ds9(mb).prefs.wcs add radiobutton -label "Degrees" \
	-variable prefs(wcs,skyformat) -value degrees
    $ds9(mb).prefs.wcs add radiobutton -label "Sexagesimal" \
	-variable prefs(wcs,skyformat) -value sexagesimal

    menu $ds9(mb).prefs.wcs.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$ds9(mb).prefs.wcs.wcs add radiobutton -label "WCS $l" \
	    -variable prefs(wcs,system) -value "wcs$l"
    }

    # Analysis Prefs

    menu $ds9(mb).prefs.analysis -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.analysis add cascade -label "Horizontal Cut Graph" \
	-menu $ds9(mb).prefs.analysis.horz
    $ds9(mb).prefs.analysis add cascade -label "Vertical Cut Graph" \
	-menu $ds9(mb).prefs.analysis.vert
    $ds9(mb).prefs.analysis add separator
    $ds9(mb).prefs.analysis add cascade -label "Contour" \
	-menu $ds9(mb).prefs.analysis.contour
    $ds9(mb).prefs.analysis add separator
    $ds9(mb).prefs.analysis add cascade -label "Name Server" \
	-menu $ds9(mb).prefs.analysis.namesvr
    $ds9(mb).prefs.analysis add cascade -label "DSS Server" \
	-menu $ds9(mb).prefs.analysis.dsssvr
    $ds9(mb).prefs.analysis add separator
    $ds9(mb).prefs.analysis add cascade -label "Archive Servers" \
	-menu $ds9(mb).prefs.analysis.archive
    $ds9(mb).prefs.analysis add separator
    $ds9(mb).prefs.analysis add cascade -label "Virtual Observatory" \
	-menu $ds9(mb).prefs.analysis.vo
    $ds9(mb).prefs.analysis add separator
    $ds9(mb).prefs.analysis add checkbutton -label "Analysis Command Log" \
	-variable prefs(analysis,log)
    $ds9(mb).prefs.analysis add separator
    $ds9(mb).prefs.analysis add cascade -label "Preload Analysis File" \
	-menu $ds9(mb).prefs.analysis.preload
    $ds9(mb).prefs.analysis add cascade -label "Analysis Plot" \
	-menu $ds9(mb).prefs.analysis.plot

    # Analysis Horizontal Prefs

    menu $ds9(mb).prefs.analysis.horz -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.analysis.horz add checkbutton -label "Grid" \
	-variable graphHorz(grid) -command UpdateGraphGrid
    $ds9(mb).prefs.analysis.horz add separator
    $ds9(mb).prefs.analysis.horz add radiobutton -label "Linear" \
	-variable graphHorz(log) -value false -command UpdateGraphYAxis
    $ds9(mb).prefs.analysis.horz add radiobutton -label "Log" \
	-variable graphHorz(log) -value true -command UpdateGraphYAxis

    # Analysis Vertical Prefs

    menu $ds9(mb).prefs.analysis.vert -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.analysis.vert add checkbutton -label "Grid" \
	-variable graphVert(grid) -command  UpdateGraphGrid
    $ds9(mb).prefs.analysis.vert add separator
    $ds9(mb).prefs.analysis.vert add radiobutton -label "Linear" \
	-variable graphVert(log) -value false -command UpdateGraphYAxis
    $ds9(mb).prefs.analysis.vert add radiobutton -label "Log" \
	-variable graphVert(log) -value true -command UpdateGraphYAxis

    # Analysis Contour Prefs

    menu $ds9(mb).prefs.analysis.contour -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.analysis.contour add cascade -label "Color" \
	-menu $ds9(mb).prefs.analysis.contour.color
    $ds9(mb).prefs.analysis.contour add cascade -label "Width" \
	-menu $ds9(mb).prefs.analysis.contour.width
    $ds9(mb).prefs.analysis.contour add cascade -label "Method" \
	-menu $ds9(mb).prefs.analysis.contour.method

    # Analysis Contour Color Prefs

    menu $ds9(mb).prefs.analysis.contour.color -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.analysis.contour.color add radiobutton -label "Black" \
	-variable prefs(contour,color) -value black 
    $ds9(mb).prefs.analysis.contour.color add radiobutton -label "White" \
	-variable prefs(contour,color) -value white 
    $ds9(mb).prefs.analysis.contour.color add radiobutton -label "Red" \
	-variable prefs(contour,color) -value red 
    $ds9(mb).prefs.analysis.contour.color add radiobutton -label "Green" \
	-variable prefs(contour,color) -value green 
    $ds9(mb).prefs.analysis.contour.color add radiobutton -label "Blue" \
	-variable prefs(contour,color) -value blue 
    $ds9(mb).prefs.analysis.contour.color add radiobutton -label "Cyan" \
	-variable prefs(contour,color) -value cyan 
    $ds9(mb).prefs.analysis.contour.color add radiobutton -label "Magenta" \
	-variable prefs(contour,color) -value magenta 
    $ds9(mb).prefs.analysis.contour.color add radiobutton -label "Yellow" \
	-variable prefs(contour,color) -value yellow 

    # Analysis Contour Width Prefs

    menu $ds9(mb).prefs.analysis.contour.width -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.analysis.contour.width add radiobutton -label "1" \
	-variable prefs(contour,width) -value 1
    $ds9(mb).prefs.analysis.contour.width add radiobutton -label "2" \
	-variable prefs(contour,width) -value 2
    $ds9(mb).prefs.analysis.contour.width add radiobutton -label "3" \
	-variable prefs(contour,width) -value 3
    $ds9(mb).prefs.analysis.contour.width add radiobutton -label "4" \
	-variable prefs(contour,width) -value 4

    # Analysis Contour Method Prefs

    menu $ds9(mb).prefs.analysis.contour.method -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.analysis.contour.method add radiobutton -label Block \
	-variable prefs(contour,method) -value block
    $ds9(mb).prefs.analysis.contour.method add radiobutton -label Smooth \
	-variable prefs(contour,method) -value smooth

    # Analysis DSS Server Prefs

    menu $ds9(mb).prefs.analysis.dsssvr -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.analysis.dsssvr add radiobutton -label "DSS@SAO" \
	-variable dss(server) -value sao
    $ds9(mb).prefs.analysis.dsssvr add radiobutton -label "DSS@STSCI" \
	-variable dss(server) -value stsci
    $ds9(mb).prefs.analysis.dsssvr add radiobutton -label "DSS@ESO" \
	-variable dss(server) -value eso

    # Analysis Name Server Prefs

    menu $ds9(mb).prefs.analysis.namesvr -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.analysis.namesvr add radiobutton -label "NED@SAO" \
	-variable nsvr(server) -value ned-sao
    $ds9(mb).prefs.analysis.namesvr add radiobutton -label "NED@ESO" \
	-variable nsvr(server) -value ned-eso
    $ds9(mb).prefs.analysis.namesvr add radiobutton -label "SIMBAD@SAO" \
	-variable nsvr(server) -value simbad-sao
    $ds9(mb).prefs.analysis.namesvr add radiobutton -label "SIMBAD@ESO" \
	-variable nsvr(server) -value simbad-eso

    # Analysis Archive Prefs
    menu $ds9(mb).prefs.analysis.archive -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.analysis.archive add command -label "Archive 1..." \
	-command "HVArchPref 1"
    $ds9(mb).prefs.analysis.archive add command -label "Archive 2..." \
	-command "HVArchPref 2"
    $ds9(mb).prefs.analysis.archive add command -label "Archive 3..." \
	-command "HVArchPref 3"
    $ds9(mb).prefs.analysis.archive add command -label "Archive 4..." \
	-command "HVArchPref 4"

    # Analysis VO Prefs
    menu $ds9(mb).prefs.analysis.vo -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.analysis.vo add checkbutton -label "Internal Web Display" \
	-variable prefs(vo,hv)
    $ds9(mb).prefs.analysis.vo add separator
    $ds9(mb).prefs.analysis.vo add command -label "Server..." \
	-command VOPref

    # Analysis Preload Prefs
    menu $ds9(mb).prefs.analysis.preload -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.analysis.preload add command -label "Preload 1..." \
	-command "AnalysisPref prefs(analysis,user)"
    $ds9(mb).prefs.analysis.preload add command -label "Preload 2..." \
	-command "AnalysisPref prefs(analysis,user2)"
    $ds9(mb).prefs.analysis.preload add command -label "Preload 3..." \
	-command "AnalysisPref prefs(analysis,user3)"
    $ds9(mb).prefs.analysis.preload add command -label "Preload 4..." \
	-command "AnalysisPref prefs(analysis,user4)"

    # Analysis Plot Prefs

    APPrefsMenu

    # Language Prefs

    menu $ds9(mb).prefs.language -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.language add radiobutton -label "English" \
	-variable ds9(language) -value english
    $ds9(mb).prefs.language add radiobutton -label "Franais" \
	-variable ds9(language) -value francais
    $ds9(mb).prefs.language add radiobutton -label "Dansk" \
	-variable ds9(language) -value danish

    # Background Color Prefs

    menu $ds9(mb).prefs.bg -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.bg add radiobutton -label "Black" \
	-variable ds9(bg,color) -value black -command ChangeBackgroundColor
    $ds9(mb).prefs.bg add radiobutton -label "White" \
	-variable ds9(bg,color) -value white -command ChangeBackgroundColor
    $ds9(mb).prefs.bg add radiobutton -label "Red" \
	-variable ds9(bg,color) -value red -command ChangeBackgroundColor
    $ds9(mb).prefs.bg add radiobutton -label "Green" \
	-variable ds9(bg,color) -value green -command ChangeBackgroundColor
    $ds9(mb).prefs.bg add radiobutton -label "Blue" \
	-variable ds9(bg,color) -value blue -command ChangeBackgroundColor
    $ds9(mb).prefs.bg add radiobutton -label "Cyan" \
	-variable ds9(bg,color) -value cyan -command ChangeBackgroundColor
    $ds9(mb).prefs.bg add radiobutton -label "Magenta" \
	-variable ds9(bg,color) -value magenta -command ChangeBackgroundColor
    $ds9(mb).prefs.bg add radiobutton -label "Yellow" \
	-variable ds9(bg,color) -value yellow -command ChangeBackgroundColor

    # Blank/NaN Color Prefs

    menu $ds9(mb).prefs.nan -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.nan add radiobutton -label "Black" \
	-variable ds9(nan,color) -value black -command ChangeNaNColor
    $ds9(mb).prefs.nan add radiobutton -label "White" \
	-variable ds9(nan,color) -value white -command ChangeNaNColor
    $ds9(mb).prefs.nan add radiobutton -label "Red" \
	-variable ds9(nan,color) -value red -command ChangeNaNColor
    $ds9(mb).prefs.nan add radiobutton -label "Green" \
	-variable ds9(nan,color) -value green -command ChangeNaNColor
    $ds9(mb).prefs.nan add radiobutton -label "Blue" \
	-variable ds9(nan,color) -value blue -command ChangeNaNColor
    $ds9(mb).prefs.nan add radiobutton -label "Cyan" \
	-variable ds9(nan,color) -value cyan -command ChangeNaNColor
    $ds9(mb).prefs.nan add radiobutton -label "Magenta" \
	-variable ds9(nan,color) -value magenta -command ChangeNaNColor
    $ds9(mb).prefs.nan add radiobutton -label "Yellow" \
	-variable ds9(nan,color) -value yellow -command ChangeNaNColor

    # View Prefs

    menu $ds9(mb).prefs.view -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.view add checkbutton -label "Information Panel" \
	-variable info(view) -command UpdateView
    $ds9(mb).prefs.view add checkbutton -label "Panner" \
	-variable panner(view) -command UpdateView
    $ds9(mb).prefs.view add checkbutton -label "Magnifier" \
	-variable magnifier(view) -command UpdateView
    $ds9(mb).prefs.view add checkbutton -label "Buttons" \
	-variable buttons(view) -command UpdateView
    $ds9(mb).prefs.view add checkbutton -label "Colorbar" \
	-variable colorbar(view) -command UpdateView

    # Info Panel Prefs

    menu $ds9(mb).prefs.info -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.info add checkbutton -label "Filename" \
	-variable info(filename) -command UpdateInfoPanel
    $ds9(mb).prefs.info add checkbutton -label "Object" \
	-variable info(object) -command UpdateInfoPanel
    $ds9(mb).prefs.info add checkbutton -label "Min Max" \
	-variable info(minmax) -command UpdateInfoPanel
    $ds9(mb).prefs.info add checkbutton -label "Frame Info" \
	-variable info(frame) -command UpdateInfoPanel
    $ds9(mb).prefs.info add separator
    $ds9(mb).prefs.info add checkbutton -label "WCS" \
	-variable info(wcs) -command UpdateInfoPanel
    $ds9(mb).prefs.info add cascade -label "Multiple WCS" \
	-menu $ds9(mb).prefs.info.wcs
    $ds9(mb).prefs.info add separator
    $ds9(mb).prefs.info add checkbutton -label "Image" \
	-variable info(image) -command UpdateInfoPanel
    $ds9(mb).prefs.info add checkbutton -label "Physical" \
	-variable info(physical) -command UpdateInfoPanel
    if {$ds9(amp,det)} {
	$ds9(mb).prefs.info add checkbutton -label "Amplifier" \
	    -variable info(amplifier) -command UpdateInfoPanel
	$ds9(mb).prefs.info add checkbutton -label "Detector" \
	    -variable info(detector) -command UpdateInfoPanel
    }

    # Info Panel WCS Prefs

    menu $ds9(mb).prefs.info.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$ds9(mb).prefs.info.wcs add checkbutton -label "WCS $l" \
	    -variable "info(wcs$l)" -command UpdateInfoPanel
    }

    # Font Prefs

    menu $ds9(mb).prefs.font -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.font add radiobutton -label "Default" \
	-variable prefs(font) -value default
    $ds9(mb).prefs.font add separator
    $ds9(mb).prefs.font add radiobutton -label "Times" \
	-variable prefs(font) -value times
    $ds9(mb).prefs.font add radiobutton -label "Helvetica" \
	-variable prefs(font) -value helvetica
    $ds9(mb).prefs.font add radiobutton -label "Symbol" \
	-variable prefs(font) -value symbol
    $ds9(mb).prefs.font add radiobutton -label "Courier" \
	-variable prefs(font) -value courier
    $ds9(mb).prefs.font add separator
    $ds9(mb).prefs.font add radiobutton -label "8" \
	-variable prefs(font,size) -value 8
    $ds9(mb).prefs.font add radiobutton -label "9" \
	-variable prefs(font,size) -value 9
    $ds9(mb).prefs.font add radiobutton -label "10" \
	-variable prefs(font,size) -value 10
    $ds9(mb).prefs.font add radiobutton -label "12" \
	-variable prefs(font,size) -value 12
    $ds9(mb).prefs.font add radiobutton -label "14" \
	-variable prefs(font,size) -value 14
    $ds9(mb).prefs.font add radiobutton -label "18" \
	-variable prefs(font,size) -value 18
    $ds9(mb).prefs.font add radiobutton -label "24" \
	-variable prefs(font,size) -value 24
    $ds9(mb).prefs.font add separator
    $ds9(mb).prefs.font add radiobutton -label "Plain" \
	-variable prefs(font,style) -value normal
    $ds9(mb).prefs.font add radiobutton -label "Bold" \
	-variable prefs(font,style) -value bold
    $ds9(mb).prefs.font add radiobutton -label "Italic" \
	-variable prefs(font,style) -value italic

    # Mosaic Prefs

    menu $ds9(mb).prefs.mosaic -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.mosaic add checkbutton -label "Fast Mosaic Render" \
	-variable ds9(mosaic,fast) -command ChangeMosaicFast

    # Dialog Prefs

    menu $ds9(mb).prefs.dialog -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
#    if {$tcl_platform(platform) != "windows"} {
    $ds9(mb).prefs.dialog add radiobutton -label "Motif" \
	-variable ds9(dialog) -value motif
#    }
    $ds9(mb).prefs.dialog add radiobutton -label "Windows" \
	-variable ds9(dialog) -value windows
#    $ds9(mb).prefs.dialog add radiobutton -label "Blue Plate Special"
#	-variable ds9(dialog) -value blueplate

    # Panner Prefs

    menu $ds9(mb).prefs.panner -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.panner add checkbutton -label "Orientation Compass" \
	-variable panner(compass,image) -command ChangeImageCompass
    $ds9(mb).prefs.panner add checkbutton -label "WCS Compass" \
	-variable panner(compass,wcs) -command ChangeWCSCompass
    $ds9(mb).prefs.panner add cascade -label "WCS Compass Coord System" \
	-menu $ds9(mb).prefs.panner.compass

    menu $ds9(mb).prefs.panner.compass -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.panner.compass add radiobutton -label "WCS" \
	-variable panner(compass,wcs,system) -value wcs \
	-command ChangeWCSCompass
    $ds9(mb).prefs.panner.compass add cascade -label "Multiple WCS" \
	-menu $ds9(mb).prefs.panner.compass.wcs
    $ds9(mb).prefs.panner.compass add separator
    $ds9(mb).prefs.panner.compass add radiobutton -label "Equatorial B1950" \
	-variable panner(compass,wcs,sky) -value fk4 -command ChangeWCSCompass
    $ds9(mb).prefs.panner.compass add radiobutton -label "Equatorial J2000" \
	-variable panner(compass,wcs,sky) -value fk5 -command ChangeWCSCompass
    $ds9(mb).prefs.panner.compass add radiobutton -label "ICRS" \
	-variable panner(compass,wcs,sky) -value icrs -command ChangeWCSCompass
    $ds9(mb).prefs.panner.compass add radiobutton -label "Galactic" \
	-variable panner(compass,wcs,sky) -value galactic \
	-command ChangeWCSCompass
    $ds9(mb).prefs.panner.compass add radiobutton -label "Ecliptic" \
	-variable panner(compass,wcs,sky) -value ecliptic \
	-command ChangeWCSCompass

    menu $ds9(mb).prefs.panner.compass.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$ds9(mb).prefs.panner.compass.wcs add radiobutton -label "WCS $l" \
	    -variable panner(compass,wcs,system) -value "wcs$l" \
	    -command ChangeWCSCompass
    }

    # Magnifier Prefs

    menu $ds9(mb).prefs.magnifier -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.magnifier add checkbutton -label "Graphics" \
	-variable magnifier(region) -command ChangeMagnifierRegion
    $ds9(mb).prefs.magnifier add checkbutton -label "Cursor" \
	-variable magnifier(cursor) -command ChangeMagnifierCursor
    $ds9(mb).prefs.magnifier add separator
    $ds9(mb).prefs.magnifier add radiobutton -label "2x" \
	-variable magnifier(zoom) -value 2 -command MagnifierZoomTo
    $ds9(mb).prefs.magnifier add radiobutton -label "4x" \
	-variable magnifier(zoom) -value 4 -command MagnifierZoomTo
    $ds9(mb).prefs.magnifier add radiobutton -label "8x" \
	-variable magnifier(zoom) -value 8 -command MagnifierZoomTo
    $ds9(mb).prefs.magnifier add radiobutton -label "16x" \
	-variable magnifier(zoom) -value 16 -command MagnifierZoomTo
    $ds9(mb).prefs.magnifier add radiobutton -label "32x" \
	-variable magnifier(zoom) -value 32 -command MagnifierZoomTo

    # Pan Prefs

    menu $ds9(mb).prefs.pan -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.pan add radiobutton -label "Click to Center" \
	-variable panzoom(mode) -value click
    $ds9(mb).prefs.pan add radiobutton -label "Drag to Center" \
	-variable panzoom(mode) -value drag
    $ds9(mb).prefs.pan add radiobutton -label "Pan then Zoom" \
	-variable panzoom(mode) -value panzoom

    # Colorbar Prefs

    menu $ds9(mb).prefs.colorbar -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.colorbar add radiobutton -label "Update Full Screen" \
	-variable colorbar(area) -value 0 -command ColorbarArea
    $ds9(mb).prefs.colorbar add separator
    $ds9(mb).prefs.colorbar add radiobutton -label "128x128" \
	-variable colorbar(area) -value 128 -command ColorbarArea
    $ds9(mb).prefs.colorbar add radiobutton -label "256x256" \
	-variable colorbar(area) -value 256 -command ColorbarArea
    $ds9(mb).prefs.colorbar add radiobutton -label "512x512" \
	-variable colorbar(area) -value 512 -command ColorbarArea
    $ds9(mb).prefs.colorbar add separator
    $ds9(mb).prefs.colorbar add radiobutton -label "About Center" \
	-variable colorbar(mode) -value center -command ColorbarArea
    $ds9(mb).prefs.colorbar add radiobutton -label "About Mouse Click" \
	-variable colorbar(mode) -value click -command ColorbarArea

    # Display Coords Prefs

    menu $ds9(mb).prefs.coord -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.coord add checkbutton -label "WCS" -variable "coord(wcs)"
    $ds9(mb).prefs.coord add cascade -label "Multiple WCS" \
	-menu $ds9(mb).prefs.coord.wcs
    $ds9(mb).prefs.coord add separator
    $ds9(mb).prefs.coord add checkbutton -label "Image" -variable coord(image)
    $ds9(mb).prefs.coord add checkbutton -label "Physical" \
	-variable coord(physical)
    if {$ds9(amp,det)} {
	$ds9(mb).prefs.coord add checkbutton -label "Amplifier" \
	    -variable coord(amplifier)
	$ds9(mb).prefs.coord add checkbutton -label "Detector" \
	    -variable coord(detector)
    }
    $ds9(mb).prefs.coord add separator
    $ds9(mb).prefs.coord add radiobutton -label "Equatorial B1950" \
	-variable coord(sky) -value fk4
    $ds9(mb).prefs.coord add radiobutton -label "Equatorial J2000" \
	-variable coord(sky) -value fk5
    $ds9(mb).prefs.coord add radiobutton -label "ICRS" \
	-variable coord(sky) -value icrs
    $ds9(mb).prefs.coord add radiobutton -label "Galactic" \
	-variable coord(sky) -value galactic
    $ds9(mb).prefs.coord add radiobutton -label "Ecliptic" \
	-variable coord(sky) -value ecliptic
    $ds9(mb).prefs.coord add separator
    $ds9(mb).prefs.coord add radiobutton -label "Degrees" \
	-variable coord(skyformat) -value degrees
    $ds9(mb).prefs.coord add radiobutton -label "Sexagesimal" \
	-variable coord(skyformat) -value sexagesimal

    menu $ds9(mb).prefs.coord.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$ds9(mb).prefs.coord.wcs add checkbutton -label "WCS $l" \
	    -variable "coord(wcs$l)"
    }

    # Examine Prefs

    menu $ds9(mb).prefs.examine -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.examine add radiobutton -label "New Frame each Time" \
	-variable examine(mode) -value new
    $ds9(mb).prefs.examine add radiobutton -label "Examine Frame" \
	-variable examine(mode) -value one
    $ds9(mb).prefs.examine add separator
    $ds9(mb).prefs.examine add radiobutton -label "1x" \
	-variable examine(zoom) -value 1
    $ds9(mb).prefs.examine add radiobutton -label "2x" \
	-variable examine(zoom) -value 2
    $ds9(mb).prefs.examine add radiobutton -label "4x" \
	-variable examine(zoom) -value 4
    $ds9(mb).prefs.examine add radiobutton -label "8x" \
	-variable examine(zoom) -value 8
    $ds9(mb).prefs.examine add radiobutton -label "16x" \
	-variable examine(zoom) -value 16

    # Misc Prefs
    
    menu $ds9(mb).prefs.misc -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).prefs.misc add command -label "Temporary File Directory..." \
	-command TmpDirDialog
    $ds9(mb).prefs.misc add separator
    $ds9(mb).prefs.misc add checkbutton -label "Use Cursors" \
	-variable ds9(cursor)
    $ds9(mb).prefs.misc add checkbutton -label "Autoload FITS Regions" \
	-variable ds9(automarker)
    $ds9(mb).prefs.misc add checkbutton \
	-label "Show Amplifier/Detector in Menus" -variable ds9(amp,det)
    $ds9(mb).prefs.misc add checkbutton -label "Initialize XPA" \
	-variable ds9(xpa)

    # Color Menu

    menu $ds9(mb).color -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Colormap"
    $ds9(mb).color add separator
    $ds9(mb).color add checkbutton -label "Invert Colormap" \
	-variable colorbar(invert) -command InvertColorbar
    $ds9(mb).color add command -label "Reset Colormap" -command ResetColormap
    $ds9(mb).color add separator
    $ds9(mb).color add command -label "Colormap Parameters..." \
	-command ColormapDialog

    # Frame Menu
    # WARNING: this is a variable length menu. Be sure to update frame.tcl
    menu $ds9(mb).frame -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Frame"
    $ds9(mb).frame add command -label $menu(frame,new) -command CreateFrame
    $ds9(mb).frame add command -label $menu(frame,newrgb) \
	-command CreateRGBFrame
    $ds9(mb).frame add separator
    $ds9(mb).frame add command -label $menu(frame,delete) \
	-command DeleteFrameMenu
    $ds9(mb).frame add command -label $menu(frame,deleteall) \
	-command DeleteAllFramesMenu
    $ds9(mb).frame add separator
    $ds9(mb).frame add command -label $menu(frame,clear) \
	-command ClearCurrentFrame
    $ds9(mb).frame add command -label $menu(frame,reset) \
	-command ResetCurrentFrame
    $ds9(mb).frame add command -label $menu(frame,refresh) \
	-command UpdateCurrentFrame
    $ds9(mb).frame add separator
    $ds9(mb).frame add radiobutton -label $menu(frame,single) \
	-variable ds9(display,user) -value single -command DisplayMode
    $ds9(mb).frame add radiobutton -label $menu(frame,tile) \
	-variable ds9(display,user) -value tile -command DisplayMode
    $ds9(mb).frame add radiobutton -label $menu(frame,blink) \
	-variable ds9(display,user) -value blink -command DisplayMode
    $ds9(mb).frame add separator
    $ds9(mb).frame add cascade -label $menu(frame,tileparam) \
	-menu $ds9(mb).frame.tile
    $ds9(mb).frame add cascade -label $menu(frame,blinkparam) \
	-menu $ds9(mb).frame.blink
    $ds9(mb).frame add separator
    $ds9(mb).frame add cascade -label $menu(frame,matchframes) \
	-menu $ds9(mb).frame.match
    $ds9(mb).frame add command -label $menu(frame,matchcolorbars) \
	-command "MatchColorbars"
    $ds9(mb).frame add command -label $menu(frame,matchscales) \
	-command "MatchScales"
    $ds9(mb).frame add separator
    $ds9(mb).frame add cascade -label $menu(frame,lockcrosshairs) \
	-menu $ds9(mb).frame.crosshair
    $ds9(mb).frame add separator
    $ds9(mb).frame add command -label $menu(frame,datacube) \
	-command CubeDialog
    $ds9(mb).frame add command -label $menu(frame,rgb) \
	-command RGBDialog
    $ds9(mb).frame add separator
    $ds9(mb).frame add cascade -label $menu(frame,showhide) \
	-menu $ds9(mb).frame.active
    $ds9(mb).frame add separator

    menu $ds9(mb).frame.active -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Frame Show/Hide"
    $ds9(mb).frame.active add command -label "Show All" -command ActiveFrameAll
    $ds9(mb).frame.active add command -label "Hide All" \
	-command ActiveFrameNone
    $ds9(mb).frame.active add separator

    menu $ds9(mb).frame.match -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Frame Match"
    $ds9(mb).frame.match add command -label "WCS" -command MatchFramesWCS
    $ds9(mb).frame.match add command -label "Image" \
	-command "MatchFrames image"
    $ds9(mb).frame.match add command -label "Physical" \
	-command "MatchFrames physical"
    if {$ds9(amp,det)} {
	$ds9(mb).frame.match add command -label "Amplifier" \
	    -command "MatchFrames amplifier"
	$ds9(mb).frame.match add command -label "Detector" \
	    -command "MatchFrames detector"
    }

    menu $ds9(mb).frame.crosshair -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Frame Crosshair"
    $ds9(mb).frame.crosshair add radiobutton -label "None" \
	-variable crosshair(lock) -value none
    $ds9(mb).frame.crosshair add separator
    $ds9(mb).frame.crosshair add radiobutton -label "WCS" \
	-variable crosshair(lock) -value wcs
    $ds9(mb).frame.crosshair add cascade -label "Multiple WCS" \
	-menu $ds9(mb).frame.crosshair.wcs
    $ds9(mb).frame.crosshair add separator
    $ds9(mb).frame.crosshair add radiobutton -label "Image" \
	-variable crosshair(lock) -value image
    $ds9(mb).frame.crosshair add radiobutton -label "Physical" \
	-variable crosshair(lock) -value physical
    if {$ds9(amp,det)} {
	$ds9(mb).frame.crosshair add radiobutton -label "Amplifier" \
	    -variable crosshair(lock) -value amplifier
	$ds9(mb).frame.crosshair add radiobutton -label "Detector" \
	    -variable crosshair(lock) -value detector
    }

    menu $ds9(mb).frame.crosshair.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$ds9(mb).frame.crosshair.wcs add radiobutton -label "WCS $l" \
	    -variable crosshair(lock) -value "wcs$l"
    }

    menu $ds9(mb).frame.tile -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).frame.tile add radiobutton -label "Grid" \
	-variable tile(mode) -value grid -command DisplayMode
    $ds9(mb).frame.tile add radiobutton -label "Column" \
	-variable tile(mode) -value column -command DisplayMode
    $ds9(mb).frame.tile add radiobutton -label "Row" \
	-variable tile(mode) -value row -command DisplayMode
    $ds9(mb).frame.tile add separator
    $ds9(mb).frame.tile add command -label "Tile Parameters..." \
	-command TileDialog

    menu $ds9(mb).frame.blink -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).frame.blink add radiobutton -label ".125 Second" \
	-variable blink(interval) -value 125
    $ds9(mb).frame.blink add radiobutton -label ".25 Second" \
	-variable blink(interval) -value 250
    $ds9(mb).frame.blink add radiobutton -label ".5 Second" \
	-variable blink(interval) -value 500
    $ds9(mb).frame.blink add radiobutton -label "1 Second" \
	-variable blink(interval) -value 1000
    $ds9(mb).frame.blink add radiobutton -label "2 Seconds" \
	-variable blink(interval) -value 2000
    $ds9(mb).frame.blink add radiobutton -label "4 Seconds" \
	-variable blink(interval) -value 4000
    $ds9(mb).frame.blink add radiobutton -label "8 Seconds" \
	-variable blink(interval) -value 8000

    # Bin Menu

    menu $ds9(mb).bin -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Bin"
    $ds9(mb).bin add radiobutton -label "Average" \
	-variable bin(function) -value average -command ChangeBinFunction
    $ds9(mb).bin add radiobutton -label "Sum" \
	-variable bin(function) -value sum -command ChangeBinFunction
    $ds9(mb).bin add separator
    $ds9(mb).bin add command -label "Block In" -command "Bin .5 .5"
    $ds9(mb).bin add command -label "Block Out" -command "Bin 2 2"
    $ds9(mb).bin add separator
    $ds9(mb).bin add command -label "Block to Fit Frame" -command "BinToFit"
    $ds9(mb).bin add separator
    $ds9(mb).bin add radiobutton -label "Block 1" \
	-variable bin(factor) -value { 1 1 } -command ChangeBinFactor
    $ds9(mb).bin add radiobutton -label "Block 2" \
	-variable bin(factor) -value { 2 2 } -command ChangeBinFactor
    $ds9(mb).bin add radiobutton -label "Block 4" \
	-variable bin(factor) -value { 4 4 } -command ChangeBinFactor
    $ds9(mb).bin add radiobutton -label "Block 8" \
	-variable bin(factor) -value { 8 8 } -command ChangeBinFactor
    $ds9(mb).bin add radiobutton -label "Block 16" \
	-variable bin(factor) -value { 16 16 } -command ChangeBinFactor
    $ds9(mb).bin add radiobutton -label "Block 32" \
	-variable bin(factor) -value { 32 32 } -command ChangeBinFactor
    $ds9(mb).bin add radiobutton -label "Block 64" \
	-variable bin(factor) -value { 64 64 } -command ChangeBinFactor
    $ds9(mb).bin add radiobutton -label "Block 128" \
	-variable bin(factor) -value { 128 128 } -command ChangeBinFactor
    $ds9(mb).bin add separator
    $ds9(mb).bin add radiobutton -label "128x128" \
	-variable bin(buffersize) -value 128 -command ChangeBinBufferSize 
    $ds9(mb).bin add radiobutton -label "256x256" \
	-variable bin(buffersize) -value 256 -command ChangeBinBufferSize 
    $ds9(mb).bin add radiobutton -label "512x512" \
	-variable bin(buffersize) -value 512 -command ChangeBinBufferSize 
    $ds9(mb).bin add radiobutton -label "1024x1024" \
	-variable bin(buffersize) -value 1024 -command ChangeBinBufferSize
    $ds9(mb).bin add radiobutton -label "2048x2048" \
	-variable bin(buffersize) -value 2048 -command ChangeBinBufferSize
    $ds9(mb).bin add radiobutton -label "4096x4096" \
	-variable bin(buffersize) -value 4096 -command ChangeBinBufferSize
    $ds9(mb).bin add separator
    $ds9(mb).bin add checkbutton -label "Smooth" \
	-variable bin(smooth) -command ChangeBinSmooth
    $ds9(mb).bin add separator
    $ds9(mb).bin add radiobutton -label "BoxCar" \
	-variable bin(smooth,function) -value boxcar \
	-command ChangeBinSmoothFunction
    $ds9(mb).bin add radiobutton -label "TopHat" \
	-variable bin(smooth,function) -value tophat \
	-command ChangeBinSmoothFunction
   $ds9(mb).bin add  radiobutton -label "Gaussian" \
	-variable bin(smooth,function) -value gaussian \
	-command ChangeBinSmoothFunction
    $ds9(mb).bin add separator
    $ds9(mb).bin add command -label "Binning Parameters..." -command BinDialog

    # Zoom Menu

    menu $ds9(mb).zoom -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Zoom"
    $ds9(mb).zoom add command -label "Center Image" -command CenterCurrentFrame
    $ds9(mb).zoom add separator
    $ds9(mb).zoom add checkbutton -label "Align to WCS" \
	-variable wcs(align) -command AlignWCSFrame
    $ds9(mb).zoom add cascade -label "Align Coord System" \
	-menu $ds9(mb).zoom.align
    $ds9(mb).zoom add separator
    $ds9(mb).zoom add command -label "Zoom In" -command "Zoom 2"
    $ds9(mb).zoom add command -label "Zoom Out" -command "Zoom .5"
    $ds9(mb).zoom add separator
    $ds9(mb).zoom add command -label "Zoom to Fit Frame" -command "ZoomToFit"
    $ds9(mb).zoom add separator
    $ds9(mb).zoom add radiobutton -label "1/32" \
	-variable current(zoom) -value 0.03125 -command ChangeZoom
    $ds9(mb).zoom add radiobutton -label "1/16" \
	-variable current(zoom) -value 0.0625 -command ChangeZoom
    $ds9(mb).zoom add radiobutton -label "1/8" \
	-variable current(zoom) -value 0.125 -command ChangeZoom
    $ds9(mb).zoom add radiobutton -label "1/4" \
	-variable current(zoom) -value 0.25 -command ChangeZoom
    $ds9(mb).zoom add radiobutton -label "1/2" \
	-variable current(zoom) -value 0.5 -command ChangeZoom
    $ds9(mb).zoom add radiobutton -label "1" \
	-variable current(zoom) -value 1 -command ChangeZoom
    $ds9(mb).zoom add radiobutton -label "2" \
	-variable current(zoom) -value 2 -command ChangeZoom
    $ds9(mb).zoom add radiobutton -label "4" \
	-variable current(zoom) -value 4 -command ChangeZoom
    $ds9(mb).zoom add radiobutton -label "8" \
	-variable current(zoom) -value 8 -command ChangeZoom
    $ds9(mb).zoom add radiobutton -label "16" \
	-variable current(zoom) -value 16 -command ChangeZoom
    $ds9(mb).zoom add radiobutton -label "32" \
	-variable current(zoom) -value 32 -command ChangeZoom
    $ds9(mb).zoom add separator
    $ds9(mb).zoom add radiobutton  -label "None" \
	-variable current(orient) -value none -command ChangeOrient
    $ds9(mb).zoom add radiobutton  -label "Invert X" \
	-variable current(orient) -value x -command ChangeOrient
    $ds9(mb).zoom add radiobutton -label "Invert Y" \
	-variable current(orient) -value y -command ChangeOrient
    $ds9(mb).zoom add radiobutton -label "Invert X&Y" \
	-variable current(orient) -value xy -command ChangeOrient
    $ds9(mb).zoom add separator
    $ds9(mb).zoom add radiobutton -label "0 deg" \
	-variable current(rotate) -value 0 -command ChangeRotate
    $ds9(mb).zoom add radiobutton -label "90 deg" \
	-variable current(rotate) -value 90 -command ChangeRotate
    $ds9(mb).zoom add radiobutton -label "180 deg" \
	-variable current(rotate) -value 180 -command ChangeRotate
    $ds9(mb).zoom add radiobutton -label "270 deg" \
	-variable current(rotate) -value 270 -command ChangeRotate
    $ds9(mb).zoom add separator
    $ds9(mb).zoom add command -label "Pan Zoom Rotate To..." \
	-command PanZoomDialog

    menu $ds9(mb).zoom.align -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Zoom Align"
    $ds9(mb).zoom.align add radiobutton -label "WCS" \
	-variable wcs(align,system) -value wcs -command AlignWCSFrame
    $ds9(mb).zoom.align add cascade -label "Multiple WCS" \
	-menu $ds9(mb).zoom.align.wcs
    $ds9(mb).zoom.align add separator
    $ds9(mb).zoom.align add radiobutton -label "Equatorial B1950" \
	-variable wcs(align,sky) -value fk4 -command AlignWCSFrame
    $ds9(mb).zoom.align add radiobutton -label "Equatorial J2000" \
	-variable wcs(align,sky) -value fk5 -command AlignWCSFrame
    $ds9(mb).zoom.align add radiobutton -label "ICRS" \
	-variable wcs(align,sky) -value icrs -command AlignWCSFrame
    $ds9(mb).zoom.align add radiobutton -label "Galactic" \
	-variable wcs(align,sky) -value galactic -command AlignWCSFrame
    $ds9(mb).zoom.align add radiobutton -label "Ecliptic" \
	-variable wcs(align,sky) -value ecliptic -command AlignWCSFrame

    menu $ds9(mb).zoom.align.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$ds9(mb).zoom.align.wcs add radiobutton -label "WCS $l" \
	    -variable wcs(align,system) -value "wcs$l" -command AlignWCSFrame
    }

    # Scale Menu

    menu $ds9(mb).scale -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Scale"
    $ds9(mb).scale add radiobutton -label "Linear" \
	-variable scale(type) -command ChangeScale -value linear
    $ds9(mb).scale add radiobutton -label "Log" \
	-variable scale(type) -command ChangeScale -value log
    $ds9(mb).scale add radiobutton -label "Squared" \
	-variable scale(type) -command ChangeScale -value squared
    $ds9(mb).scale add radiobutton -label "Square Root" \
	-variable scale(type) -command ChangeScale -value sqrt
    $ds9(mb).scale add radiobutton -label "Histogram Equalization" \
	-variable scale(type) -command ChangeScale -value histequ
    $ds9(mb).scale add separator
    $ds9(mb).scale add radiobutton -label MinMax -variable scale(mode) \
	-command ChangeScaleMode -value minmax
    $ds9(mb).scale add radiobutton -label "99.5%" -variable scale(mode) \
	-command ChangeScaleMode -value 99.5
    $ds9(mb).scale add radiobutton -label "99%" -variable scale(mode) \
	-command ChangeScaleMode -value 99
    $ds9(mb).scale add radiobutton -label "98%" -variable scale(mode) \
	-command ChangeScaleMode -value 98
    $ds9(mb).scale add radiobutton -label "95%" -variable scale(mode) \
	-command ChangeScaleMode -value 95
    $ds9(mb).scale add radiobutton -label "90%" -variable scale(mode) \
	-command ChangeScaleMode -value 90
    $ds9(mb).scale add radiobutton -label "ZScale" -variable scale(mode) \
	-command ChangeScaleMode -value zscale
    $ds9(mb).scale add radiobutton -label "ZMax" -variable scale(mode) \
	-command ChangeScaleMode -value zmax
    $ds9(mb).scale add separator
    $ds9(mb).scale add cascade -label "Scope" -menu $ds9(mb).scale.scope
    $ds9(mb).scale add cascade -label "MinMax" -menu $ds9(mb).scale.minmax
    $ds9(mb).scale add separator
    $ds9(mb).scale add checkbutton -label "use DATASEC" \
	-variable scale(datasec) -command ChangeDATASEC
    $ds9(mb).scale add separator
    $ds9(mb).scale add command -label "Scale Parameters..." \
	-command ScaleDialog

    menu $ds9(mb).scale.scope -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Scale Scope"
    $ds9(mb).scale.scope add radiobutton -label "Global" \
	-variable scale(scope) -command ChangeScaleScope -value global
    $ds9(mb).scale.scope add radiobutton -label "Local" \
	-variable scale(scope) -command ChangeScaleScope -value local

    menu $ds9(mb).scale.minmax -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Scale MinMax"
    $ds9(mb).scale.minmax add radiobutton -label "Auto" \
	-variable minmax(mode) -value auto -command ChangeMinMaxMode
    $ds9(mb).scale.minmax add radiobutton -label "Scan Data" \
	-variable minmax(mode) -value scan -command ChangeMinMaxMode
    $ds9(mb).scale.minmax add radiobutton -label "Sample Data" \
	-variable minmax(mode) -value sample -command ChangeMinMaxMode
    $ds9(mb).scale.minmax add radiobutton -label "DATAMIN DATAMAX" \
	-variable minmax(mode) -value datamin -command ChangeMinMaxMode
    $ds9(mb).scale.minmax add radiobutton -label "IRAF-MIN IRAF-MAX" \
	-variable minmax(mode) -value irafmin -command ChangeMinMaxMode
    $ds9(mb).scale.minmax add separator
    $ds9(mb).scale.minmax add command -label "Sample Increment..." \
	-command "MinMaxSampleDialog minmax(sample) 1"

    # Region Menu

    menu $ds9(mb).region -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Region"
    $ds9(mb).region add checkbutton -label "Show Regions" \
	-variable marker(show) -command ShowMarker
    $ds9(mb).region add separator
    $ds9(mb).region add command -label "Get Info..." -command InfoMarker
    $ds9(mb).region add separator
    $ds9(mb).region add cascade -label "Shape" -menu $ds9(mb).region.shape
    $ds9(mb).region add cascade -label "Color" -menu $ds9(mb).region.color
    $ds9(mb).region add cascade -label "Width" -menu $ds9(mb).region.width
    $ds9(mb).region add cascade -label "Properties" \
	-menu $ds9(mb).region.properties
    $ds9(mb).region add cascade -label "Font" -menu $ds9(mb).region.font
    $ds9(mb).region add separator
    $ds9(mb).region add command -label "Move to Front" -command FrontMarker
    $ds9(mb).region add command -label "Move to Back" -command BackMarker
    $ds9(mb).region add separator
    $ds9(mb).region add command -label "Select All" \
	-command SelectAllMarker
    $ds9(mb).region add command -label "Select None" \
	-command UnselectAllMarker
    $ds9(mb).region add separator
    $ds9(mb).region add command -label "Delete Selected Regions" \
	-command DeleteSelectMarker
    $ds9(mb).region add command -label "Delete All Regions" \
	-command DeleteAllMarker
    $ds9(mb).region add separator
    $ds9(mb).region add command -label "New Group" -command GroupCreate
    $ds9(mb).region add command -label "Groups..." -command GroupDialog
    $ds9(mb).region add separator
    $ds9(mb).region add command -label "List Regions" -command DisplayMarker
    $ds9(mb).region add separator
    $ds9(mb).region add command -label "Load Regions..." \
	-command OpenMarkerFile
    $ds9(mb).region add command -label "Save Regions..." -command SaveMarker
    $ds9(mb).region add separator
    $ds9(mb).region add cascade -label "File Format" \
	-menu $ds9(mb).region.format
    $ds9(mb).region add cascade -label "File Coordinate System" \
	-menu $ds9(mb).region.coord

    menu $ds9(mb).region.shape -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Region Shape"
    $ds9(mb).region.shape add radiobutton \
	-label Circle -variable marker(shape) -value circle
    $ds9(mb).region.shape add radiobutton \
	-label Ellipse -variable marker(shape) -value ellipse
    $ds9(mb).region.shape add radiobutton \
	-label Box -variable marker(shape) -value box
    $ds9(mb).region.shape add radiobutton \
	-label Polygon -variable marker(shape) -value polygon
    $ds9(mb).region.shape add radiobutton \
	-label Line -variable marker(shape) -value line
    $ds9(mb).region.shape add radiobutton \
	-label Text -variable marker(shape) -value text
    $ds9(mb).region.shape add separator
    $ds9(mb).region.shape add radiobutton \
	-label Ruler -variable marker(shape) -value ruler
    $ds9(mb).region.shape add radiobutton \
	-label Compass -variable marker(shape) -value compass
    $ds9(mb).region.shape add radiobutton \
	-label Projection -variable marker(shape) -value projection
    $ds9(mb).region.shape add separator
    $ds9(mb).region.shape add radiobutton \
	-label Annulus -variable marker(shape) -value annulus
    $ds9(mb).region.shape add radiobutton \
	-label "Elliptical Annulus" -variable marker(shape) \
	-value "ellipse annulus"
    $ds9(mb).region.shape add radiobutton \
	-label "Box Annulus" -variable marker(shape) -value "box annulus"
    $ds9(mb).region.shape add radiobutton \
	-label Panda -variable marker(shape) -value panda
    $ds9(mb).region.shape add separator
    $ds9(mb).region.shape add radiobutton \
	-label "Circle Point" -variable marker(shape) -value "circle point" 
    $ds9(mb).region.shape add radiobutton \
	-label "Box Point" -variable marker(shape) -value "box point"
    $ds9(mb).region.shape add radiobutton \
	-label "Diamond Point" -variable marker(shape) -value "diamond point"
    $ds9(mb).region.shape add radiobutton \
	-label "Cross Point" -variable marker(shape) -value "cross point"
    $ds9(mb).region.shape add radiobutton \
	-label "X Point" -variable marker(shape) -value "x point"
    $ds9(mb).region.shape add radiobutton \
	-label "Arrow Point" -variable marker(shape) -value "arrow point" 
    $ds9(mb).region.shape add radiobutton \
	-label "BoxCircle Point" -variable marker(shape) \
	-value "boxcircle point"

    menu $ds9(mb).region.color -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Region Color"
    $ds9(mb).region.color add radiobutton -label "Black" \
	-variable marker(color) -value black -command ChangeMarkerColor
    $ds9(mb).region.color add radiobutton -label "White" \
	-variable marker(color) -value white -command ChangeMarkerColor
    $ds9(mb).region.color add radiobutton -label "Red" \
	-variable marker(color) -value red -command ChangeMarkerColor
    $ds9(mb).region.color add radiobutton -label "Green" \
	-variable marker(color) -value green -command ChangeMarkerColor
    $ds9(mb).region.color add radiobutton -label "Blue" \
	-variable marker(color) -value blue -command ChangeMarkerColor
    $ds9(mb).region.color add radiobutton -label "Cyan" \
	-variable marker(color) -value cyan -command ChangeMarkerColor
    $ds9(mb).region.color add radiobutton -label "Magenta" \
	-variable marker(color) -value magenta -command ChangeMarkerColor
    $ds9(mb).region.color add radiobutton -label "Yellow" \
	-variable marker(color) -value yellow -command ChangeMarkerColor

    menu $ds9(mb).region.width -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Region Width"
    $ds9(mb).region.width add radiobutton -label "1" \
	-variable marker(width) -value 1 -command ChangeMarkerWidth
    $ds9(mb).region.width add radiobutton -label "2" \
	-variable marker(width) -value 2 -command ChangeMarkerWidth
    $ds9(mb).region.width add radiobutton -label "3" \
	-variable marker(width) -value 3 -command ChangeMarkerWidth
    $ds9(mb).region.width add radiobutton -label "4" \
	-variable marker(width) -value 4 -command ChangeMarkerWidth

    menu $ds9(mb).region.properties -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Region Properties"
    $ds9(mb).region.properties add checkbutton -label "Can Edit" \
	-variable marker(edit) -command "ChangeMarkerProp edit"
    $ds9(mb).region.properties add checkbutton -label "Can Move" \
	-variable marker(move) -command "ChangeMarkerProp move"
    $ds9(mb).region.properties add checkbutton -label "Can Rotate" \
	-variable marker(rotate) -command "ChangeMarkerProp rotate"
    $ds9(mb).region.properties add checkbutton -label "Can Delete" \
	-variable marker(delete) -command "ChangeMarkerProp delete"
    $ds9(mb).region.properties add checkbutton -label "Fixed in Size" \
	-variable marker(fixed) -command "ChangeMarkerProp fixed"

    $ds9(mb).region.properties add separator
    $ds9(mb).region.properties add radiobutton -label Include \
	-variable marker(include) -value 1 -command "ChangeMarkerProp include"
    $ds9(mb).region.properties add radiobutton -label Exclude \
	-variable marker(include) -value 0 -command "ChangeMarkerProp include"
    $ds9(mb).region.properties add separator
    $ds9(mb).region.properties add radiobutton -label Source \
	-variable marker(source) -value 1 -command "ChangeMarkerProp source"
    $ds9(mb).region.properties add radiobutton -label Background \
	-variable marker(source) -value 0 -command "ChangeMarkerProp source"

    menu $ds9(mb).region.font -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Region Font"
    $ds9(mb).region.font add radiobutton -label "Times" \
	-variable marker(font) -value times -command ChangeMarkerFont
    $ds9(mb).region.font add radiobutton -label "Helvetica" \
	-variable marker(font) -value helvetica -command ChangeMarkerFont
    $ds9(mb).region.font add radiobutton -label "Symbol" \
	-variable marker(font) -value symbol -command ChangeMarkerFont
    $ds9(mb).region.font add radiobutton -label "Courier" \
	-variable marker(font) -value courier -command ChangeMarkerFont
    $ds9(mb).region.font add separator
    $ds9(mb).region.font add radiobutton -label "9" \
	-variable marker(font,size) -value 9 -command ChangeMarkerFont
    $ds9(mb).region.font add radiobutton -label "10" \
	-variable marker(font,size) -value 10 -command ChangeMarkerFont
    $ds9(mb).region.font add radiobutton -label "12" \
	-variable marker(font,size) -value 12 -command ChangeMarkerFont
    $ds9(mb).region.font add radiobutton -label "14" \
	-variable marker(font,size) -value 14 -command ChangeMarkerFont
    $ds9(mb).region.font add radiobutton -label "18" \
	-variable marker(font,size) -value 18 -command ChangeMarkerFont
    $ds9(mb).region.font add radiobutton -label "24" \
	-variable marker(font,size) -value 24 -command ChangeMarkerFont
    $ds9(mb).region.font add radiobutton -label "30" \
	-variable marker(font,size) -value 30 -command ChangeMarkerFont
    $ds9(mb).region.font add radiobutton -label "36" \
	-variable marker(font,size) -value 36 -command ChangeMarkerFont
    $ds9(mb).region.font add separator
    $ds9(mb).region.font add radiobutton -label "Plain" \
	-variable marker(font,style) -value normal -command ChangeMarkerFont
    $ds9(mb).region.font add radiobutton -label "Bold" \
	-variable marker(font,style) -value bold -command ChangeMarkerFont
    $ds9(mb).region.font add radiobutton -label "Italic" \
	-variable marker(font,style) -value italic -command ChangeMarkerFont

    menu $ds9(mb).region.format -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Region Format"
    $ds9(mb).region.format add radiobutton -label "DS9/Funtools" \
	-variable marker(format) -value ds9 -command UpdateMarkerFormatMenu
    $ds9(mb).region.format add radiobutton -label "Ciao" \
	-variable marker(format) -value ciao -command UpdateMarkerFormatMenu
    $ds9(mb).region.format add radiobutton -label "SAOtng" \
	-variable marker(format) -value saotng -command UpdateMarkerFormatMenu
    $ds9(mb).region.format add radiobutton -label "SAOimage" \
	-variable marker(format) -value saoimage \
	-command UpdateMarkerFormatMenu
    $ds9(mb).region.format add radiobutton -label "IRAF PROS" \
	-variable marker(format) -value pros -command UpdateMarkerFormatMenu
    $ds9(mb).region.format add radiobutton -label "X Y" \
	-variable marker(format) -value xy -command UpdateMarkerFormatMenu
    $ds9(mb).region.format add separator
    $ds9(mb).region.format add checkbutton -label "Strip Output" \
	-variable marker(strip)
    $ds9(mb).region.format add checkbutton -label "List WCS" \
	-variable marker(wcs)

    menu $ds9(mb).region.coord -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Region Coordinate"
    $ds9(mb).region.coord add radiobutton -label "WCS" \
	-variable marker(system) -value wcs -command UpdateMarkerFormatMenu
    $ds9(mb).region.coord add cascade -label "Multiple WCS" \
	-menu $ds9(mb).region.coord.wcs
    $ds9(mb).region.coord add separator
    $ds9(mb).region.coord add radiobutton -label "Image" \
	-variable marker(system) -value image -command UpdateMarkerFormatMenu
    $ds9(mb).region.coord add radiobutton -label "Physical" \
	-variable marker(system) -value physical \
	-command UpdateMarkerFormatMenu
    if {$ds9(amp,det)} {
	$ds9(mb).region.coord add radiobutton -label "Amplifier" \
	    -variable marker(system) -value amplifier \
	    -command UpdateMarkerFormatMenu
	$ds9(mb).region.coord add radiobutton -label "Detector" \
	    -variable marker(system) -value detector \
	    -command UpdateMarkerFormatMenu
    }
    $ds9(mb).region.coord add separator
    $ds9(mb).region.coord add radiobutton -label "Equatorial B1950" \
	-variable marker(sky) -value fk4
    $ds9(mb).region.coord add radiobutton -label "Equatorial J2000" \
	-variable marker(sky) -value fk5
    $ds9(mb).region.coord add radiobutton -label "ICRS" \
	-variable marker(sky) -value icrs
    $ds9(mb).region.coord add radiobutton -label "Galactic" \
	-variable marker(sky) -value galactic
    $ds9(mb).region.coord add radiobutton -label "Ecliptic" \
	-variable marker(sky) -value ecliptic
    $ds9(mb).region.coord add separator
    $ds9(mb).region.coord add radiobutton -label "Degrees" \
	-variable marker(skyformat) -value degrees
    $ds9(mb).region.coord add radiobutton -label "Sexagesimal" \
	-variable marker(skyformat) -value sexagesimal

    menu $ds9(mb).region.coord.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$ds9(mb).region.coord.wcs add radiobutton -label "WCS $l" \
	    -variable marker(system) -value "wcs$l" \
	    -command UpdateMarkerFormatMenu
    }

    # WCS Menu

    menu $ds9(mb).wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    $ds9(mb).wcs add radiobutton -label "WCS" \
	-variable wcs(system) -value wcs -command UpdateWCS
    $ds9(mb).wcs add cascade -label "Multiple WCS" \
	-menu $ds9(mb).wcs.wcs
    $ds9(mb).wcs add separator
    $ds9(mb).wcs add radiobutton -label "Equatorial B1950" \
	-variable wcs(sky) -value fk4 -command UpdateWCS
    $ds9(mb).wcs add radiobutton -label "Equatorial J2000" \
	-variable wcs(sky) -value fk5 -command UpdateWCS
    $ds9(mb).wcs add radiobutton -label "ICRS" \
	-variable wcs(sky) -value icrs -command UpdateWCS
    $ds9(mb).wcs add radiobutton -label "Galactic" \
	-variable wcs(sky) -value galactic -command UpdateWCS
    $ds9(mb).wcs add radiobutton -label "Ecliptic" \
	-variable wcs(sky) -value ecliptic -command UpdateWCS
    $ds9(mb).wcs add separator
    $ds9(mb).wcs add radiobutton -label "Degrees" \
	-variable wcs(skyformat) -value degrees -command UpdateWCS
    $ds9(mb).wcs add radiobutton -label "Sexagesimal" \
	-variable wcs(skyformat) -value sexagesimal -command UpdateWCS

    menu $ds9(mb).wcs.wcs -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor)
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$ds9(mb).wcs.wcs add radiobutton -label "WCS $l" \
	    -variable wcs(system) -value "wcs$l" -command UpdateWCS
    }

    # Analysis Menu
    # WARNING: this is a variable length menu. Be sure to update analysis.tcl

    menu $ds9(mb).analysis -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Analysis"
    $ds9(mb).analysis add checkbutton -label "Horizontal Cut Graph" \
	-variable graphHorz(view) -command UpdateView
    $ds9(mb).analysis add checkbutton -label "Vertical Cut Graph" \
	-variable graphVert(view) -command UpdateView
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add command -label "Pixel Table..." \
	-command PixelTableDisplay
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add checkbutton -label "Display Contours" \
	-variable contour(view) -command ContourUpdate
    $ds9(mb).analysis add command -label "Contours Parameters..." \
	-command ContourDialog
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add checkbutton -label "Display Coordinate Grid" \
	-variable grid(view) -command GridUpdate
    $ds9(mb).analysis add command -label "Coordinate Grid Parameters..." \
	-command GridDialog
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add command -label "Name Resolution..." \
	-command NSVRDialog
    $ds9(mb).analysis add command -label "DSS Server..." -command DSSDialog
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add cascade -label "Archive Servers" \
	-menu $ds9(mb).analysis.arch
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add command -label "Virtual Observatory..." \
	-command VODialog
    $ds9(mb).analysis add command -label "Plot Tool..." \
	-command AnalysisPlotTool
    $ds9(mb).analysis add command -label "Web Display..." \
	-command "HV web Web {} 2 1 {}"
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add checkbutton -label "Analysis Command Log" \
	-variable analysis(log)
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add command -label "Load Analysis Commands..." \
	-command LoadAnalysisDialog
    $ds9(mb).analysis add command -label "Clear Analysis Commands" \
	-command ClearAnalysisDialog

    # Analysis Archive Menu
    # WARNING: this is a variable length menu. Be sure to update hv.tcl

    menu $ds9(mb).analysis.arch -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Archive Servers"
    $ds9(mb).analysis.arch add command -label "MAST (NASA/STSCI)" \
	-command HVArchMAST
    $ds9(mb).analysis.arch add command -label "NSA (NOAO)" -command HVArchNSA
    $ds9(mb).analysis.arch add separator
    $ds9(mb).analysis.arch add command -label "IRAS (NASA/IPAC)" \
	-command HVArchIRAS
    $ds9(mb).analysis.arch add separator
    $ds9(mb).analysis.arch add command -label "Chandra Public FTP (SAO)" \
	-command HVArchChandraFTP
    $ds9(mb).analysis.arch add command -label "Chandra (NASA/SAO)" \
	-command HVArchChandra
    $ds9(mb).analysis.arch add command -label "ROSAT All-Sky (MPE/MPG)" \
	-command HVArchRosat
    $ds9(mb).analysis.arch add command -label "SkyView (NASA/HEASARC)" \
	-command HVArchSkyView
    $ds9(mb).analysis.arch add command -label "W3Browse (NASA/HEASARC)" \
	-command HVArchW3Browse
    $ds9(mb).analysis.arch add separator
    $ds9(mb).analysis.arch add command -label "NVSS (NRAO)" \
	-command HVArchNVSS
    $ds9(mb).analysis.arch add command -label "4MASS (NRAO)" \
	-command HVArch4MASS
    $ds9(mb).analysis.arch add command -label "SIRTF FLS/VLA (NRAO)" \
	-command HVArchSIRTF
    $ds9(mb).analysis.arch add command -label "VLA First (NRAO)" \
	-command HVArchFirst
    $ds9(mb).analysis.arch add separator
    $ds9(mb).analysis.arch add command -label "SAO TDC (SAO)" \
	-command HVArchSAOTDC
    $ds9(mb).analysis.arch add command -label "NVO DIS (NASA/HEASARC)" \
	-command HVArchDIS
    $ds9(mb).analysis.arch add command -label "NED (NASA/IPAC)" \
	-command HVArchNED
    $ds9(mb).analysis.arch add command -label "SIMBAD@SAO (CDS)" \
	-command HVArchSIMBADSAO
    $ds9(mb).analysis.arch add command -label "SIMBAD@CDS (CDS)" \
	-command HVArchSIMBADCDS
    $ds9(mb).analysis.arch add command -label "ADS@SAO (NASA/SAO)" \
	-command HVArchADSSAO
    $ds9(mb).analysis.arch add command -label "ADS@CDS (NASA/SAO)" \
	-command HVArchADSCDS
    $ds9(mb).analysis.arch add separator

    HVArchUserMenu

    # Help Menu

    menu $ds9(mb).help -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Help"
    $ds9(mb).help add command -label "Reference Manual" -command HelpRef
    $ds9(mb).help add command -label "Keyboard Shortcuts" -command HelpKeyboard
    $ds9(mb).help add separator
    $ds9(mb).help add command -label "FAQ" -command HelpFAQ
    $ds9(mb).help add command -label "New Features" -command HelpNew
    $ds9(mb).help add command -label "Known Issues" -command HelpIssue
    $ds9(mb).help add command -label "Release Notes" -command HelpRelease
    $ds9(mb).help add command -label "Help Desk" -command HelpDesk
    $ds9(mb).help add separator
    $ds9(mb).help add command -label "Acknowledgment" -command HelpAck
    $ds9(mb).help add command -label "DS9 Home Page" -command HelpHome
}

proc UpdateDS9 {} {
    global debug
    if {$debug(tcl,update)} {
	puts "UpdateDS9 begin..."
    }

    UpdateFitsMenu
    UpdateEditMenu
    UpdateFrameMenu
    UpdateCubeDialog
    UpdateRGBDialog
    UpdateBinMenu
    UpdateBinDialog
    UpdatePanZoomMenu
    UpdatePanZoomDialog
    UpdateScaleMenu
    UpdateScaleDialog
    UpdateColormapMenu
    UpdateColormapDialog
    UpdateMarkerMenu
    UpdateGroupDialog
    UpdateWCSMenu
    UpdateAnalysisMenu

    UpdateContourMenu
    UpdateContourDialog
    UpdateGridMenu
    UpdateGridDialog
    UpdateDSSDialog

    UpdateGraphYAxis
    UpdateGraphXAxis

    if {$debug(tcl,update)} {
	puts "UpdateDS9 end...\n"
    }
}

# full coordinate menu
proc UpdateCoordMenu {frame which} {
    global current
    global ds9

    # no frame
    if {$frame == {}} {
	SetCoordMenu $which normal
	return
    }

    # unloaded frame
    if {![$frame has fits]} {
	SetCoordMenu $which normal
	return
    }

    # loaded frame
    if {[$frame has wcs WCS]} {
	$which entryconfig "WCS" -state normal
    } else {
	$which entryconfig "WCS" -state disabled
    }
    $which entryconfig "Multiple WCS" -state normal
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	if {[$frame has wcs WCS$l]} {
	    $which.wcs entryconfig "WCS $l" -state normal
	} else {
	    $which.wcs entryconfig "WCS $l" -state disabled
	}
    }

    if {[$frame has wcs equatorial WCS]} {
	SetSkyFrameMenu $which normal
    } else {
	SetSkyFrameMenu $which disabled
    }

    if {$ds9(amp,det)} {
	if {[$frame has detector]} {
	    $which entryconfig "Detector" -state normal
	} else {
	    $which entryconfig "Detector" -state disabled
	}

	if {[$frame has amplifier]} {
	    $which entryconfig "Amplifier" -state normal
	} else {
	    $which entryconfig "Amplifier" -state disabled
	}
    }

    if {[$frame has physical]} {
	$which entryconfig "Physical" -state normal
    } else {
	$which entryconfig "Physical" -state disabled
    }

    $which entryconfig "Image" -state normal
}

proc SetCoordMenu {which value} {
    global ds9

    $which entryconfig "WCS" -state $value
    $which entryconfig "Multiple WCS" -state $value
    $which entryconfig "Image" -state $value
    $which entryconfig "Physical" -state $value
    if {$ds9(amp,det)} {
	$which entryconfig "Amplifier" -state $value
	$which entryconfig "Detector" -state $value
    }

    $which entryconfig "Equatorial B1950" -state $value
    $which entryconfig "Equatorial J2000" -state $value
    $which entryconfig "ICRS" -state $value
    $which entryconfig "Galactic" -state $value
    $which entryconfig "Ecliptic" -state $value

    $which entryconfig "Degrees" -state $value
    $which entryconfig "Sexagesimal" -state $value

    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$which.wcs entryconfig "WCS $l" -state $value
    }
}

proc SetSkyFrameMenu {which value} {

    $which entryconfig "Equatorial B1950" -state $value
    $which entryconfig "Equatorial J2000" -state $value
    $which entryconfig "ICRS" -state $value
    $which entryconfig "Galactic" -state $value
    $which entryconfig "Ecliptic" -state $value

    $which entryconfig "Degrees" -state $value
    $which entryconfig "Sexagesimal" -state $value
}

proc SetSkyFrameMenu2 {which value} {

    $which entryconfig "Equatorial B1950" -state $value
    $which entryconfig "Equatorial J2000" -state $value
    $which entryconfig "ICRS" -state $value
    $which entryconfig "Galactic" -state $value
    $which entryconfig "Ecliptic" -state $value
}

# full WCS coordinate menu
proc UpdateWCSCoordMenu {frame which} {
    global current
    global ds9

    # no frame
    if {$frame == ""} {
	SetWCSCoordMenu $which disabled
	return
    }

    # unloaded frame
    if {![$frame has fits]} {
	SetWCSCoordMenu $which normal
	return
    }

    # loaded frame
    if {[$frame has wcs WCS]} {
	$which entryconfig "WCS" -state normal
    } else {
	$which entryconfig "WCS" -state disabled
    }
    $which entryconfig "Multiple WCS" -state normal
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	if {[$frame has wcs WCS$l]} {
	    $which.wcs entryconfig "WCS $l" -state normal
	} else {
	    $which.wcs entryconfig "WCS $l" -state disabled
	}
    }

    if {[$frame has wcs equatorial WCS]} {
	SetSkyFrameMenu $which normal
    } else {
	SetSkyFrameMenu $which disable
    }
}

proc SetWCSCoordMenu {which value} {
    global ds9

    $which entryconfig "WCS" -state $value
    $which entryconfig "Multiple WCS" -state $value

    $which entryconfig "Equatorial B1950" -state $value
    $which entryconfig "Equatorial J2000" -state $value
    $which entryconfig "ICRS" -state $value
    $which entryconfig "Galactic" -state $value
    $which entryconfig "Ecliptic" -state $value

    $which entryconfig "Degrees" -state $value
    $which entryconfig "Sexagesimal" -state $value

    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$which.wcs entryconfig "WCS $l" -state $value
    }
}

# dist menu
proc UpdateDistMenu {frame which defnoframe defnofits} {
    global current
    global ds9

    # no frame
    if {$frame == ""} {
	if {$defnoframe} {
	    SetDistMenu $which normal
	} else {
	    SetDistMenu $which disabled
	}
	return
    }

    # unloaded frame
    if {![$frame has fits]} {
	if {$defnofits} {
	    SetDistMenu $which normal
	} else {
	    SetDistMenu $which disabled
	}
	return
    }

    # loaded frame
    if {[$frame has wcs WCS]} {
	$which entryconfig "WCS" -state normal
    } else {
	$which entryconfig "WCS" -state disabled
    }
    $which entryconfig "Multiple WCS" -state normal
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	if {[$frame has wcs WCS$l]} {
	    $which.wcs entryconfig "WCS $l" -state normal
	} else {
	    $which.wcs entryconfig "WCS $l" -state disabled
	}
    }

    if {[$frame has wcs equatorial WCS]} {
	SetSkyFormatMenu $which normal
    } else {
	SetSkyFormatMenu $which disabled
    }

    if {$ds9(amp,det)} {
	if {[$frame has detector]} {
	    $which entryconfig "Detector" -state normal
	} else {
	    $which entryconfig "Detector" -state disabled
	}

	if {[$frame has amplifier]} {
	    $which entryconfig "Amplifier" -state normal
	} else {
	    $which entryconfig "Amplifier" -state disabled
	}
    }

    if {[$frame has physical]} {
	$which entryconfig "Physical" -state normal
    } else {
	$which entryconfig "Physical" -state disabled
    }

    $which entryconfig "Image" -state normal
}

proc SetDistMenu {which value} {
    global ds9

    $which entryconfig "WCS" -state $value
    $which entryconfig "Multiple WCS" -state $value
    $which entryconfig "Image" -state $value
    $which entryconfig "Physical" -state $value
    if {$ds9(amp,det)} {
	$which entryconfig "Amplifier" -state $value
	$which entryconfig "Detector" -state $value
    }

    $which entryconfig "Degrees" -state $value
    $which entryconfig "ArcMin" -state $value
    $which entryconfig "ArcSec" -state $value

    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	$which.wcs entryconfig "WCS $l" -state $value
    }
}

proc SetSkyFormatMenu {which value} {
    $which entryconfig "Degrees" -state $value
    $which entryconfig "ArcMin" -state $value
    $which entryconfig "ArcSec" -state $value
}

proc AdjustCoord {frame sysname} {
    upvar $sysname sys

    if {$frame != ""} {
	if {[$frame has fits]} {
	    switch -- $sys {
		image {}
		physical {
		    if {![$frame has physical]} {
			set sys image
		    }
		}
		amplifier {
		    if {![$frame has amplifier]} {
			set sys image
		    }
		}
		detector {
		    if {![$frame has detector]} {
			set sys image
		    }
		}
		wcs {
		    if {![$frame has wcs $sys]} {
			set sys image
		    }
		}
		default {
		    if {![$frame has wcs $sys]} {
			if [$frame has wcs wcs] {
			    set sys wcs
			} else {
			    set sys image
			}
		    }
		}
	    }
	}
    }
}

proc AdjustDist {frame sysname} {
    upvar $sysname sys
    global current

    if {$frame != ""} {
	if {[$frame has fits]} {
	    switch -- $sys {
		image {}
		physical {
		    if {![$frame has physical]} {
			set sys image
		    }
		}
		amplifier {
		    if {![$frame has amplifier]} {
			set sys image
		    }
		}
		detector {
		    if {![$frame has detector]} {
			set sys image
		    }
		}
		default {
		    if {![$frame has wcs $sys]} {
			set sys wcs
		    }
		}
	    }
	}
    }
}

proc DebugMenu {} {
    global ds9
    global menu
    global debug

    if {[winfo exist $ds9(mb).debug]} {
	return
    }

    $ds9(mb) add cascade -label "Debug" -menu $ds9(mb).debug

    menu $ds9(mb).debug -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Debug"
    $ds9(mb).debug add cascade -label "Tcl" -menu $ds9(mb).debug.tcl
    $ds9(mb).debug add cascade -label "SAOTk" -menu $ds9(mb).debug.saotk
    $ds9(mb).debug add cascade -label "IIS" -menu $ds9(mb).debug.iis

    menu $ds9(mb).debug.tcl -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Debug Tcl"
    $ds9(mb).debug.tcl add checkbutton -label "Events" \
	-variable debug(tcl,events)
    $ds9(mb).debug.tcl add checkbutton -label "Update" \
	-variable debug(tcl,update)
    $ds9(mb).debug.tcl add checkbutton -label "Idletasks" \
	-variable debug(tcl,idletasks)
    $ds9(mb).debug.tcl add checkbutton -label "Layout" \
	-variable debug(tcl,layout)
    $ds9(mb).debug.tcl add checkbutton -label "Info" \
	-variable debug(tcl,info)
    $ds9(mb).debug.tcl add checkbutton -label "Watch" \
	-variable debug(tcl,watch)
    $ds9(mb).debug.tcl add checkbutton -label "HV" \
	-variable debug(tcl,hv)
    $ds9(mb).debug.tcl add checkbutton -label "Grid" \
	-variable debug(tcl,grid)
    $ds9(mb).debug.tcl add checkbutton -label "HTTP" \
	-variable debug(tcl,http)
    $ds9(mb).debug.tcl add checkbutton -label "FTP" \
	-variable debug(tcl,ftp)

    menu $ds9(mb).debug.saotk -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Debug SAOTk"
    $ds9(mb).debug.saotk add checkbutton -label "AST" \
	-variable debug(saotk,ast) \
	-command "Debug ast debug(saotk,ast)"
    $ds9(mb).debug.saotk add checkbutton -label "Mosaic" \
	-variable debug(saotk,mosaic) \
	-command "Debug mosaic debug(saotk,mosaic)"
    $ds9(mb).debug.saotk add checkbutton -label "Parser" \
	-variable debug(saotk,parser) \
	-command "Debug parser debug(saotk,parser)"    
    $ds9(mb).debug.saotk add checkbutton -label "Perf" \
	-variable debug(saotk,perf) \
	-command "Debug perf debug(saotk,perf)"    
    $ds9(mb).debug.saotk add checkbutton -label "WCS" \
	-variable debug(saotk,wcs) \
	-command "Debug wcs debug(saotk,wcs)"    
    $ds9(mb).debug.saotk add checkbutton -label "Bin" \
	-variable debug(saotk,bin) \
	-command "Debug bin debug(saotk,bin)"    
    $ds9(mb).debug.saotk add checkbutton -label "GZ" \
	-variable debug(saotk,gz) \
	-command "Debug gz debug(saotk,gz)"    
    $ds9(mb).debug.saotk add checkbutton -label "RGB" \
	-variable debug(saotk,rgb) \
	-command "Debug rgb debug(saotk,rgb)"    

    menu $ds9(mb).debug.iis -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Debug IIS"
    $ds9(mb).debug.iis add checkbutton -label "IIS" \
	-variable debug(iis) -command IISDebug
}
