.TH sane-epkowa 5 "09-Apr-2004"
.IX sane-epkowa
.SH NAME
sane-epkowa - SANE backend for EPSON scanners
.SH DESCRIPTION
The
.B sane-epkowa
library implements a SANE (Scanner Access Now Easy) backend that
provides access to EPSON flatbed scanners.  This backend should be
considered
.B alpha-quality
software!  
.PP
At present, the following scanners are known to work with this backend:
.PP
.RS
Model:           
.br
japan            other
.br
---------------- -------------------
.br
GT-6600U         Perfection 610
.br
GT-6700U         Perfection 640U
.br
GT-7200U         Perfection 1250
.br
                 Perfection 1250 PHOTO
.br
GT-7300U         Perfection 1260
.br
                 Perfection 1260 PHOTO
.br
GT-7600S         Perfection 1200S
.br
GT-7600U         Perfection 1200U
.br
GT-7600UF        Perfection 1200U PHOTO
.br
GT-7700U         Perfection 1240U
.br
GT-8300UF        Perfection 1660 PHOTO
.br
GT-8700          Perfection 1640SU
.br
GT-8700F         Perfection 1640SU PHOTO
.br
GT-8200U         Perfection 1650
.br
GT-8200UF        Perfection 1650 PHOTO
.br
GT-9300UF        Perfection 2400 PHOTO
.br
GT-9400          Perfection 3170 PHOTO
.br
GT-9700F         Perfection 2450 PHOTO
.br
GT-9800F         Perfection 3200 PHOTO
.br
GT-F600          Perfection 4180 PHOTO
.br
GT-X700          Perfection 4870 PHOTO
.br
ES-2000          Expression 1600
.br
ES-2200          Expression 1680
.br
ES-6000          GT-10000
.br
ES-6000H         GT-10000+
.br
ES-6000HS
.br
ES-7000H         GT-15000
.br
ES-8500          Expression 1640XL
.br
ES-9000H         GT-30000
.br
ES-10000G        Expression 10000XL
.br
PX-A550          Stylus CX3500/CX3600
.br
                 Stylus CX4500/CX4600
.br
CC-600PX         Stylus CX5100/CX5200
.br
                 Stylus CX5300/CX5400
.br
                 Stylus CX6300/CX6400
.br
                 Stylus CX6500/CX6600
.br
PM-A700          Stylus Photo RX420/RX425/RX430
.br
                 Stylus Photo RX500/RX510
.br
PM-A850          Stylus Photo RX600/RX610
.br
PM-A870          Stylus Photo RX620/RX630
.br
GT-X800          Perfection 4990 PHOTO
.br
PM-A900
.br
.RE

For other scanners the software  may or may not work.  Please send mail to 
sane\-devel@lists.alioth.debian.org to report successes or failures.
.SH OPTIONS
The options the backend supports can either be selected through command line
options to programs like scanimage or through GUI elements in xscanimage or xsane.

Valid command line options and their syntax can be listed by using 
.RS
scanimage --help -d epkowa
.RE
Not all devices support all options.
.TP
.I Scan Mode
The 
.I --mode 
switch selects the basic mode of operation of the scanner valid choices are 
.I Binary, Gray and Color. 
The Binary mode is black and white only, Gray will produce up to 256 levels of gray
and Color means 24 bit color mode. Some scanners will internally use 36 bit color, 
the external interface however does only support 24 bits.

The 
.I --dropout 
option determines which color filters are used to scan in Binary mode. Valid choices
are None, Red, Green and Blue.

The
.I --halftoning
switch selects the mode that is used in Binary mode. Valid options are None, 
Halftone A (Hard Tone), Halftone B (Soft Tone), Halftone C (Net Screen), 
Dither A (4x4 Bayer), Dither B (4x4 Spiral), Dither C (4x4 Net Screen), 
Dither D (8x4 Net Screen), Text Enhanced Technology, Download pattern A, 
and Download pattern B.

The 
.I --dropout
switch selects the so called dropout color. Vald options are None, Red, Green 
and Blue. The default is None. The dropout color is used for 
monochrome scanning and selects the color that is not scanned. This can be used
to e.g. scan an original with a colored background.

The
.I --brightness
switch controls the brightness of the scan. Valid options are the numbers from -3 to 
3. The default is 0. The larger the brightness value, the brighter the image gets. If 
a user defined table for the gamma correction is selected, the brightness parameter is
not available.

The
.I --sharpness
switch sets the sharpness of the image data. Valid options are the numbers from -2 to 
2, with -2 meaning "Defocus", -1 "Defocus slightly", 0 "Normal", 1 "Sharpen slighly"
and 2 "Sharpen". 

The 
.I --gamma-correction
switch controls the scanne internal gamma correction. Valid options are "Default", "User
defined", "High density printing" "Low density printing" and "High contrast printing".

The 
.I --color-correction
switch controls the scanner internal color correction function. Valid options are "No 
Correction", "Impact-dot printers", "Thermal printers", "Ink-jet printers" and "CRT
monitors". The default is "CRT monitors". 

The 
.I --resolution
switch selects the resolution for a scan. Many EPSON scanners will scan in any resulution between
the lowest and highest possible value. The list reported by the scanner can be displayed using
the "--help -d epkowa" parameters to scanimage.

The 
.I --mirror
option controls the way the image is scanned. By reading the image data from right to left the
image is mirored. Valid options are "yes" and "no". The default is "no".

The 
.I --speed
option can improve the scan speed in monochrome mode. Valid options are "yes" or "no", the "yes"
option will speed up the scan if this option is supported.

The 
.I --auto-area-segmentation 
switch turns on the automatic area segmentation for monochrome scans. The scanner will try to 
determine which areas are text and which contain images. The image areas will be halftoned, 
and the text will be impoved. Valid options are "yes" and "no". The default is "yes".

The 
.I --gamma-table
parameter can be used to download a user defined gamma table. The options takes 256 values from
the range 0-255. In color mode this option equally affects the red, green, and blue channel.

The 
.I --red-gamma-table 
parameter can be used to download a user defined gamma table for the red channel. The valid
options are the same as for --gamma-table.

The 
.I --green-gamma-table 
parameter can be used to download a user defined gamma table for the green channel. The valid
options are the same as for --gamma-table.

The 
.I --blue-gamma-table 
parameter can be used to download a user defined gamma table for the blue channel. The valid
options are the same as for --gamma-table.

The color correction coefficients
.I --cct-1 --cct-2 --cct-3 ... --cct-9
will install color correction coefficients for the user defined color correction. Possible 
values are in the range -127..127.


The 
.I --preview
option requests a preview scan. The frontend software automatically selects a low 
resolution. Valid options are "yes" and "no". The default is "no".

The 
.I --preview-speed
options will increase the scan speed if this is supported by the scanner. Valid options
are "yes" and "no", the default is "no".
 

The geometry options
.I -l -t -x -y 
control the scan area: -l sets the top left x coordinate, -t the top left y coordinate, 
-x selects the width and -y the height of the scan aea. All parameters are specified in
milimeters.

The
.I --quick-format
option lets the user select a scan area with predefined sizes. Valid parameters are "CD", 
"A5 portrait", "A5 landscape", "Letter", "A4" and "max". The default is "max", which 
selects the largest possible area.

The
.I --source
option selects the scan source. Valid options depend on the installed options. The default
is "Flatbed".

The 
.I --auto-eject
option will eject a page after scanning from the document feeder. 


.SH CONFIGURATION FILE
The configuration file @CONFIGDIR@/epkowa.conf specifies the device(s) that the 
backend will use. The current version only supports one scanner per EPSON 
backend. Possible connection types are:
.TP
.I SCSI
This is the default, and if nothing else is specified the backend software will
open a given patch as SCSI device. More information about valid syntax for SCSI
devices can be found in sane-scsi(5).
.TP
.I PIP - Parallel Interface
The parallel interface can be configured in two ways: An integer number starting
at the beginning of a line will be interpreted as the IO address of the parallel
port. To make it clearer that a configured IO address is a parallel port the 
port address can be preceded by the string "PIO". The PIO connection does not
use a special device file in the /dev directory.
.TP
.I USB
A device file that is preceded by the string "USB" is treated as a scanner 
connected via the Universal Serial Bus. The correct special device file has
to be created prior to using it with Sane. See the USB documentation for 
more information about how to set up the USB subsystem and the required 
device files.
.SH FILES
.TP
.I @LIBDIR@/libsane-epkowa.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-epkowa.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_EPKOWA
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.

.TP
.B SANE_EPSON_CMD_LVL
This allows to override the function or command level that the backend 
uses to communicate with the scanner. The function level a scanner
supports is determined during the initialization of the device. If
the backend does not recognize the function level reported by the 
scanner it will default to function level B5. Valid function levels
are A1, A2, B1, B2, B3, B4, B5, B6, B7, B8 and F5. Use this feature
only if you know what you are doing!

.SH "SEE ALSO"

sane\-scsi(5), scanimage(1), xscanimage(1), xsane(1), sane\-epson(5)

.SH BUGS
When used with "scanimage -T" the backend hangs after sucessfully 
completing the tests. It is necessary to powercycle the scanner to
get the communication between backend and scanner going again.

Sometimes the scanner is not initialized correctly. The problem can be
resolved by killing the program and restarting it again. 

.SH UNSUPPORTED DEVICES
The backend may be used with EPSON scanners that are not yet listed 
under the list of supported devices. A scanner that is not recognized
may default to the function level B3, which means that not all 
functions that the scanner may be capable of are accessible. 

If the scanner is not even recognized as an EPSON scanner it is 
probably because the device name eported by the scanner is not in
the correct format. Please send this information to the backend 
maintainer (email address is in the AUTHORS file).devices. A scanner that is not recognized
may default to the function level B3, which means that not all 
functions that the scanner may be capable of are accessible. 

If the scanner is not even recognized as an EPSON scanner it is 
probably because the device name eported by the scanner is not in
the correct format. Please send this information to the backend 
maintainer (email address is in the AUTHORS file).

.SH AUTHOR

EPSON KOWA Corporation
