dnl  HP-PA 2.0 mpn_lshift -- Left shift.

dnl  Copyright 1997, 2000, 2002 Free Software Foundation, Inc.

dnl  This file is part of the GNU MP Library.

dnl  The GNU MP Library is free software; you can redistribute it and/or modify
dnl  it under the terms of the GNU Lesser General Public License as published by
dnl  the Free Software Foundation; either version 2.1 of the License, or (at your
dnl  option) any later version.

dnl  The GNU MP Library is distributed in the hope that it will be useful, but
dnl  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
dnl  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
dnl  License for more details.

dnl  You should have received a copy of the GNU Lesser General Public License
dnl  along with the GNU MP Library; see the file COPYING.LIB.  If not, write to
dnl  the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
dnl  MA 02111-1307, USA.


dnl  This runs at 1.5 cycles/limb on PA8000 and 1.0 cycles/limb on PA8500.

include(`../config.m4')

dnl  INPUT PARAMETERS
define(`rp',`%r26')
define(`up',`%r25')
define(`n',`%r24')
define(`cnt',`%r23')

ifdef(`HAVE_ABI_2_0w',
`       .level  2.0W
',`     .level  2.0N
')
PROLOGUE(mpn_lshift)
	shladd		n, 3, up, up
	shladd		n, 3, rp, rp
	subi		64, cnt, cnt
	mtsar		cnt
	ldd		-8(up), %r21
	addib,=		-1, n, L(end)
	shrpd		%r0, %r21, %sar, %r29	C compute carry out limb
	depw,z		n, 31, 3, %r28		C r28 = (size & 7)
	sub		%r0, n, %r22
	depw,z		%r22, 28, 3, %r22	C r22 = 8 * (-size & 7)
	add		up, %r22, up		C offset up
	blr		%r28, %r0		C branch into jump table
	add		rp, %r22, rp		C offset rp
	b		L(0)
	nop
	b		L(1)
	copy		%r21, %r20
	b		L(2)
	nop
	b		L(3)
	copy		%r21, %r20
	b		L(4)
	nop
	b		L(5)
	copy		%r21, %r20
	b		L(6)
	nop
	b		L(7)
	copy		%r21, %r20

L(loop)
L(0)	ldd		-16(up), %r20
	shrpd		%r21, %r20, %sar, %r21
	std		%r21, -8(rp)
L(7)	ldd		-24(up), %r21
	shrpd		%r20, %r21, %sar, %r20
	std		%r20, -16(rp)
L(6)	ldd		-32(up), %r20
	shrpd		%r21, %r20, %sar, %r21
	std		%r21, -24(rp)
L(5)	ldd		-40(up), %r21
	shrpd		%r20, %r21, %sar, %r20
	std		%r20, -32(rp)
L(4)	ldd		-48(up), %r20
	shrpd		%r21, %r20, %sar, %r21
	std		%r21, -40(rp)
L(3)	ldd		-56(up), %r21
	shrpd		%r20, %r21, %sar, %r20
	std		%r20, -48(rp)
L(2)	ldd		-64(up), %r20
	shrpd		%r21, %r20, %sar, %r21
	std		%r21, -56(rp)
L(1)	ldd		-72(up), %r21
	ldo		-64(up), up
	shrpd		%r20, %r21, %sar, %r20
	std		%r20, -64(rp)
	addib,>		-8, n, L(loop)
	ldo		-64(rp), rp

L(end)	shrpd		%r21, %r0, %sar, %r21
	std		%r21, -8(rp)
	bve		(%r2)
ifdef(`HAVE_ABI_2_0w',
`	copy		%r29,%r28
',`	extrd,u		%r29, 31, 32, %r28
')
EPILOGUE(mpn_lshift)
