/* iterator.c - The iterator support-data structure.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif
/* C89 */
#include <stdlib.h>
/* Gettext */
#include <gettext.h> /* will include <libintl.h> if ENABLE_NLS */
#define _(String) gettext(String)
/* common */
#include "iterator.h"
#include "error.h"

bool
iterator_has_next(Iterator *it)
{
	return it->class->has_next(it);
}

void *
iterator_next(Iterator *it)
{
	return it->class->next(it);
}

void *
iterator_previous(Iterator *it)
{
	if (it->class->previous == NULL)
		internal_error(_("Called iterator_previous on iterator that doesn't support it"));
	return it->class->previous(it);
}

void
iterator_remove(Iterator *it)
{
	if (it->class->remove == NULL)
		internal_error(_("Called iterator_remove on iterator that doesn't support it"));
	it->class->remove(it);
}

void
iterator_add(Iterator *it, void *value)
{
	if (it->class->add == NULL)
		internal_error("Called iterator_add on iterator that doesn't support it");
	it->class->add(it, value);
}

void
iterator_restart(Iterator *it)
{
	it->class->restart(it);
}

void
iterator_free(Iterator *it)
{
	if (it->class->free == NULL)
		free(it);
	else 
		it->class->free(it);
}
