/***************************************************************************
  miscingredient.cpp
  -------------------
  A miscellaneous ingredient class
  -------------------
  Copyright 1999-2004, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include <cmath>

#include <qregexp.h>
#include <qstringlist.h>

#include "miscingredient.h"

//////////////////////////////////////////////////////////////////////////////
// Construction, Destruction                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// MiscIngredient()
// ----------------
// constructor

MiscIngredient::MiscIngredient()
    : name_("Generic"), quantity_(), notes_("")
{ ; }

MiscIngredient::MiscIngredient(const QString &name, const Quantity &quantity,
                               const QString &notes)
    : name_(name), quantity_(quantity), notes_(notes)
{ ; }

MiscIngredient::~MiscIngredient() { ; }

//////////////////////////////////////////////////////////////////////////////
// MiscIngredient()
// ----------------
// copy constructor

MiscIngredient::MiscIngredient(const MiscIngredient &m)
    : name_(m.name_), quantity_(m.quantity_), notes_(m.notes_)
{ ; }

//////////////////////////////////////////////////////////////////////////////
// Operators                                                                //
//////////////////////////////////////////////////////////////////////////////

MiscIngredient MiscIngredient::operator=(const MiscIngredient &m)
{
    if (this != &m) {
        name_ = m.name_;
        quantity_ = m.quantity_;
        notes_ = m.notes_;
    }
    return *this;
}

bool MiscIngredient::operator==(const MiscIngredient &m)
{
    return (name_ == m.name_)
        && (quantity_ == m.quantity_)
        && (notes_ == m.notes_);
}

//////////////////////////////////////////////////////////////////////////////
// MiscIngredientListItem Class                                             //
//////////////////////////////////////////////////////////////////////////////

MiscIngredientListItem::MiscIngredientListItem(QListView * parent,
                                               QString a, QString b, QString c,
                                               QString d, QString e, QString f,
                                               QString g, QString h)
    : QListViewItem(parent, a, b, c, d, e, f, g, h), mit_(0) { ; }

MiscIngredientListItem::~MiscIngredientListItem() { ; }

void MiscIngredientListItem::setToIterator()
{
    setText(0, (*mit_).name());
    setText(1, QString::number((*mit_).quantity().amount(), 'f', 2));
    setText(2, (*mit_).notes());
}

// reimplemented for numerical sorting
int MiscIngredientListItem::compare(QListViewItem* item,
                                    int column, bool asc) const
{
    switch (column) {
      case 1: { // remove suffixes and decimals in these fields
          QRegExp regex("[0-9.]+");
          regex.search(text(column));
          int first = (int) regex.cap(0).toDouble() * 1000;
          regex.search(item->text(column));
          int second = (int) regex.cap(0).toDouble() * 1000;
          return (first - second);
      }

      default:
          return QListViewItem::compare(item, column, asc);
    }
}
