/***************************************************************************
  ingredientpage.h
  -------------------
  Generic dialog page for an ingredient type
  -------------------
  Copyright 1999-2004, David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef INGREDIENTPAGE_H
#define INGREDIENTPAGE_H

#include <qwidget.h>

class Controller;
class FixedSpinBox;
class Model;
class QBoxLayout;
class QComboBox;
class QLabel;
class QListView;
class QPushButton;
class View;

class IngredientPage : public QWidget  {
   Q_OBJECT
public:
    // constructor
    IngredientPage(Model *model, View *view, Controller *controller,
                   const char* name);
    // destructor
    ~IngredientPage();

protected:
    Model *model_;
    View *view_;
    Controller *controller_;

    QBoxLayout* pagelayout_;
    QBoxLayout* rowonelayout_;
    QBoxLayout* rowtwolayout_;
    
    QListView* itemslistview_;
    QLabel* itemlabel_;
    QComboBox* itemcombo_;
    QLabel* quantitylabel_;
    FixedSpinBox* quantityspin_;
    QPushButton* addbutton_;
    QPushButton* applybutton_;
    QPushButton* removebutton_;
    QWidget* spacer_;
};

#endif // INGREDIENTPAGE_H
