#! /usr/bin/env python
## -*- coding: iso-8859-1 -*-
##
## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 2003 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 2002 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 2001 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 2000 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
## All Rights Reserved.
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus@oberhumer.com>
## http://www.oberhumer.com/pysol
##
##---------------------------------------------------------------------------##

# imports
import sys, os, re, string, time, types
import traceback

# PySol imports
from mfxtools import *
from mfxutil import EnvError
from util import PACKAGE, VERSION, VERSION_TUPLE
from main import main


# /***********************************************************************
# // Init games database
# ************************************************************************/


# import the games
path = sys.path[:]
p0 = sys.path[0]
g = {}
##for d in ("",):
for d in ("", "special", "contrib",):
##for d in ("", "new", "special", "contrib",):
    d = os.path.join("games", d)
    sys.path.insert(0, os.path.join(p0, d))
    try:
        names = os.listdir(sys.path[0])
    except EnvError:
        names = []
    names = map(os.path.normcase, names)
    names.sort()
    for name in names:
        m = re.search(r"^(.+)\.py$", name)
        if m:
            n = m.group(1)
            if not g.has_key(n):
                try:
                    g[n] = 1
                    exec "import " + n
                except:
                    raise
                    traceback.print_exc()
                    pass
sys.path = path
del p0, g, d, path, names, name, m



# /***********************************************************************
# // Redirect all pickable classes into the __main__ module
# ************************************************************************/


# We need this so that saved games are compatible between the
# bundled and the unbundled versions. This is because of the fact
# that in the bundled version all classes reside in the module `__main__',
# while there are different modules in the unbundled version, and
# this causes problems with pickling as the Un-/Pickler won't find
# the corresponding module/class combination.

t = {}
for m in ("app", "mfxutil", "random", "move"):
    mod = sys.modules[m]
    for k, v in mod.__dict__.items():
        if type(v) is types.ClassType and not t.has_key(k):
            ##print k, v
            t[k] = 1
            # 1) import the class into __main__ so that we can
            #    load bundled games
            exec "from " + m + " import " + k
            # 2) set the module of the class to "__main__" so that
            #    the bundled version can load our unbundled savegames
            v.__module__ = "__main__"

del t, m, mod, k, v



# /***********************************************************************
# // let's go
# ************************************************************************/

sys.exit(main(sys.argv))

