#!/usr/bin/env python

# ======================================================================
# This file contains the launcher code for the example of the MVC
# framework. 

# Is has been adapted by Ionutz Borcoman <borco@go.ro> to deal with
# possibly missing installation of the gtkmvc module
# ======================================================================

import imp
try:
    imp.find_module("gtkmvc")
except ImportError, er:
    import sys
    import os.path
    sys.path.append(os.path.abspath('../'))
    print "Warning: module gtkmvc not installed, using local package..."
    imp.find_module("gtkmvc")
    
from ex_model import ExampleModel
from ex_ctrl  import ExampleController
from ex_view  import ExampleView

from gtk import mainloop

def main():
    model = ExampleModel()
    ctrl  = ExampleController(model)
    view  = ExampleView(ctrl)

    # Starts the GTK toolkit:
    mainloop()
    return
    
if __name__ == '__main__':
    main()
