/*
 * accountdlg.h - dialogs for manipulating PsiAccounts
 * Copyright (C) 2001, 2002  Justin Karneges
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef ACCOUNTDLG_H
#define ACCOUNTDLG_H

#include<qca.h>
#include"ui_accountmanage.h"
#include"ui_accountadd.h"
#include"ui_accountreg.h"
#include"ui_accountremove.h"
#include"ui_accountmodify.h"
#include"ui_pgpkey.h"
#include"xmpp.h"
#include"openpgp.h"

namespace XMPP
{
	class Jid;
	class Client;
}

using namespace XMPP;

class PsiCon;
class PsiAccount;
class QListViewItem;
class UserAccount;
class ProxyManager;
class ProxyChooser;

namespace QCA
{
	class Cert;
}

class MiniClient : public QObject
{
	Q_OBJECT
public:
	MiniClient(QObject *parent=0);
	~MiniClient();

	void reset();
	void connectToServer(const Jid &j, bool ssl, const QString &host, int port, ProxyManager *pm, int proxy, QString *pass);
	void close();
	Client *client();

signals:
	void handshaken();
	void error();

private slots:
	void tls_handshaken();
	void cs_connected();
	void cs_securityLayerActivated(int);
	void cs_needAuthParams(bool, bool, bool);
	void cs_authenticated();
	void cs_connectionClosed();
	void cs_delayedCloseFinished();
	void cs_warning(int);
	void cs_error(int);

private:
	AdvancedConnector *conn;
	ClientStream *stream;
	QCA::TLS *tls;
	QCATLSHandler *tlsHandler;
	QPtrList<QCA::Cert> certList;
	Client *_client;
	Jid j;
	QString pass;
};

class AccountManageDlg : public AccountManageUI
{
	Q_OBJECT
public:
	AccountManageDlg(PsiCon *, const char *name=0);
	~AccountManageDlg();

private slots:
	void qlv_selectionChanged(QListViewItem *);
	void add();
	void modify();
	void modify(QListViewItem *);
	void remove();
	void accountAdded(PsiAccount *);
	void accountUpdated(PsiAccount *);
	void accountRemoved(PsiAccount *);

private:
	PsiCon *psi;
};

class AccountAddDlg : public AccountAddUI
{
	Q_OBJECT
public:
	AccountAddDlg(PsiCon *, QWidget *parent=0, const char *name=0);
	~AccountAddDlg();

private slots:
	void add();
	void setAddButton(const QString &);

private:
	PsiCon *psi;
};

class AccountModifyDlg : public AccountModifyUI
{
	Q_OBJECT
public:
	AccountModifyDlg(PsiAccount *, QWidget *parent=0, const char *name=0);
	~AccountModifyDlg();

	void setPassword(const QString &);

private slots:
	void sslToggled(bool);
	void hostToggled(bool);

	void detailsVCard();
	void detailsChangePW();

	void save();

	void pgpToggled(bool);
	void optpp_toggled(bool);
	void chooseKey();
	void clearKey();

private:
	PsiAccount *pa;
	ProxyChooser *pc;
	QString keyID;

	void updateUserID();
	void setKeyID(bool b, const QString &s="");
};

class AccountRegDlg : public AccountRegUI
{
	Q_OBJECT
public:
	AccountRegDlg(ProxyManager *, QWidget *parent=0, const char *name=0);
	~AccountRegDlg();

	Jid jid;
	QString sp_host, pass;
	int sp_port;
	bool ssl, opt_host;
	int proxy;

protected:
	// reimplemented
	//void closeEvent(QCloseEvent *);

public slots:
	void done(int);

private slots:
	void sslToggled(bool);
	void hostToggled(bool);
	void reg();

	void client_handshaken();
	void client_error();

	void reg_finished();

	void block();
	void unblock();

private:
	ProxyManager *proxyman;
	ProxyChooser *pc;
	MiniClient *client;
};

class AccountRemoveDlg : public AccountRemoveUI
{
	Q_OBJECT
public:
	AccountRemoveDlg(ProxyManager *, const UserAccount &, QWidget *parent=0, const char *name=0);
	~AccountRemoveDlg();

protected:
	// reimplemented
	//void closeEvent(QCloseEvent *);

public slots:
	void done(int);

private slots:
	void remove();
	void bg_clicked(int);

	void client_handshaken();
	void client_error();
	void unreg_finished();

private:
	class Private;
	Private *d;

	MiniClient *client;
};

#endif
