# --------------------------------------------------------------------------- #
# $Id: pllmodules.py,v 1.6 2003/12/31 14:33:37 weismann Exp $
# --------------------------------------------------------------------------- #
#

import md5
import os
import string
import pllog
from pllshared import *
import sys

def md5_file(filename, extra=""):
	"""Returns the md5sum of a file or an invalid sum (the empty string)
	if the file does not exist."""
	if not os.path.isfile(filename):
		return ""
	else:
		return md5.new(open(filename).read()+extra).hexdigest()

def find_program(filename):
	path = os.path.expandvars('$PATH')
	dirs = string.split(path,':')
	result = 0
	for d in dirs:
		f = os.path.normpath(d+"/"+filename)
		if os.path.isfile(f): 
			pllog.debug(gt("Program found: %s"%f))
			if os.access(f, os.X_OK):
				pllog.debug(gt("Program %s has execute permission"%f))
				result = f
				break
	return result

def checkversions():
	str_version = sys.version[:3]
	version = map(int, str_version.split('.'))
	if version < [2, 2]:
		raise SystemExit, "ERROR: python version 2.2 or higher is required, %s found" % str_version
	try:
		import libpointless
	except (ImportError, AssertionError):
		raise SystemExit, 'ERROR: Could not find a recent version of pointless installed on the system'

def check_programs(external_programs):
	for p in external_programs:
		if not find_program(p):
			raise SystemExit, "ERROR: Missing %s on the path, this program is required to install the module" %p
