from twisted.application import service
from twisted.application import internet

from nevow import appserver
from nevow import inevow
from nevow import loaders
from nevow import rend

from nevow import tags as T

class Simple(rend.Page):

    def render_theTitle(self, context, data):
        return [x * 5 for x in "title"]

    def render_sample(self, context, data):
        request = inevow.IRequest(context)
        session = inevow.ISession(context)
        count = getattr(session, 'count', 1)
        session.count = count + 1
        return ["Welcome, person from ", request.client[1], "! You are using ",
            request.getHeader('user-agent'), " and have been here ", count, " times."]

    docFactory = loaders.stan(
        T.html[
            T.head[
                T.title[render_theTitle]
            ],
            T.body[
                T.h1["Hello."],
                render_sample,
            ]
        ])


application = service.Application("simple")
internet.TCPServer(
    8080, 
    appserver.NevowSite(
        Simple()
    )
).setServiceParent(application)
