#include <qfile.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlistview.h>
#include <qdatetime.h>
#include "xport.h"
#include "include/sql.h"
#include "mainwindow.h"
#include "loglistviewitem.h"

void Xport::xport_import()
{
	if(mysql_select_db(mysql, import_database->currentText().latin1()))
		return;
	
	QFile sql(import_file->text());

	if(sql.open(IO_ReadOnly) == FALSE)
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Script file open failed."));
		return;
	}
		
	char *z1= new char[sql.size() + 1];
	memset(z1, 0, sql.size() + 1);
	sql.readBlock(z1, sql.size());
	sql.close();

	unsigned int s;

	QString z = SQL::strip_comment(QString(z1).latin1());
	QList<QString> query = SQL::split_sql(z);
	query.setAutoDelete(TRUE);

	for(s = 0; s < query.count(); s++)
	{
		if((*query.at(s)).stripWhiteSpace().isEmpty())
			continue;

		if(SQL::sql_query((*query.at(s)).stripWhiteSpace().latin1()))
		{
			delete []z1;
			QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
			return;
		}
	}
			
	delete []z1;

	emit signal_schema();

	QMessageBox::information(this, tr("MySQL Navigator"), tr("Import has been successfully completed."));
}
