#include <qmessagebox.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qfile.h>
#include <qlistview.h>
#include <qdatetime.h>
#include "xport.h"
#include "mainwindow.h"
#include "loglistviewitem.h"
#include "include/sql.h"

void Xport::xport_export()
{
	bool all;

	QString database  = export_database->currentText();

	if(export_table->currentItem() == 0)
	{
		all = TRUE;
	}
	else
	{
		all = FALSE;
	}

	xport = "";

	xport += "# MySQL Navigator Xport\n";
	xport += "# Database: ";
	xport += database;
	xport += "\n";
	xport += "# " +  host;
	xport += "\n\n";

	xport += "# CREATE DATABASE " + database + ";\n";
	xport += "# USE " + database + ";\n\n";
	
	if(all)
	{
		if(export_all_table(database))
		{
			export_save();
			QMessageBox::information(this, tr("MySQL Navigator"), tr("Export has been successfully completed."));
		}
	}
	else
	{
		if(export_one_table(database, export_table->currentText()))
		{
			export_save();
			QMessageBox::information(this, tr("MySQL Navigator"), tr("Export has been successfully completed."));
		}
	}
}

bool Xport::export_all_table(const QString &database)
{
	MYSQL_RES *result;
	MYSQL_ROW row;

	if(mysql_select_db(mysql, database.latin1()))
		return FALSE;

	result = mysql_list_tables(mysql, NULL);

	if(result == NULL)
	{
		return TRUE;
	}

	while((row = mysql_fetch_row(result)))
	{
		export_one_table(database, row[0]);
	}

	//debug(xport.latin1());

	return TRUE;			
}

bool Xport::export_one_table(const QString &database, const QString &table)
{
	MYSQL_RES *result;
	MYSQL_ROW row;
	MYSQL_FIELD *field;

	QString z;
	
	if(mysql_select_db(mysql, database.latin1()))
		return FALSE;

    lock_table(table);

	if(SQL::sql_query(QString(QString("show create table ") + table).latin1()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		return FALSE;
	}

	result = mysql_store_result(mysql);

	if(result == NULL)
	{
		return FALSE;
	}

	row = mysql_fetch_row(result);

	xport += "#\n# Table structure for table \'";
	xport += table;
	xport += "\'\n#\n\n";

	xport += "# DROP TABLE IF EXISTS ";
	xport += table;
	xport += ";\n";

	xport += row[1];
	xport += ";\n\n";

	mysql_free_result(result);

	if(this->table->isOn())
    {
        unlock_table();
        return TRUE;
    }

	xport += "#\n# Dumping data for table \'";
	xport += table;
	xport += "\'\n#\n\n";

	if(mysql_select_db(mysql, database.latin1()))
		return FALSE;

	if(SQL::sql_query(QString(QString("select * from ") + table).latin1()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)) + QString(tr("\nPlease retry again.")));
		return FALSE;
	}

	result = mysql_store_result(mysql);	

	if(result == NULL)
	{
		return FALSE;
	}

	z = "";

	int s = 0;;

	while((row = mysql_fetch_row(result)))
	{
		z += QString("INSERT INTO ") + table + QString(" VALUES (");

		s ++;

		int s_ = 0;	

		while((field = mysql_fetch_field(result)))
		{
			if(IS_NUM(field->type) == FALSE)
			{
				if(row[s_] == NULL)
				{
					z += "NULL";
				}
				else
				{
					unsigned long *size = mysql_fetch_lengths(result);
					char *value = new char[size[s_] * 2 + 1];
					mysql_real_escape_string(mysql, value, row[s_], size[s_]);
					
					z += "\'";
					//z += row[s_];
					z += value;
					z += "\'";

					delete []value;
				}
			}
			else
			{
				if(row[s_] == NULL)
				{
					z += "NULL";
				}
				else
				{
					z += row[s_];
				}
			}
			z += ",";
			s_++;
		}

		z = z.left(z.length() - 1);

		z += QString(");");

		xport += z;
		xport += "\n";

		//debug(z.latin1());
	
		mysql_free_result(result);

		if(SQL::sql_query(QString(QString("select * from ") + table).latin1()))
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)) + QString(tr("\nPlease retry again.")));
			return FALSE;
		}

		result = mysql_store_result(mysql);	

		mysql_data_seek(result, s);
		
		z = "";
	}

	xport += "\n";

	mysql_free_result(result);

    unlock_table();

	return TRUE;			
}

void Xport::export_save()
{
	QFile z(export_file->text());

	if(z.open(IO_WriteOnly) ==FALSE)
	{
		debug("open() system call fail.");
		return;
	}

	z.writeBlock(xport.latin1(), xport.length());

	z.close();

	xport = "";
}

bool Xport::lock_table(const QString &table)
{
    if(SQL::sql_query(QString(QString("lock tables ") + table + QString(" write")).latin1()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		return FALSE;
	}
    return TRUE;
}

bool Xport::unlock_table()
{
    if(SQL::sql_query(QString("unlock tables").latin1()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		return FALSE;
	}
    return TRUE;
}
