#include "servernew.h"
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qfiledialog.h>

void ServerNew::slot_fire()
{
	if(socket->text().isEmpty())
	{
		if(host->text().isEmpty())
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter host name."));
			return;
		}
	}
	else
	{
		host->setText("localhost");
	}

	if(user->text().isEmpty())
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter user name."));
		return;
	}

	flag = TRUE;
	QDialog::close();
}

void ServerNew::slot_close()
{
	QDialog::close();
}

void ServerNew::slot_socket()
{
	QString sql = QFileDialog::getOpenFileName();

	if(!sql.isEmpty())
	{
		socket->setText(sql);
	}
}
