#include <qbuttongroup.h>
#include <qdom.h>
#include <qfile.h>
#include <stdlib.h>
#include "mainwindow.h"
#include "query.h"
#include "base64.h"

void Query::signal_connect()
{
	connect(query, SIGNAL(activated(const QString &)), this, SLOT(slot_sql(const QString &)));
	connect(parentWidget(), SIGNAL(signal_close()), this, SLOT(slot_close()));
	connect((const QObject *)qApp->mainWidget(), SIGNAL(signal_database()), this, SLOT(slot_database()));
}

void Query::resizeEvent(QResizeEvent *)
{
}

void Query::closeEvent(QCloseEvent *)
{
}

bool Query::is_exist_in_query(const QString &sql)
{
	for(int z = 0; z < query->count(); z++)
		if(query->text(z) == sql)
			return TRUE;

	return FALSE;
}

bool Query::save_sql()
{
	QDomElement value;
	QDomElement s;
	QDomDocument z("mysql");

	// document element
	z.appendChild(z.createElement("mysql"));	

	// query
	for(int _s = 0; _s < query->count(); _s++)
	{
		z.documentElement().appendChild(value = z.createElement("query"));
		value.appendChild(s = z.createElement("name"));
		s.appendChild(z.createTextNode(query->text(_s)));

		value.appendChild(s = z.createElement("database"));
		s.appendChild(z.createTextNode(sql_map.find(query->text(_s)).data().database));
		
		value.appendChild(s = z.createElement("sql"));
		
		QString sql = sql_map.find(query->text(_s)).data().sql;
		char *s_  = new char[sql.length() * 4 + 1];
		ToBase64(s_, (const void *)sql.latin1(), sql.length(), TRUE);
		s.appendChild(z.createTextNode(QString("$") + s_));
		delete []s_;
	}

	char s1[255];

#ifndef WIN32
	sprintf(s1, "%s/%s", getenv("HOME"), ".mysqlnavigator.sql");
#else
	sprintf(s1, "%s/%s", "c:", ".mysqlnavigator.sql");
#endif

	QFile s2(s1);

	if(s2.open(IO_WriteOnly) == FALSE)
		return FALSE;

	s2.writeBlock(z.toString(), z.toString().length());

	s2.close();

	return TRUE;
}

bool Query::load_sql()
{
	char s1[255];

#ifndef WIN32
	sprintf(s1, "%s/%s", getenv("HOME"), ".mysqlnavigator.sql");
#else
	sprintf(s1, "%s/%s", "c:", ".mysqlnavigator.sql");
#endif

	QFile s2(s1);

	if(s2.open(IO_ReadOnly) == FALSE)
		return FALSE;

	QDomDocument document("mysql");

	if(document.setContent(&s2) == FALSE)
	{
		s2.close();
		return FALSE;
	}

	s2.close();

	QDomNodeList sql;

	sql = document.elementsByTagName("query");

	for(unsigned int s = 0; s < sql.count(); s++)
	{
		QString name;
		struct sql_data data;

		name = sql.item(s).firstChild().firstChild().nodeValue();
		query->insertItem(name);

		data.database = sql.item(s).firstChild().nextSibling().firstChild().nodeValue();
		data.sql = sql.item(s).lastChild().firstChild().nodeValue();

		if(data.sql.at(0) == '$')
		{
			data.sql = data.sql.remove(0, 1);
			char *z = new char[data.sql.length() + 1];
			FromBase64(z, (const void *)data.sql.latin1(), data.sql.length(), TRUE);
			data.sql = z;
			delete []z;
		}

		sql_map.insert(name, data);
	}

	return TRUE;
}
