#include <qlistview.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qmessagebox.h>
#include <qlistview.h>
#include <qdatetime.h>
#include "privilege.h"
#include "mainwindow.h"
#include "loglistviewitem.h"
#include "include/sql.h"

void Privilege::slot_close()
{
	parentWidget()->close();
}

void Privilege::slot_fire()
{
	QString sql;

	if(grant->isOn())
	{
		sql += "GRANT ";
		if(select->isOn())
			sql += QString("SELECT") + ", ";
		if(insert->isOn())
			sql += QString("INSERT") + ", ";
		if(update->isOn())
			sql += QString("UPDATE") + ", ";
		if(delete_->isOn())
			sql += QString("DELETE") + ", ";
		if(references->isOn())
			sql += QString("REFERENCES") + ", ";
		if(usage->isOn())
			sql += QString("USAGE") + ", ";
		if(index->isOn())
			sql += QString("INDEX") + ", ";
		if(alter->isOn())
			sql += QString("ALTER") + ", ";
		if(create->isOn())
			sql += QString("CREATE") + ", ";
		if(drop->isOn())
			sql += QString("DROP") + ", ";
		if(reload->isOn())
			sql += QString("RELOAD") + ", ";
		if(shutdown->isOn())
			sql += QString("SHUTDOWN") + ", ";
		if(process->isOn())
			sql += QString("PROCESS") + ", ";
		if(file->isOn())
			sql += QString("FILE") + ", ";

		sql = sql.left(sql.length() - 2);
		sql += " ";

		sql += "ON ";	
		sql += database->currentText();
		sql += ".";
		sql += table->currentText();
		sql += " TO ";
		sql += "'";
		sql += user->currentText();
		sql += "'";
		sql += "@";
		sql += "'";
		sql += host->currentText();
		sql += "'";

		if(grant_->isOn())
			sql += " WITH GRANT OPTION";

		//debug(sql.latin1());
	}
	else
	{
		sql += "REVOKE ";
		if(select->isOn())
			sql += QString("SELECT") + ", ";
		if(insert->isOn())
			sql += QString("INSERT") + ", ";
		if(update->isOn())
			sql += QString("UPDATE") + ", ";
		if(delete_->isOn())
			sql += QString("DELETE") + ", ";
		if(references->isOn())
			sql += QString("REFERENCES") + ", ";
		if(usage->isOn())
			sql += QString("USAGE") + ", ";
		if(index->isOn())
			sql += QString("INDEX") + ", ";
		if(alter->isOn())
			sql += QString("ALTER") + ", ";
		if(create->isOn())
			sql += QString("CREATE") + ", ";
		if(drop->isOn())
			sql += QString("DROP") + ", ";
		if(reload->isOn())
			sql += QString("RELOAD") + ", ";
		if(shutdown->isOn())
			sql += QString("SHUTDOWN") + ", ";
		if(process->isOn())
			sql += QString("PROCESS") + ", ";
		if(file->isOn())
			sql += QString("FILE") + ", ";

		sql = sql.left(sql.length() - 2);
		sql += " ";

		sql += "ON ";	
		sql += database->currentText();
		sql += ".";
		sql += table->currentText();
		sql += " FROM ";
		sql += "'";
		sql += user->currentText();
		sql += "'";
		sql += "@";
		sql += "'";
		sql += host->currentText();
		sql += "'";

		//debug(sql.latin1());
	}

	if(SQL::sql_query(sql.latin1()))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
	}
	else
	{
		mysql_reload(mysql);
		
		if(grant->isOn())
		{
			QMessageBox::information(this, tr("MySQL Navigator"), tr("Privileges have been successfully granted"));
		}
		else
		{
			QMessageBox::information(this, tr("MySQL Navigator"), tr("Privileges have been successfully revoked"));
		}
	  }
}

void Privilege::slot_choose()
{
	if(choose->isOn())
	{
		select->setOn(TRUE);
		insert->setOn(TRUE);
   		update->setOn(TRUE);
    	delete_->setOn(TRUE);
    	references->setOn(TRUE);
    	usage->setOn(TRUE);
    	index->setOn(TRUE);
    	alter->setOn(TRUE);
    	create->setOn(TRUE);
    	drop->setOn(TRUE);
   		reload->setOn(TRUE);
    	shutdown->setOn(TRUE);
    	process->setOn(TRUE);
    	file->setOn(TRUE);
    	grant_->setOn(TRUE);
	}
	else
	{
		select->setOn(FALSE);
		insert->setOn(FALSE);
   		update->setOn(FALSE);
    	delete_->setOn(FALSE);
    	references->setOn(FALSE);
    	usage->setOn(FALSE);
    	index->setOn(FALSE);
    	alter->setOn(FALSE);
    	create->setOn(FALSE);
    	drop->setOn(FALSE);
   		reload->setOn(FALSE);
    	shutdown->setOn(FALSE);
    	process->setOn(FALSE);
    	file->setOn(FALSE);
    	grant_->setOn(FALSE);
	}
}

void Privilege::slot_database()
{
	QList<QString> value;
	value = ((MainWindow *)qApp->mainWidget())->database->get_value();

	database->slot_value(value);

	slot_table();

	return;
}

void Privilege::slot_table()
{
	database->data = database->currentText();

	MYSQL_RES *result;
	MYSQL_ROW row;

	QString database;

	table->clear();
	table->insertItem("*");

	database = this->database->currentText();

	if(database[0] == '*')
		return;

	if(mysql_select_db(mysql, database.latin1()))
	{
		return;
	}

	result = mysql_list_tables(mysql, NULL);
	
	if(result == NULL)
	{
		return;
	}

	while((row = mysql_fetch_row(result)))
	{
		table->insertItem(row[0]);
	}

	mysql_free_result(result);
}

void Privilege::slot_host()
{
	QString sql;

	MYSQL_RES *result;
	MYSQL_ROW row;

	sql += "select distinct host from user";

	host->clear();

	if(mysql_select_db(mysql, "mysql"))
		return;

	if(SQL::sql_query(sql.latin1()))
		return;
	
	result = mysql_store_result(mysql);

	if(result == NULL)
		return;

	while((row = mysql_fetch_row(result)))
		host->insertItem(row[0]);

	mysql_free_result(result);
}

void Privilege::slot_user()
{
	QString sql;
	QString host;

	MYSQL_RES *result;
	MYSQL_ROW row;
	
	host = this->host->currentText();

	sql += "select user from user where host = '";
	sql += host;
	sql += "'";

	user->clear();

	if(mysql_select_db(mysql, "mysql"))
		return;

	if(SQL::sql_query(sql.latin1()))
		return;
	
	result = mysql_store_result(mysql);

	if(result == NULL)
		return;

	while((row = mysql_fetch_row(result)))
		user->insertItem(row[0]);
	
	mysql_free_result(result);
}
