#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qlistview.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "table.h"

void MainWindow::slot_table()
{
	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);

	s->setFixedSize(538, 383 + 25);
	
	Table *table = new Table(&mysql, s);

	connect(table, SIGNAL(signal_schema()), this, SLOT(slot_schema()));
	
    s->setCentralWidget(table);
			 
    s->setCaption(tr("Table"));

	QPopupMenu *z = new QPopupMenu();
	z->insertItem(tr("&Fire"), table, SLOT(slot_fire()), Key_F5);
	z->insertSeparator();	
	z->insertItem(tr("Cl&ose"), table, SLOT(slot_close()));
	s->menuBar()->insertItem(tr("&File"), z);
	
	QPopupMenu *zz = new QPopupMenu();
	
	z = new QPopupMenu();
	z->insertItem(tr("&New"), table, SLOT(slot_field_new()));
	z->insertItem(tr("&Save"), table, SLOT(slot_field_save()));
	z->insertItem(tr("&Drop"), table, SLOT(slot_field_drop()));
	zz->insertItem(tr("&Field"), z);

	z = new QPopupMenu();
	z->insertItem(tr("&New"), table, SLOT(slot_key_new()));
	z->insertItem(tr("&Save"), table, SLOT(slot_key_save()));
	z->insertItem(tr("&Drop"), table, SLOT(slot_key_drop()));
	zz->insertItem(tr("&Key"), z);
	
	zz->insertSeparator();
	
	zz->insertItem(tr("Cl&ear"), table, SLOT(slot_clear()));
	s->menuBar()->insertItem(tr("&Tools"), zz);
	
	//z = new QPopupMenu();
	//z->insertItem(tr("&About..."), table, SLOT(slot_about()), Key_F1);
	//s->menuBar()->insertItem(tr("&Help"), z);

	s->show();
}

void MainWindow::slot_table(const QString &database)
{
	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);

	s->setFixedSize(538, 383 + 25);
	
	Table *table = new Table(&mysql, s);

	table->slot_database(database);

	connect(table, SIGNAL(signal_schema()), this, SLOT(slot_schema()));
	
    s->setCentralWidget(table);
			 
    s->setCaption(tr("Table"));

	QPopupMenu *z = new QPopupMenu();
	z->insertItem(tr("&Fire"), table, SLOT(slot_fire()), Key_F5);
	z->insertSeparator();	
	z->insertItem(tr("Cl&ose"), table, SLOT(slot_close()));
	s->menuBar()->insertItem(tr("&File"), z);
	
	QPopupMenu *zz = new QPopupMenu();
	
	z = new QPopupMenu();
	z->insertItem(tr("&New"), table, SLOT(slot_field_new()));
	z->insertItem(tr("&Save"), table, SLOT(slot_field_save()));
	z->insertItem(tr("&Drop"), table, SLOT(slot_field_drop()));
	zz->insertItem(tr("&Field"), z);

	z = new QPopupMenu();
	z->insertItem(tr("&New"), table, SLOT(slot_key_new()));
	z->insertItem(tr("&Save"), table, SLOT(slot_key_save()));
	z->insertItem(tr("&Drop"), table, SLOT(slot_key_drop()));
	zz->insertItem(tr("&Key"), z);
	
	zz->insertSeparator();
	
	zz->insertItem(tr("Cl&ear"), table, SLOT(slot_clear()));
	s->menuBar()->insertItem(tr("&Tools"), zz);
	
	//z = new QPopupMenu();
	//z->insertItem(tr("&About..."), table, SLOT(slot_about()), Key_F1);
	//s->menuBar()->insertItem(tr("&Help"), z);

	s->show();
}
