/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

    common.h  -  Functions for cross-platform compat and general utility.

 the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#if !defined(__COMMON_H_INCLUDED__)
#define __COMMON_H_INCLUDED__

#include "xsleep.h"

// general use functions
time_t xtime(); // mutex-protected time()
DWORD GenID();  // generates object ID

// get-host-by-name replacement
hostent *GetHostByName(const char *name);

// file manipulation
bool CreateDirectory(const CString&);
bool MoveFile(const CString&, const CString&);
bool DeleteFile(const CString& path);
CString ExpandPath(CString path);
bool FileExists(const CString& path);

// auto-search
CString MakeSearchOfFilename(const CString& Name);

// parser
CString find_header(CString Name, const CString& sHahdshake, const CString& sLowHahdshake, LPCSTR szDefault = NULL);
CString restore_string(CString s, bool bFormMode = true);

// query matching
bool QueryMatch(CString Result, const CString& Query);
// fast functions which do not copy the string
void MakeWordList(LPSTR szQuery, vector<char*>& QWords);
void MakeWordList(LPSTR szQuery, vector<char*>& QWords, vector<char*>& QWords);
bool MatchWordList(const CString& ResultLower, const vector<char*>& QWords, bool bMatchAll = true);

// slower but 'storage-independent' versions
void MakeWordList(LPSTR szQuery, set<CString>& QWords);
bool MatchWordList(const CString& ResultLower, const set<CString>& QWords, bool bMatchAll = true);

#endif //__COMMON_H_INCLUDED__

