#ifndef LDAP_PLUGIN_H
#define LDAP_PLUGIN_H

#include <string.h>
#include <multisync.h>
#include <ldap.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <vobject.h>
#include <vcc.h>

typedef struct lutil_sasl_defaults_s {
        char *mech;
        char *realm;
        char *authcid;
        char *passwd;
        char *authzid;
        char **resps;
        int nresps;
} lutilSASLdefaults;

typedef struct {
	client_connection commondata;
	sync_pair *handle;
	connection_type type;
	int debug_level;
	int scope;
	char statefile[1024];
	char dbfile[1024];
	char *servername;
	int serverport;
	char *binddn;
	char *pwd;
	char *searchbase;
	char *filter;
	char *authmech;
	int ldap_version;
	int encryption;
	int evolution_support;
	int write;
	int anonymous;
	LDAP *ld;
} ldap_connection;

struct data_entry {
	char *modifyTimestamp;
	char *uid;
	int change_type;
	LDAPMod **ldapdata;
};

extern gboolean multisync_debug;
GList *load_ldap_entries(ldap_connection *);
GList *load_xml_entries(ldap_connection *);
LDAPMod **vcard2ldap(ldap_connection*, char *);
GString *ldap2vcard(ldap_connection *, LDAPMod **);
struct data_entry *ldap_get_entry(ldap_connection *, char *);
char *quoted_encode(char *);
char *quoted_decode(char *);
void on_chk_anonymous_toggled (GtkToggleButton *, gpointer);

#endif
