/*
 * configuration.c
 *
 * $Revision: 1.10 $
 *
 * Load and save configuration
 *
 * Last Modified:
 *  $Author: ahodgen $
 *  $Date: 2003/02/22 16:59:56 $
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include "configuration.h"
#include "interface.h"
#include "callbacks.h"
#include "mibtree.h"

#define CONFIG_FILE 	"/.mbrowse"
#define CREAT_ERR	"Error creating "/**/CONFIG_FILE
#define BLANK		""

static int exp_cir = GTK_CTREE_EXPANDER_CIRCULAR;
static int exp_tri = GTK_CTREE_EXPANDER_TRIANGLE;
static int exp_non = GTK_CTREE_EXPANDER_NONE;
static int exp_squ = GTK_CTREE_EXPANDER_SQUARE;

#define MAX_EXPANDER  	(GTK_CTREE_EXPANDER_CIRCULAR | \
			GTK_CTREE_EXPANDER_TRIANGLE | \
			GTK_CTREE_EXPANDER_NONE | \
			GTK_CTREE_EXPANDER_SQUARE)+1

#define MAX_LINE	(GTK_CTREE_LINES_NONE | \
			GTK_CTREE_LINES_SOLID | \
			GTK_CTREE_LINES_DOTTED | \
			GTK_CTREE_LINES_TABBED)+1

#define MAX_SNMP_VER	(SNMP_VERSION_1 | SNMP_VERSION_2c)+1

extern GdkPixmap *table_xpm;   
extern GdkBitmap *table_mask;
extern GdkPixmap *child_xpm; 
extern GdkBitmap *child_mask;
extern GdkPixmap *end_xpm;   
extern GdkBitmap *end_mask;  

static GtkWidget *expanders[MAX_EXPANDER];
static GtkWidget *lines[MAX_LINE];
static GtkWidget *snmp_ver[MAX_SNMP_VER];
static GtkWidget *test_ctree;
static GtkWidget *snmp_port_entry;
static GtkWidget *save_sess_button;
static GtkWidget *snmp_to_spin;
static GtkWidget *snmp_retry_spin;

union types {
  char *string;
  int integer;
};

typedef struct {
  char *option;
  int type;
  union types default_value;
  void *variable;
} config_opt_t;
 
static config_t config;

#define STRING 	0
#define INTEGER	1

config_opt_t config_opts[] = {
  { "oid",          STRING, {""},       &config.oid },
  { "readcomm",     STRING, {"public"}, &config.readcomm },
  { "writecomm",    STRING, {"private"},&config.writecomm },
  { "host",         STRING, {""},       &config.host },
  { "inst",         STRING, {""},       &config.inst },
  { "value",        STRING, {""},       &config.value },
  { "save_sess",    INTEGER,{integer:TRUE},&config.save_sess },
  { "snmp_ver",     INTEGER,{integer:SNMP_VERSION_1},&config.snmp_ver },
  { "snmp_timeout", INTEGER,{integer:2},&config.snmp_timeout },
  { "snmp_reties",  INTEGER,{integer:1},&config.snmp_retries },
  { "snmp_port",    INTEGER,{integer:161},&config.snmp_port },
  { "tree_expander",INTEGER,{integer:GTK_CTREE_EXPANDER_SQUARE},&config.tree_expander },
  { "tree_line",    INTEGER,{integer:GTK_CTREE_LINES_SOLID},&config.tree_line },
  { NULL,           INTEGER, {integer:0},NULL },
};

void set_expand_style(GtkWidget *widget,gpointer data);
void set_line_style(GtkWidget *widget,gpointer data);

config_t *get_config() {

  return(&config);
}

void set_defaults(void) {

  config_opt_t *c;

  for(c=config_opts;c->option;c++) {
    switch(c->type) {
      case STRING:
        *((char **)c->variable) = c->default_value.string;
        break;
      case INTEGER:
        *((int *)c->variable) = c->default_value.integer;
        break;
      default:
        fprintf(stderr,"I should have never gotten here. Bad config type.\n");
        break;
    }
  }
};

void apply_config(void) {

  char port[10];
  /* Set entries in the options tab */


  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(expanders[config.tree_expander]),TRUE);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lines[config.tree_line]),TRUE);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(save_sess_button),config.save_sess);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snmp_ver[config.snmp_ver]),TRUE);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(snmp_to_spin),(gfloat) config.snmp_timeout);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(snmp_retry_spin),(gfloat)config.snmp_retries);
  snprintf(port,6,"%u",config.snmp_port);
  gtk_entry_set_text(GTK_ENTRY(snmp_port_entry),port);

  /* Set entries in the main window */

  set_readcomm(config.readcomm);
  set_writecomm(config.writecomm);
  set_oid(config.oid);
  set_hostname(config.host);
  set_instance(config.inst);
  set_value(config.value);
}

void load_config(void) {

# define KEY 0
# define VAL 1

  char line[1023];
  char *tok;
  FILE *fp;
  config_opt_t *c;
  int state;
  int lineno = 0;

  strncpy(line,getenv("HOME"),1023);
  strncat(line,CONFIG_FILE,(1023-strlen(line)));
  set_defaults();
  if((fp = fopen(line,"r")) == NULL) {
    if((fp = fopen(line,"w")) == NULL) {
      perror(CREAT_ERR);
      apply_config();
      return;
    }
  } else {
    while(fgets(line,1023,fp)) {
      lineno++;
      state = KEY; 
      tok = strtok(line,"\n\r\t ");
      if(tok == NULL || *tok == 0x00 || *tok == '#')
        continue;
      for(c=config_opts;c->option;c++) {
        if(strncmp(tok,c->option,strlen(c->option)) == 0) {
          state=VAL;
          break;
        }
      }
      if(state == KEY) {
        fprintf(stderr,"Bad token at line %d in %s. Ignoring\n",lineno,CONFIG_FILE);
        continue;
      }
      tok = strtok(NULL,"\n\r\t ");
      if(tok == NULL || *tok == 0x00 || *tok == '#') {
        switch(c->type) {
          case STRING:
            *((char **)c->variable) = BLANK;
            break;
          case INTEGER:
           *((int *)c->variable) = 0;
            break;
          default:
            fprintf(stderr,"I should have never gotten here. Bad config type.\n");
            break;
        }
        continue;
      }
      switch(c->type) {
        case STRING:
          *((char **)c->variable) = strdup(tok);
          break;
        case INTEGER:
          *((int *)c->variable) = atoi(tok);
          break;
        default:
          fprintf(stderr,"I should have never gotten here. Bad config type.\n");
          break;
      }
    }
  }
  fclose(fp);
  apply_config();
}

void save_config(void) {

  FILE *fp;
  config_opt_t *c;
  char file[1024];

  /* Get some value that aren't set dynamically */

  config.readcomm = get_readcomm();
  config.writecomm = get_writecomm();
  config.host = get_hostname();
  config.inst = get_instance();
  config.value = get_value();

  if(config.save_sess == FALSE)
    return;
  strncpy(file,getenv("HOME"),1023);
  strncat(file,CONFIG_FILE,(1023-strlen(file)));
  if((fp = fopen(file,"w")) == NULL) {
    perror(CREAT_ERR);
    return;
  }
  for(c=config_opts;c->option;c++) {
    switch(c->type) {
      case STRING:
        fprintf(fp,"%s %s\n",c->option,*((char **)c->variable));
        break;
      case INTEGER:
        fprintf(fp,"%s %i\n",c->option,*((int *)c->variable));
        break;
      default:
        fprintf(stderr,"I should have never gotten here. Bad config type.\n");
        break;
    }
  }
  fclose(fp);

  /* Don't want others seeing our community strings */

  chmod(CONFIG_FILE,S_IWUSR | S_IRUSR);
}

void set_expand_style(GtkWidget *widget,gpointer data ) {

  if (widget)
    if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
      return;
  config.tree_expander = *(int *)data;
  gtk_ctree_set_expander_style(GTK_CTREE(test_ctree),(int)data);
  set_mibtree_style(config.tree_expander,config.tree_line);
}

void set_line_style(GtkWidget *widget,gpointer data ) {

  if (widget)
    if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
      return;
  config.tree_line =(int) data;
  gtk_ctree_set_line_style(GTK_CTREE(test_ctree),(int)data);
  set_mibtree_style(config.tree_expander,config.tree_line);
}

void set_snmp_version(GtkWidget *widget,gpointer data) {

  config.snmp_ver = (int) data;
}

void set_timeout(GtkWidget *widget,GtkWidget *data) {

  config.snmp_timeout = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(data));
}

void set_retries(GtkWidget *widget,GtkWidget *data) {

  config.snmp_retries = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(data));
}
void set_port(GtkWidget *widget,GtkWidget *data) {

  config.snmp_port = atoi(gtk_entry_get_text(GTK_ENTRY(data)));
}

void save_sess_toggled(GtkButton *button,gpointer user_data) {

  FILE *fp;
  char file[1024];

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)) == TRUE)
    config.save_sess = TRUE;
  else {
    config.save_sess = FALSE;
    strncpy(file,getenv("HOME"),1023);
    strncat(file,CONFIG_FILE,(1023-strlen(file)));
    if((fp = fopen(file,"w")) == NULL) {
      perror(CREAT_ERR);
      return;
    }
    fprintf(fp,"save_sess 0\n");
    fclose(fp);
  }
}

void create_config_tab(int tab_pos) {

  GtkWidget *option_vbox;
  GtkWidget *general_frame;
  GtkWidget *snmp_config_frame;
  GtkWidget *snmp_config_hbox;
  GtkWidget *snmp_ver_vbox;
  GtkWidget *snmp_ver_label;
  GtkWidget *hbox2;
  GSList *snmp_ver_group = NULL;
  GtkWidget *snmp_to_vbox;
  GtkWidget *timeout_label;
  GtkWidget *snmp_to_hbox;
  GtkObject *snmp_to_spin_adj;
  GtkWidget *secs_label;
  GtkWidget *snmp_retry_vbox;
  GtkWidget *snmp_retry_label;
  GtkObject *snmp_retry_spin_adj;
  GtkWidget *snmp_port_vbox;
  GtkWidget *snmp_port_label;
  GtkWidget *tree_style_frame;
  GtkWidget *tree_style_hbox;
  GtkWidget *expand_vbox;
  GtkWidget *expand_label;
  GSList *expanders_group = NULL;
  GtkWidget *expand_none_butt;
  GtkWidget *expand_square_butt;
  GtkWidget *expand_triangle_butt;
  GtkWidget *expand_circle_butt;
  GtkWidget *line_vbox;
  GtkWidget *line_label;
  GSList *line_group = NULL;
  GtkWidget *line_none_butt;
  GtkWidget *line_solid_butt;
  GtkWidget *line_dotted_butt;
  GtkWidget *line_tabbed_butt;
  GtkWidget *config_tab;
  GtkWidget *hbox1;
  GtkCTreeNode *subtree;
  GtkWidget *notebook;
  gchar *label[1];

  notebook = get_main_widgets()->notebook;
  option_vbox = gtk_vbox_new(FALSE,0);
  gtk_widget_show(option_vbox);
  gtk_container_add(GTK_CONTAINER(notebook),option_vbox);

  hbox1 = gtk_hbox_new(FALSE,0);
  gtk_widget_show(hbox1);
  gtk_box_pack_start(GTK_BOX(option_vbox),hbox1,FALSE,TRUE,0);

  general_frame = gtk_frame_new("General");
  gtk_widget_show(general_frame);
  gtk_box_pack_start(GTK_BOX(hbox1),general_frame,FALSE,TRUE,0);
  gtk_container_set_border_width(GTK_CONTAINER(general_frame),5);

  save_sess_button = gtk_check_button_new_with_label("Save session on exit");
  gtk_widget_show(save_sess_button);
  gtk_container_add(GTK_CONTAINER(general_frame),save_sess_button);
  gtk_signal_connect_after(GTK_OBJECT(save_sess_button),"clicked",
                           GTK_SIGNAL_FUNC(save_sess_toggled),NULL);


  snmp_config_frame = gtk_frame_new("SNMP Configuration");
  gtk_widget_show(snmp_config_frame);
  gtk_box_pack_start(GTK_BOX(hbox1),snmp_config_frame,FALSE,TRUE,0);
  gtk_container_set_border_width(GTK_CONTAINER(snmp_config_frame),5);

  snmp_config_hbox = gtk_hbox_new(FALSE,0);
  gtk_widget_show(snmp_config_hbox);
  gtk_container_add(GTK_CONTAINER(snmp_config_frame),snmp_config_hbox);

  snmp_ver_vbox = gtk_vbox_new(FALSE,0);
  gtk_widget_show(snmp_ver_vbox);
  gtk_box_pack_start(GTK_BOX(snmp_config_hbox),snmp_ver_vbox,FALSE,TRUE,5);

  snmp_ver_label = gtk_label_new("Version");
  gtk_widget_show(snmp_ver_label);
  gtk_box_pack_start(GTK_BOX(snmp_ver_vbox),snmp_ver_label,FALSE,FALSE,0);

  hbox2 = gtk_hbox_new(FALSE,0);
  gtk_widget_show(hbox2);
  gtk_box_pack_start(GTK_BOX(snmp_ver_vbox),hbox2,FALSE,TRUE,0);

  snmp_ver[SNMP_VERSION_1] = gtk_radio_button_new_with_label(snmp_ver_group,"v1");
  snmp_ver_group = gtk_radio_button_group(GTK_RADIO_BUTTON(snmp_ver[SNMP_VERSION_1]));
  gtk_widget_show(snmp_ver[SNMP_VERSION_1]);
  gtk_box_pack_start(GTK_BOX(hbox2),snmp_ver[SNMP_VERSION_1],FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(snmp_ver[SNMP_VERSION_1]),"clicked",GTK_SIGNAL_FUNC(set_snmp_version),(gpointer)SNMP_VERSION_1);

  snmp_ver[SNMP_VERSION_2c] = gtk_radio_button_new_with_label(snmp_ver_group,"v2c");
  snmp_ver_group = gtk_radio_button_group(GTK_RADIO_BUTTON(snmp_ver[SNMP_VERSION_2c]));
  gtk_widget_show(snmp_ver[SNMP_VERSION_2c]);
  gtk_box_pack_start(GTK_BOX(hbox2),snmp_ver[SNMP_VERSION_2c],FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(snmp_ver[SNMP_VERSION_2c]),"clicked",GTK_SIGNAL_FUNC(set_snmp_version),(gpointer)SNMP_VERSION_2c);

  snmp_to_vbox = gtk_vbox_new(FALSE,0);
  gtk_widget_show(snmp_to_vbox);
  gtk_box_pack_start(GTK_BOX(snmp_config_hbox),snmp_to_vbox,FALSE,TRUE,5);

  timeout_label = gtk_label_new("Timeout");
  gtk_widget_show(timeout_label);
  gtk_box_pack_start(GTK_BOX(snmp_to_vbox),timeout_label,FALSE,FALSE,0);

  snmp_to_hbox = gtk_hbox_new(FALSE,0);
  gtk_widget_show(snmp_to_hbox);
  gtk_box_pack_start(GTK_BOX(snmp_to_vbox),snmp_to_hbox,FALSE,FALSE,0);

  snmp_to_spin_adj = gtk_adjustment_new(1,0,100,1,10,10);
  snmp_to_spin = gtk_spin_button_new(GTK_ADJUSTMENT(snmp_to_spin_adj),1,0);
  gtk_widget_show(snmp_to_spin);
  gtk_box_pack_start(GTK_BOX(snmp_to_hbox),snmp_to_spin,TRUE,TRUE,0);
  gtk_signal_connect (GTK_OBJECT(snmp_to_spin_adj),"value_changed",
                      GTK_SIGNAL_FUNC(set_timeout),
                      (gpointer) snmp_to_spin);

  secs_label = gtk_label_new("secs");
  gtk_widget_show(secs_label);
  gtk_box_pack_start(GTK_BOX(snmp_to_hbox),secs_label,FALSE,FALSE,0);

  snmp_retry_vbox = gtk_vbox_new(FALSE,0);
  gtk_widget_show(snmp_retry_vbox);
  gtk_box_pack_start(GTK_BOX(snmp_config_hbox),snmp_retry_vbox,FALSE,TRUE,5);

  snmp_retry_label = gtk_label_new("Retries");
  gtk_widget_show(snmp_retry_label);
  gtk_box_pack_start(GTK_BOX(snmp_retry_vbox),snmp_retry_label,FALSE,FALSE,0);

  snmp_retry_spin_adj = gtk_adjustment_new(1,0,100,1,10,10);
  snmp_retry_spin = gtk_spin_button_new(GTK_ADJUSTMENT(snmp_retry_spin_adj),1,0);
  gtk_widget_show(snmp_retry_spin);
  gtk_box_pack_start(GTK_BOX(snmp_retry_vbox),snmp_retry_spin,FALSE,FALSE,0);
  gtk_signal_connect (GTK_OBJECT(snmp_retry_spin_adj),"value_changed",
                      GTK_SIGNAL_FUNC(set_retries),
                      (gpointer) snmp_retry_spin);

  snmp_port_vbox = gtk_vbox_new(FALSE,0);
  gtk_widget_show(snmp_port_vbox);
  gtk_box_pack_start(GTK_BOX(snmp_config_hbox),snmp_port_vbox,FALSE,TRUE,5);

  snmp_port_label = gtk_label_new("Port");
  gtk_widget_show(snmp_port_label);
  gtk_box_pack_start(GTK_BOX(snmp_port_vbox),snmp_port_label,FALSE,FALSE,0);

  snmp_port_entry = gtk_entry_new_with_max_length(5);
  gtk_widget_show(snmp_port_entry);
  gtk_box_pack_start(GTK_BOX(snmp_port_vbox),snmp_port_entry,FALSE,FALSE,0);
  gtk_widget_set_usize(snmp_port_entry,80,-2);
  gtk_signal_connect_after(GTK_OBJECT(snmp_port_entry),"changed",
      GTK_SIGNAL_FUNC(set_port),snmp_port_entry);


  tree_style_frame = gtk_frame_new("Tree Style");
  gtk_widget_show(tree_style_frame);
  gtk_box_pack_start(GTK_BOX(option_vbox),tree_style_frame,FALSE,TRUE,0);
  gtk_container_set_border_width(GTK_CONTAINER(tree_style_frame),5);

  tree_style_hbox = gtk_hbox_new(FALSE,0);
  gtk_widget_show(tree_style_hbox);
  gtk_container_add(GTK_CONTAINER(tree_style_frame),tree_style_hbox);

  expand_vbox = gtk_vbox_new(FALSE,0);
  gtk_widget_show(expand_vbox);
  gtk_box_pack_start(GTK_BOX(tree_style_hbox),expand_vbox,FALSE,TRUE,0);

  expand_label = gtk_label_new("Expanders");
  gtk_widget_show(expand_label);
  gtk_box_pack_start(GTK_BOX(expand_vbox),expand_label,FALSE,FALSE,0);

  expand_none_butt = gtk_radio_button_new_with_label(expanders_group,"None");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(expand_none_butt),TRUE);
  expanders[GTK_CTREE_EXPANDER_NONE] = expand_none_butt;
  expanders_group = gtk_radio_button_group(GTK_RADIO_BUTTON(expand_none_butt));
  gtk_widget_show(expand_none_butt);
  gtk_box_pack_start(GTK_BOX(expand_vbox),expand_none_butt,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(expand_none_butt),"clicked",GTK_SIGNAL_FUNC(set_expand_style),&exp_non);

  expand_square_butt = gtk_radio_button_new_with_label(expanders_group,"Square");
  expanders[GTK_CTREE_EXPANDER_SQUARE] = expand_square_butt;
  expanders_group = gtk_radio_button_group(GTK_RADIO_BUTTON(expand_square_butt));
  gtk_widget_show(expand_square_butt);
  gtk_box_pack_start(GTK_BOX(expand_vbox),expand_square_butt,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(expand_square_butt),"clicked",GTK_SIGNAL_FUNC(set_expand_style),&exp_squ);

  expand_triangle_butt = gtk_radio_button_new_with_label(expanders_group,"Triangle");
  expanders[GTK_CTREE_EXPANDER_TRIANGLE] = expand_triangle_butt;
  expanders_group = gtk_radio_button_group(GTK_RADIO_BUTTON(expand_triangle_butt));
  gtk_widget_show(expand_triangle_butt);
  gtk_box_pack_start(GTK_BOX(expand_vbox),expand_triangle_butt,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(expand_triangle_butt),"clicked",GTK_SIGNAL_FUNC(set_expand_style),&exp_tri);

  expand_circle_butt = gtk_radio_button_new_with_label(expanders_group,"Circle");
  expanders[GTK_CTREE_EXPANDER_CIRCULAR] = expand_circle_butt;
  expanders_group = gtk_radio_button_group(GTK_RADIO_BUTTON(expand_circle_butt));
  gtk_widget_show(expand_circle_butt);
  gtk_box_pack_start(GTK_BOX(expand_vbox),expand_circle_butt,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(expand_circle_butt),"clicked",GTK_SIGNAL_FUNC(set_expand_style),&exp_cir);

  line_vbox = gtk_vbox_new(FALSE,0);
  gtk_widget_show(line_vbox);
  gtk_box_pack_start(GTK_BOX(tree_style_hbox),line_vbox,FALSE,FALSE,0);

  line_label = gtk_label_new("Line");
  gtk_widget_show(line_label);
  gtk_box_pack_start(GTK_BOX(line_vbox),line_label,FALSE,FALSE,0);

  line_none_butt = gtk_radio_button_new_with_label(line_group,"None");
  lines[GTK_CTREE_LINES_NONE] = line_none_butt;
  line_group = gtk_radio_button_group(GTK_RADIO_BUTTON(line_none_butt));
  gtk_widget_show(line_none_butt);
  gtk_box_pack_start(GTK_BOX(line_vbox),line_none_butt,FALSE,FALSE,0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(line_none_butt),TRUE);
  gtk_signal_connect(GTK_OBJECT(line_none_butt),"clicked",GTK_SIGNAL_FUNC(set_line_style),(gpointer)GTK_CTREE_LINES_NONE);

  line_solid_butt = gtk_radio_button_new_with_label(line_group,"Solid");
  lines[GTK_CTREE_LINES_SOLID] = line_solid_butt;
  line_group = gtk_radio_button_group(GTK_RADIO_BUTTON(line_solid_butt));
  gtk_widget_show(line_solid_butt);
  gtk_box_pack_start(GTK_BOX(line_vbox),line_solid_butt,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(line_solid_butt),"clicked",GTK_SIGNAL_FUNC(set_line_style),(gpointer)GTK_CTREE_LINES_SOLID);

  line_dotted_butt = gtk_radio_button_new_with_label(line_group,"Dotted");
  lines[GTK_CTREE_LINES_DOTTED] = line_dotted_butt;
  line_group = gtk_radio_button_group(GTK_RADIO_BUTTON(line_dotted_butt));
  gtk_widget_show(line_dotted_butt);
  gtk_box_pack_start(GTK_BOX(line_vbox),line_dotted_butt,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(line_dotted_butt),"clicked",GTK_SIGNAL_FUNC(set_line_style),(gpointer)GTK_CTREE_LINES_DOTTED);

  line_tabbed_butt = gtk_radio_button_new_with_label(line_group,"Tabbed");
  lines[GTK_CTREE_LINES_TABBED] = line_tabbed_butt;
  line_group = gtk_radio_button_group(GTK_RADIO_BUTTON(line_tabbed_butt));
  gtk_widget_show(line_tabbed_butt);
  gtk_box_pack_start(GTK_BOX(line_vbox),line_tabbed_butt,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(line_tabbed_butt),"clicked",GTK_SIGNAL_FUNC(set_line_style),(gpointer)GTK_CTREE_LINES_TABBED);

  test_ctree = gtk_ctree_new(1,0);
  gtk_widget_show(test_ctree);
  gtk_box_pack_start(GTK_BOX(tree_style_hbox),test_ctree,TRUE,TRUE,0);
  gtk_clist_column_titles_hide(GTK_CLIST(test_ctree));

  label[0] = "Parent";
  subtree = gtk_ctree_insert_node(GTK_CTREE(test_ctree),NULL,NULL,
				label,5,child_xpm,child_mask,child_xpm,child_mask,
                                FALSE,TRUE);
  label[0] = "Child";
  subtree = gtk_ctree_insert_node(GTK_CTREE(test_ctree),GTK_CTREE_NODE(subtree),NULL,
				label,5,child_xpm,child_mask,child_xpm,child_mask,
				FALSE,TRUE);
  label[0] = "Leaf";
  subtree = gtk_ctree_insert_node(GTK_CTREE(test_ctree),GTK_CTREE_NODE(subtree),NULL,
				label,5,end_xpm,end_mask,end_xpm,end_mask,
				TRUE,TRUE);
  gtk_clist_set_column_width (GTK_CLIST(test_ctree),0,10);

  config_tab = gtk_label_new("Options");
  gtk_widget_show(config_tab);
  gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook),gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),tab_pos),config_tab);
}
