/*!***************************************************************************

  module      : IspcCGenInspecCode.h

  -------------------------------------------------------------------------

  responsible : FerdiF

  special area: IDL to Code Generator   
  description : Generate Inspection Code out of generated XML file
				
  
  last changed: 2000-03-08  11:22
  see also    : 

  -------------------------------------------------------------------------

  copyright:    Copyright by SAP AG, 2000



    ========== licence begin LGPL
    Copyright (C) 2000 SAP AG

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ========== licence end

*****************************************************************************/

#ifndef ISPCCGENINSPECCODE_H
#define ISPCCGENINSPECCODE_H

//#include "gsp00.h"
#if defined(_WIN32)  && (_MSC_VER >= 1300)
#include <fstream>
#define ofstream    std::ofstream
#else
#include <fstream.h>
#endif

#include <string.h>

#ifndef ISPCIDL2CODE_H
#include "idl/xml2ispc/IspcIdl2Code.h"
#endif

//#include "gco00.h"
#include "idl/xml2ispc/Ispc_ggg250.h"
#include "idl/xml2ispc/Ispc_ggg251.h"

/*----------------------------------------------------------------------*/

typedef struct _GUID {          // size is 16
    unsigned int    Data1;
    unsigned short  Data2;
    unsigned short  Data3;
    unsigned char   Data4[8];
} GUID;

/*----------------------------------------------------------------------*/

struct IspcCExprElem {
  XmlElementType_Enum_ispc  m_token_type;
  char *                    m_token_value;
  IspcCExprElem();
  ~IspcCExprElem();
  const IspcCExprElem & operator= (const IspcCExprElem& right);
};

/*----------------------------------------------------------------------*/

class IspcCTypedef;

class IspcCGenInspecCode {
  char                m_filename[256];
  char                m_name[64];
  ofstream            m_cpp_out;
  ofstream            m_h_out;
  IspcCTypedef*       m_act_pType;          /* type description in work */
  bool                m_expr_flag;          /* an <expr> is expected    */
  IspcCExprElem       m_expr_token;         /* expr token in work       */
  char *              m_gen_tab_handle; /* PTS 1131325, PG */
  bool                m_features_76;    /* PTS 1131325, PG */
  cgg250AvlTree<IspcCTypedef*, IspcCTypedef,IspcCGenInspecCode> m_index;
  short getTypeDimension(const char*);
  int getTypeCharacteristics( const char* type, const char* usedby, const char* username, 
    short &server_size, short &server_align, short &asc_client_size,
    short &asc_client_align, short &uni_client_size, short &uni_client_align);
  void printGuidV1( ofstream& out, IspcCTypedef& type );
  bool checkFirstParam(const char *pname, const char *puuid, const char *ptype, const char *pdirection);
public:
  IspcCGenInspecCode();
  ~IspcCGenInspecCode();
  int Init( char * cFilename, bool features_76 ); /* PTS 1131325, PG */
  void startElement(int &error, DboType_Enum_ispc &dboType, const char *name, const char **atts);
  void endElement(int &error, const char *name);
  void charData(int &error, const char *s, int len);
  inline void*  allocate(size_t sz);
  inline void   deallocate(void* p);
  IspcCTypedef* const * findNode( IspcCTypedef &findNode );
  short checkBasisType(const char* type);
  void genABAPTabHandle( int &error, char * structName ); /* PTS 1131325, PG */
};

/*----------------------------------------------------------------------*/

inline void*  IspcCGenInspecCode::allocate(size_t sz) {
  return new char [sz];
  
};

/*----------------------------------------------------------------------*/

inline void   IspcCGenInspecCode::deallocate(void* p) {
  /* delete p           PTS 1109175 */
  delete [] (char*)p; /*PTS 1109175 */
};


/*----------------------------------------------------------------------*/


class IspcCTypedef {
  cgg251DCList<IspcCTypedef*,IspcCGenInspecCode> m_member_list;
  cgg251DCList<IspcCExprElem*,IspcCGenInspecCode> m_expr_list;
  GUID                m_uuid;
  XmlElementType_Enum_ispc   m_def_type;
  char*               m_name;
  char*               m_type;
  XmlAttributeType_Enum_ispc m_value_type;
  char*               m_value_string;
  unsigned char       m_ptr;
  short               m_server_size;        /* C++ type size on server side */
  short               m_asc_client_size;    /* ASCII client type size       */
  short               m_uni_client_size;    /* Unicode client type size     */
  short               m_dimension;
  short               m_server_align;       /* C++ type alignment on server side */
  short               m_asc_client_align;   /* ASCII client type alignment       */
  short               m_uni_client_align;   /* Unicode client type alignment     */
  short               m_member_num;
  short               m_vt_type;
public:
  IspcCTypedef();
  ~IspcCTypedef();
  inline int          Compare(const IspcCTypedef*, const IspcCTypedef*);
  void  appendMember(IspcCTypedef* m);
  void  appendToken(IspcCExprElem* s);
  short getMemberNum(IspcCGenInspecCode &CGenInsepcCode);
  int   calExprValue(IspcCGenInspecCode &CGenInsepcCode);
  void  setDimension(short d);
  void  setName(const XmlElementType_Enum_ispc dt, const char* n);
  void  setType(IspcCGenInspecCode &CGenInsepcCode, const char* t, 
      short server_size, short server_align, short asc_client_size,
      short asc_client_align, short uni_client_size, short uni_client_align);
  void  setValue(const XmlAttributeType_Enum_ispc vt, const char* vs);
  void  setUuid(const char* uuid);
  void  setStructCharacteristics(IspcCGenInspecCode &CGenInsepcCode);
  void  printSubParameter(IspcCGenInspecCode &CGenInsepcCode, ofstream &fout, 
    short &posServer, short &posAscClient, short &posUniClient);
  void  checkIfAbapOrStreamHandle(IspcCGenInspecCode &CGenInsepcCode, short *prm_type, 
    short *prm_size, short *prm_elem_num, IspcCTypedef * const ** row_def );
  inline short getServerAlign() const;
  inline short getAscClientAlign() const;
  inline short getUniClientAlign() const;
  inline short getDimension() const;
  inline cgg251DCList<IspcCTypedef*,IspcCGenInspecCode> getMemberList() const;
  inline short getMemberNum() const;
  inline XmlElementType_Enum_ispc getDefType() const;
  inline XmlAttributeType_Enum_ispc getValType() const;
  inline short getServerSize() const;
  inline short getAscClientSize() const;
  inline short getUniClientSize() const;
  inline short getVtType() const;
  inline const char* getType() const;
  inline const GUID* const getUuid() const;
  inline const char* const getValue() const;
  inline const char* const getName() const;
  inline unsigned char getPtr() const;
  inline void*  allocate(size_t sz);
  inline void   deallocate(void* p);
};

/*----------------------------------------------------------------------*/

inline short IspcCTypedef::getServerAlign() const {
  return m_server_align;
}

/*----------------------------------------------------------------------*/

inline short IspcCTypedef::getAscClientAlign() const {
  return m_asc_client_align;
}

/*----------------------------------------------------------------------*/

inline short IspcCTypedef::getUniClientAlign() const {
  return m_uni_client_align;
}

/*----------------------------------------------------------------------*/

inline short IspcCTypedef::getDimension() const {
  return m_dimension;
}

/*----------------------------------------------------------------------*/

inline XmlElementType_Enum_ispc IspcCTypedef::getDefType() const {
  return m_def_type;
};

/*----------------------------------------------------------------------*/

inline XmlAttributeType_Enum_ispc IspcCTypedef::getValType() const {
  return m_value_type;
};

/*----------------------------------------------------------------------*/

inline cgg251DCList<IspcCTypedef*,IspcCGenInspecCode> IspcCTypedef::getMemberList() const {
  return m_member_list;
};

/*----------------------------------------------------------------------*/

inline short IspcCTypedef::getMemberNum() const {
  return m_member_num;
};

/*----------------------------------------------------------------------*/

inline unsigned char IspcCTypedef::getPtr() const {
  return m_ptr;
};

/*----------------------------------------------------------------------*/

inline short IspcCTypedef::getServerSize() const {
  return m_server_size;
};

/*----------------------------------------------------------------------*/

inline short IspcCTypedef::getAscClientSize() const {
  return m_asc_client_size;
};

/*----------------------------------------------------------------------*/

inline short IspcCTypedef::getUniClientSize() const {
  return m_uni_client_size;
};

/*----------------------------------------------------------------------*/

inline const char * IspcCTypedef::getType() const {
  return m_type;
}

/*----------------------------------------------------------------------*/

inline short IspcCTypedef::getVtType() const {
  return m_vt_type;
}

/*----------------------------------------------------------------------*/

inline const GUID* const IspcCTypedef::getUuid() const {
  return &m_uuid;
};

/*----------------------------------------------------------------------*/

inline const char* const IspcCTypedef::getValue() const {
  return m_value_string;
};

/*----------------------------------------------------------------------*/

inline const char* const IspcCTypedef::getName() const {
  return m_name;
};

/*----------------------------------------------------------------------*/

inline int IspcCTypedef::Compare(const IspcCTypedef* l, const IspcCTypedef* r) {
  if ( strcmp(l->m_name, r->m_name) > 0 ) 
    return 1;
  else if ( strcmp(l->m_name, r->m_name) < 0 )
    return -1;
  return 0;
}

/*----------------------------------------------------------------------*/


#endif

