.TH PASCAL 1
.SH NAME
pascal - Pascal compiler
.SH ORIGIN
OSx
.SH SYNOPSIS
pascal [ option ] name ...
.SH DESCRIPTION
\fIPascal\fR is a Pascal compiler.  If given an argument file ending
with \&.p, it will compile the file and load it into an executable file 
called, by default, \fIa\&.out\fR.
.PP
A program may be separated into more than one \&.p file.
\fIPascal\fR will compile a number of argument \&.p files into object
files (with the extension .o in place of \&.p).  
Argument files ending in \&.P will be processed by the C preprocessor
before being compiled to object files.
Object files may
then be loaded into an executable \fIa\&.out\fR file.  Exactly one
object file must supply a program statement to successfully
create an executable \fIa\&.out\fR file.  The rest of the files must
consist only of declarations which logically nest within the
program.
.PP
Object files created by other language processors may be
loaded together with object files created by \fIpascal\fR.  The functions
and procedures they define must have been declared in
\&.h files included by all the \&.p files which call those routines.
Calling conventions are as in C, with var parameters passed by address.
.PP
The following options have the same meaning as in
.IR cc (1)
and
.IR f77 (1).
See
.IR ld (1)
for load-time options.
.PP
.TP 12
.B \-c    
Suppress loading and produce `\&.o' file(s) from source file(s).
.br
.TP
.B \-g
Have the compiler produce additional symbol table information for
.IR sdb (1).
.br
.TP
.BR \-O[G,P,E]    
Invoke an object-code optimizer.  The
.B \-OG
option performs global optimizations only.
The
.B \-OP
option performs peephole optimizations only.
.B \-OE
option performs register optimizations only.
The
.B \-O
option defaults to
.B \-OGPE
unless the environment variable PASOPTIM
is set to
.BR G ,
or
.BR P ,
or
.BR E ,
in which case it defaults to
.BR \-OG 
,
.BR \-OP 
resp.
.BR \-OE .
If PASOPTIM
is not set or is set to the empty string,
.B \-O
will default to
.BR \-OGPE .
The global optimizer significantly increases
compile time and, under normal circumstances,
should only be invoked when development of the program
is complete.
The global optimizer attempts to detect
all uses of and assignments to a program's variables.
Programs that communicate via shared memory or
invoke signal handlers that modify variables
accessed elsewhere in the program are candidates
for incorrect optimization.
The global optimizer should be used on any program
where execution speed is important.
If problems occur that do not occur in the non-optimized
version, contact Nixdorf for assistance.
.br
.TP
.B \-p
Prepare object files for profiling, see
.IR prof (1).
.br
.TP
.B \-S
Compile the named program, and leave the assembler-language output 
on the corresponding file suffixed `\&.s'.  (No `\&.o' is created.).
.br
.TP
.BI \-o " output"
Name the final output file \fIoutput\fR instead of \fIa\&.out\fR.
.br
.TP
.B \-v
Print global optimization statistics.
.TP
.BI \-D name=def
.TP
.BI \-D name
Define the
.I name
to the C preprocessor, as if by `define'.
If no definition is given,
the name is defined as "1". (`\&.P' suffix files only.)
.TP
.BI \-I dir
`#include' files whose names do not begin with `/'
are always sought first in the directory of the
.I file
argument, then in directories named in
.B \-I
options,
then in directories on a standard list.
(`\&.P' suffix files only.)
.PP
The following options are peculiar to \fIpascal\fR:
.TP 12
.B \-C
Compile code to produce runtime checks on array subscripts and
assignments of ordinal types other than integer.
.br
.TP
.B \-d
Cause the compiler to print out any command lines invoked
to execute another utility, such as the loader or assembler.
.br
.TP
.B \-e
Enable '\\' escape character in string constants.
.br
.TP
.B \-l
Make a program listing during translation.
.br
.TP     
.B \-s
Accept standard Pascal source only.
Non-standard constructs will cause error diagnostics.
.br
.TP
.B \-q
Allocate bytes and shorts for subranges and enumerated
types as appropriate.
This approximates Berkeley Pascal's memory allocation on a Vax.
.PP
Other arguments are taken to be loader option arguments,
perhaps libraries of \fIpascal\fR compatible routines.
.SH FILES
.TP 20
file\&.p                   
pascal source files
.br
.TP
/usr/bin/pascal          
control program
.br
.TP
/usr/lib/pcomp           
compiler
.br
.TP
/bin/ld                  
link editor
.br
.TP
/usr/lib/how_pc          
basic usage explanation
.br
.TP
/usr/lib/libpc\&.a         
intrinsic functions and I/O library
.br
.TP
/usr/lib/libm\&.a          
math library
.br
.TP
/lib/libc\&.a              
standard library, see
.IR intro (3).
.SH DOCUMENTATION
.IR "Targon  Pascal" .
.PP
Nixdorf Computer AG
.br
Edition: 01.03.88, Order no. 10268.00.3.93-02
.PP
For a basic explanation, type:
.sp
.in +10
          \fBpascal\fR
.in -10
.SH LIMITATIONS
The keyword packed is recognized but has no effect.
.PP
The
.B \-s
option is not fully implemented.
