#ifndef cpgplot_h
#define cpgplot_h

#ifdef __cplusplus
extern "C" {
#endif

typedef int Logical;

void cpgarro(float x1, float y1, float x2, float y2); //%name pgarro
				//%vectorize
void cpgask(Logical flag);	//%name pgask
int cpgband(int mode, int posn, float xref, float yref, float *x, float *y, char *ch_scalar);
				//%name pgband
				//%modify x, y
				//%output ch_scalar
void cpgaxis(const char *opt, float x1, float y1, float x2, float y2,
	     float v1, float v2, float step, int nsub,
	     float dmajl, float dmajr, float fmin, float disp, float orient);
				//%name pgaxis

void cpgbbuf(void);		//%name pgbbuf
int cpgbeg(int unit, const char *file, int nxsub, int nysub);
				//%name pgbeg
				//%novectorize
void cpgbin(int nbin, const float *x, const float *data, Logical center);
				//%name pgbin
				//%input x(nbin), data(nbin)
void cpgbox(const char *xopt, float xtick, int nxsub, const char *yopt, float ytick, int nysub);
				//%name pgbox
void cpgcirc(float xcent, float ycent, float radius);//%name pgcirc
				//%vectorize
void cpgclos(void);		//%name pgclos
void cpgconb(const float *a, int idim, int jdim, int i1, int i2, int j1, int j2, const float *c, int nc, const float *tr, float blank);
				//%name pgconb
				//%input a(idim, jdim), tr(6)
				//%input c(nc)
void cpgconf(const float *a, int idim, int jdim, int i1, int i2, int j1,
	     int j2, float c1, float c2, const float *tr);
				//%name pgconf
				//%input a(idim, jdim), tr(6)

void cpgconl(const float *a, int idim, int jdim, int i1, int i2, int j1, int j2, float c, const float *tr, const char *label, int intval, int minint);
				//%name pgconl
				//%input a(idim, jdim), tr(6)
void cpgcons(const float *a, int idim, int jdim, int i1, int i2, int j1, int j2, const float *c, int nc, const float *tr);
				//%name pgcons
				//%input a(idim, jdim), c(nc), tr(6)
void cpgcont(const float *a, int idim, int jdim, int i1, int i2, int j1, int j2, const float *c, int nc, const float *tr);
				//%name pgcont
				//%input a(idim, jdim)
				//%input c((nc > 0 ? nc : -nc))
				//%input tr(6)
void cpgctab(const float *l, const float *r, const float *g, const float *b, int nc, float contra, float bright);
				//%name pgctab
				//%input l(nc), r(nc), g(nc), b(nc)
int cpgcurs(float *x, float *y, char *ch_scalar);
				//%name pgcurs
				//%modify x, y
				//%output ch_scalar
void cpgdraw(float x, float y);	//%name pgdraw
				//%vectorize
void cpgebuf(void);		//%name pgebuf
void cpgend(void);		//%name pgend
void cpgenv(float xmin, float xmax, float ymin, float ymax, int just, int axis);
				//%name pgenv
void cpgeras(void);		//%name pgeras
void cpgerr1(int dir, float x, float y, float e, float t);
				//%name pgerr1
				//%vectorize
void cpgerrb(int dir, int n, const float *x, const float *y, const float *e, float t);
				//%name pgerrb
				//%input x(n), y(n), e(n)
				//%vectorize
void cpgerrx(int n, const float *x1, const float *x2, const float *y, float t);
				//%name pgerrx
				//%input x1(n), x2(n), y(n)
				//%vectorize
void cpgerry(int n, const float *x, const float *y1, const float *y2, float t);
				//%name pgerry
				//%input x(n), y1(n), y2(n)
				//%vectorize
void cpgetxt(void);		//%name pgetxt
void cpggray(const float *a, int idim, int jdim, int i1, int i2, int j1, int j2, float fg, float bg, const float *tr);
				//%name pggray
				//%input a(idim,jdim), tr(6)
void cpghi2d(const float *data, int nxv, int nyv, int ix1, int ix2, int iy1, int iy2, const float *x, int ioff, float bias, Logical center, float *ylims);
				//%name pghi2d
				//%input data(nxv, nyv), x(ix2-ix1+1), ylims(ix2-ix1+1)
void cpghist(int n, const float *data, float datmin, float datmax, int nbin, int pgflag);
				//%name pghist
				//%input data(n)
void cpgiden(void);		//%name pgiden
void cpgimag(const float *a, int idim, int jdim, int i1, int i2, int j1, int j2, float a1, float a2, const float *tr);
				//%name pgimag
				//%input a(idim, jdim), tr(6)
void cpglab(const char *xlbl, const char *ylbl, const char *toplbl);
				//%name pglab
void cpglcur(int maxpt, int *npt, float *x, float *y);
				//%name pglcur
				//%modify npt, x(maxpt), y(maxpt)
void cpgldev(void);		//%name pgldev
void cpglen(int units, const char *string, float *xl, float *yl);
				//%name pglen
				//%output xl, yl
void cpgline(int n, const float *xpts, const float *ypts);
				//%name pgline
				//%input xpts(n), ypts(n)
				//%vectorize
void cpgmove(float x, float y);	//%name pgmove
void cpgmtxt(const char *side, float disp, float coord, float fjust, const char *text);
				//%name pgmtxt
				//%vectorize
void cpgncur(int maxpt, int *npt, float *x, float *y, int symbol);
				//%name pgncur
				//%modify npt, x(maxpt), y(maxpt)
void cpgnumb(int mm, int pp, int form, char *string, int *string_length);
				//%name pgnumb
				//%output string, string_length
void cpgolin(int maxpt, int *npt, float *x, float *y, int symbol);
				//%name pgolin
				//%modify npt, x(maxpt), y(maxpt)
int cpgopen(const char *device);//%name pgopen
void cpgpage(void);		//%name pgpage
void cpgpanl(int nxc, int nyc);	//%name pgpanl
void cpgpap(float width, float aspect);	//%name pgpap
void cpgpixl(const int *ia, int idim, int jdim, int i1, int i2, int j1, int j2, float x1, float x2, float y1, float y2);
				//%name pgpixl
				//%input ia(idim, jdim)
				//%vectorize
void cpgpnts(int n, const float *x, const float *y, const int *symbol, int ns);
				//%name pgpnts
				//%input x(n), y(n), symbol(ns)
void cpgpoly(int n, const float *xpts, const float *ypts);
				//%name pgpoly
				//%input xpts(n), ypts(n)
				//%vectorize
void cpgpt1(float xpt, float ypt, int symbol);
				//%name pgpt1
				//%vectorize
void cpgpt(int n, const float *xpts, const float *ypts, int symbol);
				//%name pgpt
				//%input xpts(n), ypts(n)
				//%vectorize
void cpgptxt(float x, float y, float angle, float fjust, const char *text);
				//%name pgptxt
				//%vectorize
void cpgqah(int *fs, float *angle, float *barb);
				//%name pgqah
				//%output fs, angle, barb
void cpgqcf(int *font);		//%name pgqcf
				//%output font
void cpgqch(float *size);	//%name pgqch
				//%output size
void cpgqci(int *ci);		//%name pgqci
				//%output ci
void cpgqcir(int *icilo, int *icihi);//%name pgqcir
				//%output icilo, icihi
void cpgqclp(int *state);	//%name pgqclp
				//%output state
void cpgqcol(int *ci1, int *ci2);//%name pgqcol
				//%output ci1, ci2
void cpgqcr(int ci, float *cr, float *cg, float *cb);//%name pgqcr
				//%output cr, cg, cb
void cpgqcs(int units, float *xch, float *ych);//%name pgqcs
				//%output xch, ych
void cpgqdt(int n, char *type, int *type_length, char *descr, int *descr_length, int *inter);
				//%name pgqdt
				//%output type(8), type_length
				//%output descr(64), descr_length, inter
void cpgqfs(int *fs);		//%name pgqfs
				//%output fs
void cpgqhs(float *angle, float *sepn, float *phase);//%name pgqhs
				//%output angle, sepn, phase
void cpgqid(int *id);		//%name pgqid
				//%output id
void cpgqinf(const char *item, char *value, int *value_length);//%name pgqinf
				//%output value(value_length)
void cpgqitf(int *itf);		//%name pgqitf //%output itf
void cpgqls(int *ls);		//%name pgqls //%output ls
void cpgqlw(int *lw);		//%name pgqlw //%output lw
void cpgqndt(int *n);		//%name pgqndt
				//%output n
void cpgqpos(float *x, float *y); //%name pgqpos //%output x, y
void cpgqtbg(int *tbci);	//%name pgqtbg //%output tbci
void cpgqtxt(float x, float y, float angle, float fjust, const char *text, float *xbox, float *ybox);
				//%name pgqtxt
				//%output xbox(4), ybox(4)
void cpgqvp(int units, float *x1, float *x2, float *y1, float *y2);
				//%name pgqvp
				//%output x1, x2, y1, y2
void cpgqvsz(int units, float *x1, float *x2, float *y1, float *y2);
				//%name pgqvsz
				//%output x1, x2, y1, y2
void cpgqwin(float *x1, float *x2, float *y1, float *y2);
				//%name pgqwin
				//%output x1, x2, y1, y2
void cpgrect(float x1, float x2, float y1, float y2);//%name pgrect
				//%vectorize

float cpgrnd(float x, int *nsub); //%name pgrnd
				//%output nsub
void cpgrnge(float x1, float x2, float *xlo, float *xhi);
				//%name pgrnge
				//%output xlo, xhi
void cpgsah(int fs, float angle, float barb);//%name pgsah
void cpgsave(void);		//%name pgsave
void cpgunsa(void);		//%name pgunsa
void cpgscf(int font);		//%name pgscf
void cpgsch(float size);	//%name pgsch
void cpgsci(int ci);		//%name pgsci
void cpgscir(int icilo, int icihi); //%name pgscir
void cpgsclp(int state);	//%name pgsclp
void cpgscr(int ci, float cr, float cg, float cb); //%name pgscr
void cpgscrl(float dx, float dy); //%name pgscrl
void cpgscrn(int ci, const char *name, int *ier); //%name pgscrn
				//%output ier
void cpgsfs(int fs);		//%name pgsfs
void cpgshls(int ci, float ch, float cl, float cs); //%name pgshls
void cpgshs(float angle, float sepn, float phase); //%name pgshs
void cpgsitf(int itf);		//%name pgsitf
void cpgslct(int id);		//%name pgslct
void cpgsls(int ls);		//%name pgsls
void cpgslw(int lw);		//%name pgslw
void cpgstbg(int tbci);		//%name pgstbg
void cpgsubp(int nxsub, int nysub); //%name pgsubp
void cpgsvp(float xleft, float xright, float ybot, float ytop);	//%name pgsvp
void cpgswin(float x1, float x2, float y1, float y2); //%name pgswin
void cpgtbox(const char *xopt, float xtick, int nxsub, const char *yopt, float ytick, int nysub);
				//%name pgtbox
void cpgtext(float x, float y, const char *text);//%name pgtext
				//%vectorize
void cpgtick(float x1, float y1, float x2, float y2, float v, float tikl, float tikr, float disp, float orient, const char *str);
				//%name pgtick
				//%vectorize
void cpgupdt(void);		//%name pgupdt
void cpgvect(const float *a, const float *b, int idim, int jdim, int i1, int i2, int j1, int j2, float c, int nc, const float *tr, float blank);
				//%name pgvect
				//%input a(idim, jdim), b(idim, jdim), tr(6)
void cpgvsiz(float xleft, float xright, float ybot, float ytop);
				//%name pgvsiz
void cpgvstd(void);		//%name pgvstd
void cpgwedg(const char *side, float disp, float width, float fg, float bg, const char *label);
				//%name pgwedg
void cpgwnad(float x1, float x2, float y1, float y2);//%name pgwnad

#ifdef __cplusplus
}
#endif

#endif
