// -*- c++ -*-
#ifndef INCLUDED_MATH3D_M2D_H
#define INCLUDED_MATH3D_M2D_H
/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: m2d.h,v 1.6 2000/10/09 12:17:54 jeh Exp $
 */

#ifndef INCLUDED_MATH3D_MATHDEF_H
#include <math3d/math3ddef.h>
#endif

namespace Math3d {

  class M3d;
  
/**
 * 2-dimensional vector class.
 */
  class _CCMATH3D M2d {
    protected:
      double d_v[2];
    public:
      M2d() {d_v[0]=d_v[1]=0.0;}
      M2d(double x, double y) {d_v[0]=x; d_v[1]=y;};
      M2d(const M2d& A);
      M2d(const M3d& A);
      const M2d& operator=(const M2d& A);

      void zero();
      void set(double x, double y) {d_v[0]=x; d_v[1]=y;};
      void copy(const M2d& A);

      inline double& operator[](int i);
      operator double*() {return(d_v);}
      double& x() {return(d_v[0]);}
      double& y() {return(d_v[1]);}
      double& get(int i);

      M2d operator+(const M2d& A);
      M2d operator+();
      const M2d& operator+=(const M2d& A);
      M2d operator-(const M2d& A);
      M2d operator-();
      const M2d& operator-=(const M2d& A);
      M2d operator*(double k);
      const M2d& operator*=(double k);
      void neg();
      void abs();
      void add(const M2d& A, const M2d& B);
      void sub(const M2d& A, const M2d& B);
      void scalar(double k);
      void normalize();
      void lerp(const M2d& A, const M2d& B, double t);
      void min(M2d& min) const;
      void max(M2d& max) const;
      void cubic(const M2d& A, const M2d& TA, const M2d& TB, 
        const M2d& B, double t);
      
      inline double operator[](int i) const;
      operator const double*() const {return(d_v);}
      double x() const {return(d_v[0]);}
      double y() const {return(d_v[1]);}
      double get(int i) const;

      double operator*(const M2d& A)  const;  //dot product!
      bool operator==(const M2d& A) const;
      bool operator!=(const M2d& A) const;
      double dot(const M2d& A) const;
      bool cmp(const M2d& A, double epsilon=EPSILON) const;
      double squared() const;
      double length() const;

      friend M3d;
  };

  inline double&
  M2d::operator[](int i)
  {
    ASSERT(i>=0 && i<2);
    return(d_v[i]);
  }
  inline double
  M2d::operator[](int i) const
  {
    ASSERT(i>=0 && i<2);
    return(d_v[i]);
  }
  
  extern _CCMATH3D ostream& operator << (ostream& co, const M2d& v);

}
#endif // INCLUDED_MATH3D_M2D_H
