// Generic utility functions -*- c++ -*-

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "util.h"

#include <string.h>
#include <assert.h>

/** @file util.C
 * Generic utility functions
 */

/* Copyright  1999-2002 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

bool
ltstr::operator() (const char* s1, const char* s2) const
{
  return strcmp (s1, s2) < 0;
}

char*
newString (const char* s)
{
  size_t len = strlen (s) + 1;
  return static_cast<char*>(memcpy (new char[len], s, len));
}

unsigned
log16 (card_t num)
{
  assert (num > 0);
  assert (!(CARD_T_BIT % 4));
  unsigned low = 0, high = CARD_T_BIT / 4;

  for (;;) {
    unsigned log = (low + high) >> 1;
    card_t exp = card_t (1) << (4 * log);
    if (exp < num) {
      assert (high >= log);
      if (low == high) {
	assert (log == low);
	assert (log == CARD_T_BIT / 4);
	return log;
      }
      low = log + 1;
    }
    else if ((exp >> 4) >= num) {
      assert (low < log);
      high = log - 1;
    }
    else
      return log;
  }
}

unsigned
log8 (card_t num)
{
  assert (num > 0);
  assert (!(CARD_T_BIT % 4));
  unsigned low = 0, high = CARD_T_BIT / 3;

  if (num > (card_t (1) << (3 * high)))
    return high + 1;

  for (;;) {
    unsigned log = (low + high) >> 1;
    card_t exp = card_t (1) << (3 * log);
    if (exp < num) {
      assert (high >= log);
      if (low == high) {
	assert (log == low);
	assert (log == CARD_T_BIT / 3);
	return log;
      }
      low = log + 1;
    }
    else if ((exp >> 3) >= num) {
      assert (low < log);
      high = log - 1;
    }
    else
      return log;
  }
}

unsigned
log2 (card_t num)
{
  assert (num > 0);
  unsigned low = 0, high = CARD_T_BIT;

  for (;;) {
    unsigned log = (low + high) >> 1;
    card_t exp = card_t (1) << log;
    if (exp < num) {
      assert (high >= log);
      if (low == high) {
	assert (log == low);
	assert (log == CARD_T_BIT);
	return log;
      }
      low = log + 1;
    }
    else if ((exp >> 1) >= num) {
      assert (low < log);
      high = log - 1;
    }
    else
      return log;
  }
}
