/*
madman - a music manager
Copyright (C) 2003  Andreas Kloeckner <ak@ixion.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/




#ifndef HEADER_SEEN_PREFS_H
#define HEADER_SEEN_PREFS_H




#include <vector>
#include "utility/base.h"
#include "utility/player.h"




class tMainWindow;
class QSettings;




struct tAutoDJScoringRule
{
  QString Comment;
  QString Criterion;

  static const int ScorePlayNever = -10;
  static const int ScoreMinimum = -9;
  static const int ScoreMaximum = 30;
  int ScoreAdjustment;
};

typedef vector<tAutoDJScoringRule> tAutoDJScoringRuleList;

struct tAutoDJPreferences 
{
  tAutoDJScoringRuleList ScoringRuleList;

  void resetToDefault();
};

struct tPreferences
{
  bool RememberGeometry;
  bool ScanAtStartup;
  bool CollectHistory;
  bool EnableSystemTrayIcon;
  bool MinimizeToSystemTray;
  bool EnablePassivePopupSongAnnouncements;

  int BackupCount;

  tPlayerFacade Player;
  tDirectoryList PluginDirectories;

  bool HttpDaemonEnabled;
  int HttpDaemonPort;
  bool HttpDownloadsEnabled;
  bool HttpScriptingEnabled;
  bool HttpWriteScriptingEnabled;
  bool HttpLocalPlayEnabled;
  bool HttpBrowsingEnabled;
  bool HttpRestrictToLocalhost;

  QString TrayTooltipFormat, PassivePopupFormat;

  tAutoDJPreferences AutoDJPreferences;

  void save(QSettings &settings);
  void load(QSettings &settings);

  void setPlayer(tPlayer *newplayer);
};




#endif
