/*
madman - a music manager
Copyright (C) 2003  Andreas Kloeckner <ak@ixion.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/




#ifndef MAINWIN
#define MAINWIN




#include <memory>
#include <qtimer.h>
#include <qlistview.h>
#include <qapplication.h>

#include "designer/mainwin.h"
#include "database/database.h"
#include "httpd/httpd.h"
#include "httpd/madmanweb_external.h"
#include "utility/prefs.h"
#include "ui/prefs_dialog.h"
#include "ui/song_set_view.h"
#include "ui/overview.h"
#include "ui/program_interface.h"




class tPlaylistNodeListViewItem;
class tProgress;
class TrayIcon;




class tMainWindow : public tMainWindowBase, public tProgramInterface
{
    Q_OBJECT;

    auto_ptr<tDatabase> Database;

    tSearchSongSet SearchSongSet;
    tSearchViewManager SearchViewManager;
    tPlaylistViewManager PlaylistEditor;

    auto_ptr<tCriterion> SearchCriterion;
    QSettings		Settings;
    tPreferences	Preferences;

    QString CurrentFilename;
    bool FilenameValid;

    tFilename CurrentSongFilename;
    double AccumulatedPlayTime;
    time_t PlayStartTime;
    bool WasPlaying;
    QTimer UpdateTimer;

    tProgress *CurrentSearchProgress;
    tHttpDaemon *HttpDaemon;
    TrayIcon *SystemTrayIcon;

    tOverviewManager OverviewManager;

  public:
    tMainWindow(const QString &filename_to_open);
    virtual ~tMainWindow();

    void setDatabase(tDatabase *db);

    void closeEvent(QCloseEvent *event);

    void updateWindowCaption();
    void updateAll();

    void realizeSystemTrayIconSettings();
    void realizeHttpdSettings();

    tDatabase &database()
    {
      return *Database;
    }
    tPreferences &preferences()
    {
      return Preferences;
    }
    QSettings &settings()
    {
      return Settings;
    }

    void quitApplication();
    void setStatus(const QString &status);

  public slots:
    void rescan();
    void rescan(tDatabase *db);
    void rereadTags();
  
    void startNewDatabase();
    void fileNew();
    void fileOpen();
    void saveDatabase(const QString &name);
    void fileSave();
    bool fileSaveWithResult();
    void fileSaveAs();
    bool fileSaveAsWithResult();
    void showPreferences(tDatabase *db, int tab);
    void filePreferences();
    
    void helpAbout();
    void help();

    void rateCurrentSong(int rating);
    void rateNone() { rateCurrentSong(-1); }
    void rate0() { rateCurrentSong(0); }
    void rate1() { rateCurrentSong(1); }
    void rate2() { rateCurrentSong(2); }
    void rate3() { rateCurrentSong(3); }
    void rate4() { rateCurrentSong(4); }
    void rate5() { rateCurrentSong(5); }

    void addPlaylist(tPlaylistNode *node, tPlaylistNode *parent);
    void addPlaylist();
    void bookmarkCurrentSearch();
    void importPlaylist();
    void duplicatePlaylist();
    void removePlaylist();
    void editMultilinePlaylistCriterion();
    void slotDropPlaylistNode(const QString &node, tPlaylistNode *onto);
    void renamePlaylist(QListViewItem *item, int col, const QString &text);
    void songSetSelectionChanged();
    void songSetCriterionChanged();
    void noticeSongSetChanged();

    void add(tSongList const &songlist);

    void searchChanged();
    void searchChanged(const QString &text)
    {
      searchChanged();
    }

    void buildOverviewTree();
    void overviewSelectionChanged(QListViewItem *item);

    void highlightCurrentSong();

    void play();
    void pause();
    void stop();
    void skipForward();
    void skipBack();
    void skipTo(int value);
    void skipToWrapper();

    void updatePlayerStatus();
    void songOrStateChanged();

    void trayIconClicked(const QPoint&, int);

  private slots:
    void updatePlaylistTree();

  private:
    void updatePlaylistTree(bool keep_selection, bool keep_scroll);
    tPlaylistNode *nodeFromItem(QListViewItem *item);
    tPlaylistNode *currentNode();
    tPlaylist *currentPlaylist();
    void insertAtPosition(QListViewItem *parent, QListViewItem *item, tIndex pos);

    QListViewItem *createPlaylistNodeItem(tPlaylistNode *node, QListViewItem *parent,
	tPlaylistNode *selected_node, tPlaylistNodeListViewItem *&selected_item);

    void loadSplitterAppearance(QSplitter *splitter, QSettings &settings, QString const &where);
    void saveSplitterAppearance(QSplitter *splitter, QSettings &settings, QString const &where);

    void showEvent(QShowEvent *e);
    void hideEvent(QHideEvent *e);

    void updateTrayIconStatus();
    void updateRatingButtons();

  private slots:
    void noticeSongModified(const tSong *song, tSongField field);
};




#endif
