#ifndef __NJBUSB__H
#define __NJBUSB__H

#include "../config.h"
#ifndef HAVE_LIBUSB
#define DEFAULT_DEV	"/dev/usb0"
#endif

#define NJB1_DEV_CLASS		0xDC
#define NJB1_DEV_SUBCLASS	0x00
#define NJB1_VENDOR_ID		0x0471
#define NJB1_PRODUCT_ID		0x0222

#define NJB2_DEV_CLASS		0xFF
#define NJB2_DEV_SUBCLASS	0xFF
#define NJB2_VENDOR_ID		0x041e
#define NJB2_PRODUCT_ID		0x4100

#define NJB3_DEV_CLASS		0xFF
#define NJB3_DEV_SUBCLASS	0xFF
#define NJB3_VENDOR_ID		0x041e
#define NJB3_PRODUCT_ID		0x4101

#define NJBZEN_DEV_CLASS	0xFF
#define NJBZEN_DEV_SUBCLASS	0xFF
#define NJBZEN_VENDOR_ID	0x041e
#define NJBZEN_PRODUCT_ID	0x4108

#define NJBZEN2_DEV_CLASS	0xFF
#define NJBZEN2_DEV_SUBCLASS	0xFF
#define NJBZEN2_VENDOR_ID	0x041e
#define NJBZEN2_PRODUCT_ID	0x410B

#define NJBZENNX_DEV_CLASS	0xFF
#define NJBZENNX_DEV_SUBCLASS	0xFF
#define NJBZENNX_VENDOR_ID	0x041e
#define NJBZENNX_PRODUCT_ID	0x4109

#define NJBZENXTRA_DEV_CLASS	0xFF
#define NJBZENXTRA_DEV_SUBCLASS	0xFF
#define NJBZENXTRA_VENDOR_ID	0x041e
#define NJBZENXTRA_PRODUCT_ID	0x4110

#define NJBDELLDJ_DEV_CLASS     0xFF
#define NJBDELLDJ_DEV_SUBCLASS  0xFF
#define NJBDELLDJ_VENDOR_ID     0x041e
#define NJBDELLDJ_PRODUCT_ID    0x4111

/*
 * Macros to detect certain features of the device
 * great for code readability.
 */

#define USB20_DEVICE(t) \
        (t == NJB_DEVICE_NJB2 || \
         t == NJB_DEVICE_NJBZEN2 || \
         t == NJB_DEVICE_NJBZENNX || \
         t == NJB_DEVICE_NJBZENXTRA || \
         t == NJB_DEVICE_DELLDJ)

#define PROTOCOL3_DEVICE(t) \
        (t == NJB_DEVICE_NJB2 || \
	 t == NJB_DEVICE_NJB3 || \
         t == NJB_DEVICE_NJBZEN || \
         t == NJB_DEVICE_NJBZEN2 || \
         t == NJB_DEVICE_NJBZENNX || \
         t == NJB_DEVICE_NJBZENXTRA || \
         t == NJB_DEVICE_DELLDJ)

#ifdef HAVE_LIBUSB
#define NJB_BULK_EP	2
#endif

#endif

