package tests::ReferrerCategoriserTest;

use strict;

use base qw/Lire::Test::DlfAnalyserTestCase/;

use Lire::DlfAnalysers::ReferrerCategoriser;
use File::Basename;

sub schemasdir {
    return dirname( __FILE__ ) . "/../..";
}

sub create_analyser {
    return new Lire::DlfAnalysers::ReferrerCategoriser();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../../www-referrer_init";
}

sub test_categorise {
    my $self = $_[0];

    my $analyser = $self->create_analyser();
    my $dlf = { 'referer' => undef };
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'referring_site'} );
    $self->assert_null( $dlf->{'search_engine'} );
    $self->assert_null( $dlf->{'keywords'} );

    $dlf->{'referer'} = 'bookmarks';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'Bookmarks', $dlf->{'referring_site'} );
    $self->assert_null( $dlf->{'search_engine'} );
    $self->assert_null( $dlf->{'keywords'} );

    $dlf->{'referer'} = 'http://www.logreport.org/pub/';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'www.logreport.org', $dlf->{'referring_site'} );
    $self->assert_null( $dlf->{'search_engine'} );
    $self->assert_null( $dlf->{'keywords'} );

    $dlf->{'referer'} = 'http://www.yahoo.com/?p=analyse+des+donn%e9es';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'www.yahoo.com', $dlf->{'referring_site'} );
    $self->assert_str_equals( 'Yahoo!', $dlf->{'search_engine'} );
    $self->assert_str_equals( 'analyse des donnes', $dlf->{'keywords'} );

    $dlf->{'keywords'} = undef;
    $dlf->{'referer'} = 'http://www.google.ca/?q=';
    $analyser->categorise( $dlf );
    $self->assert_str_equals( 'www.google.ca', $dlf->{'referring_site'} );
    $self->assert_str_equals( 'Google', $dlf->{'search_engine'} );
    $self->assert_null(  $dlf->{'keywords'} );

    return;
}

1;
