package Lire::OutputFormats::PDF;

use strict;

use base qw/Lire::OutputFormats::PS/;

use Locale::TextDomain 'lire';

use Lire::Config;
use Lire::Error qw/ missing_command /;
use Lire::Utils qw/ tempdir /;

eval "use MIME::Entity";

=pod

=head1 NAME

Lire::OutputFormat::PDF - PDF output format.

=head1 SYNOPSIS

  my $format = Lire::PluginManager->get_plugin( 'output_format', 'pdf' );
  $format->format_report( $xml_file, $pdf_file, $cfg );

=head1 DESCRIPTION

Format a XML report into PDF with charts.

=cut

sub name {
    return 'pdf';
}

sub title {
    return __( 'PDF' );
}

sub description {
    return '<para>' . __( 'PDF report with charts.' ) . '</para>';
}

sub missing_requirements {
    my @missings = shift->SUPER::missing_requirements();

    push @missings, missing_command( 'ps2pdf' )
      unless Lire::Config->get_var( 'ps2pdf_path' )->is_valid();

    return @missings;
}

sub mime_filename {
    return "report.pdf";
}

sub content_type {
    return 'application/pdf';
}

sub content_type_charset {
    return undef;
}

sub content_transfer_encoding {
    return "base64";
}

1;

__END__

=pod

=head1 SEE ALSO

 Lire::PluginManager(3pm) Lire::OutputFormat(3pm)

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=head1 VERSION

$Id: PDF.pm,v 1.3 2004/08/31 14:28:58 wsourdeau Exp $

=head1 COPYRIGHT

Copyright (C) 2004 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut

