package Lire::OutputFormats::Excel95;

use strict;

use base qw/Lire::OutputFormat/;

use Locale::TextDomain 'lire';

use Lire::Utils qw/tempdir/;

eval "use MIME::Entity;";

eval "use Lire::ReportParser::ExcelWriter;";
our $HAS_EXCEL95 = ! $@;

=pod

=head1 NAME

Lire::OutputFormats::Excel95 - Excel95 output format.

=head1 SYNOPSIS

  my $format = Lire::PluginManager->get_plugin( 'output_format', 'excel95' );
  $format->format_report( $xml_file, $xls_file );

=head1 DESCRIPTION

Format a XML report into Excel95 spreadsheet.

=cut

sub name {
    return 'excel95';
}

sub title {
    return __( 'Excel95 Spreadsheet' );
}

sub description {
    return '<para>' . __( 'Format the report as a Excel95 spreadsheet.' ) . '</para>';
}

sub missing_requirements {
    return $HAS_EXCEL95 ? () : ( __( 'missing CPAN module Spreadsheet::WriteExcel' ) );
}

sub format_report {
    my ( $self, $report_file, $output_file ) = @_;

    my $parser =
      Lire::ReportParser::ExcelWriter->new( 'output_file' => $output_file );
    $parser->parsefile( $report_file );

    return;
}

sub mime_report {
    my ( $self, $report_file, $cfg ) = @_;

    my $tmpdir = tempdir( __PACKAGE__ . '_XXXXXX', 'CLEANUP' => 1 );
    $self->format_report( $report_file, "$tmpdir/report.xls", $cfg );
    return MIME::Entity->build( 'Type' => 'application/vnd.ms-excel',
                                'Encoding' => 'base64',
                                'Path' => "$tmpdir/report.xls"
                              );
}

1;

__END__

=pod

=head1 SEE ALSO

 Lire::PluginManager(3pm) Lire::OutputFormat(3pm)

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=head1 VERSION

$Id: Excel95.pm,v 1.3 2004/08/31 14:29:20 wsourdeau Exp $

=head1 COPYRIGHT

Copyright (C) 2004 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut

