#include <syslog.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include "times.h"
#include "../common.h"
#include "srv_def.h"
#include "global_vars.h"
#include "cmd.h"
#include "con.h"
#include "client.h"
#include "iface.h"
#include "ipvalidator.h"
#include "execute.h"
#include "../lcp3.h"
#include "proc_supp.h"

int fill_server_status(struct server_status_t *sta, struct client_t *who)
{
 struct client_t *clt = (struct client_t*)cltlist.first;
 struct ordq_item_t *oq = (struct ordq_item_t*)ordq.first;
 struct ackq_item_t *aq = (struct ackq_item_t*)ackq.first;
 struct line_t *line = (struct line_t*)lstlines.first;
 memset(sta, 0, sizeof(struct server_status_t));
 check_con_status();
 sta->clients = cltlist.count;
 // sta->online = 0;
 while ( clt != NULL )
 {
     if ( clt->status == CLT_ONLINE ) sta->online++;
     clt = (struct client_t*)clt->next;
 }
 // sta->code = 0;
 while ( oq != NULL ) { sta->ordq_nr++; oq = (struct ordq_item_t*)oq->next; }
 while ( aq != NULL ) { sta->ackq_nr++; aq = (struct ackq_item_t*)aq->next; }
 if ( line )
 {
     sta->channels = line->used_channels;
     sta->con_stat = line->con_stat;
     if ( (line->con_stat == CST_UP_SERVER) ||
          (line->con_stat == CST_UP_USER) )
     {
         sta->srv_con_time = time(NULL) - line->con_up_time;
         if ( who->started != 0 ) sta->clt_con_time = time(NULL) - who->started;
     }
     sta->con_up = line->con_up_time;
 }
 return(0);
}

int send_status(struct client_t *who)
{
 struct server_status_t sta;
 fill_server_status(&sta, who);
 cmd_q(who, CMD_SRV_STAT, (char*)&sta, sizeof(struct server_status_t));
 return(0);
}

int process_order(struct p_order_t *pack, struct sockaddr_in *from, int sock, char type)
{
// pid_t pid;
// int ret_status;
 struct client_t *who;
 void *dum = NULL; // "might be used unitialized.." bla bla bla!
 struct ordq_item_t *oq;
 struct ackq_item_t *aq;
 struct line_t *line = (struct line_t*)lstlines.first;
 if ( !line )
 {
     syslog(LOG_ERR, "Unable to process proto 2 order: no line found!");
     return(-1);
 }
 who = get_client(from->sin_addr.s_addr, from->sin_port);
 // CMD_ACK already handled
 if ( pack->cmd == CMD_ACK ) return(0);
 if ( server->use_user_accounting )
 {
     syslog(LOG_INFO, "%s:%d has no access (clt can't deal with user accounting)", inet_ntoa(from->sin_addr), ntohs(from->sin_port));
     cmd_direct(CMD_REFUSED, sock, from, NULL, 0, type);
     return(0);
 }
 if ( who == NULL )
 {
     if ( pack->cmd != CMD_REG )
     {
         syslog(LOG_WARNING, "%s:%d not registered.", inet_ntoa(from->sin_addr), ntohs(from->sin_port));
         cmd_direct(CMD_NOT_REGGED, sock, from, NULL, 0, type);
         return(1);
     }
     // create a new client - record, type DC
     if ( (who = (struct client_t*)list_add(&cltlist, sizeof(struct client_t))) == NULL )
     {
         syslog(LOG_WARNING, "%s:%d registering error!", inet_ntoa(from->sin_addr), ntohs(from->sin_port));
	 cmd_direct(CMD_REG_ERROR, sock, from, NULL, 0, type);
         return(-1);
     }
     who->ip = from->sin_addr.s_addr;
     who->port = from->sin_port;
     who->status = CLT_OFFLINE;
     who->line = line;
     if ( (pack->interval < LCC_MIN_TIMEOUT) ||
          (pack->interval > LCC_MAX_TIMEOUT) )
	      pack->interval = LCC_DEFAULT_TIMEOUT;
     who->interval = pack->interval;
     who->started = 0;
     who->type = LCS_CLT_DC;
     who->received = 0;
     syslog(LOG_INFO, "%s:%d registered.", inet_ntoa(from->sin_addr), ntohs(from->sin_port));
 }
 else if ( pack->cmd == CMD_REG )
 {	// hey! You CAN'T register again!
        // --> update port-info to allow client access
     /* clean the ordq for this client */
     oq = (struct ordq_item_t*)ordq.first;
     while ( oq )
     {
         if ( oq->who == who )
	 {
	     dum = oq->next;
	     list_del(&ordq, (struct list_hdr_t*)oq);
	     oq = dum;
	 }
	 else oq = (struct ordq_item_t*)oq->next;
     }
     /* clean the ackq too */
     aq = (struct ackq_item_t*)ackq.first;
     while ( aq )
     {
         if ( aq->who == who )
	 {
	     dum = aq->next;
	     list_del(&ackq, (struct list_hdr_t*)aq);
	     aq = dum;
	 }
	 else aq = (struct ackq_item_t*)aq->next;
     }
     /* cleaning finished... */
     cmd_q(who, CMD_ALR_REGGED, NULL, 0);
     switch ( who->type )
     {
         case LCS_CLT_LC:
             syslog(LOG_INFO, "%s:%d registered.", inet_ntoa(from->sin_addr), ntohs(from->sin_port));
	     break;
	 case LCS_CLT_DC:
             syslog(LOG_INFO, "%s:%d reinitialized.", inet_ntoa(from->sin_addr), ntohs(from->sin_port));
	     break;
     }
     who->port = from->sin_port;
     who->started = 0;
     who->line = line;
     if ( who->status == CLT_ONLINE )
         line->online--;
     who->status = CLT_OFFLINE;
     if ( (pack->interval < LCC_MIN_TIMEOUT) ||
          (pack->interval > LCC_MAX_TIMEOUT) )
	      pack->interval = LCC_DEFAULT_TIMEOUT;
     who->interval = pack->interval;
     who->timeout = time(NULL) + who->interval;
     return(0);
 }
 /* now we have certainly a valid *client (who).
  * update timeout value */
 who->timeout = time(NULL) + who->interval;
 switch ( pack->cmd )
 {
     case CMD_REG:
         cmd_q(who, CMD_REGISTERED, NULL, 0);
         break;
     case CMD_DIAL:
         check_con_status();
	 switch ( line->con_stat )
	 {
	     case CST_DOWN:
	         call_con_up(who, line);
		 // don't break! go on...
	     case CST_DIALING:
	         // hey, just wait... he will get it's CBR_CON_UP or so... :)
		 if ( who->status != CLT_ONLINE )
		 {
		     line->online++;
		     who->status = CLT_ONLINE;
                     if ( line->client_online[0] )
		         exec_dont_care_param(line->client_online, inet_ntoa(from->sin_addr));
		 }
	         break;
	     case CST_UP_SERVER:
	         cmd_direct(CBR_CON_UP, sock, from, NULL, 0, type);
	         // not sent as broadcast --> don't queue (won't get ACK)!!
		 if ( who->status != CLT_ONLINE )
		 {
		     line->online++;
		     who->status = CLT_ONLINE;
                     if ( line->client_online[0] )
		         exec_dont_care_param(line->client_online, inet_ntoa(from->sin_addr));
		 }
	         break;
	     case CST_UP_USER:
	         cmd_direct(CBR_USER_UP, sock, from, NULL, 0, type);
	         //cmd_q(who, CBR_USER_UP, NULL, 0);
		 if ( who->status != CLT_ONLINE )
		 {
		     line->online++;
		     who->status = CLT_ONLINE;
                     if ( line->client_online[0] )
		         exec_dont_care_param(line->client_online, inet_ntoa(from->sin_addr));
		 }
	         break;
	     case CST_CLOSING:
	         cmd_q(who, CMD_CLOSING, NULL, 0);
	         break;
	     case CST_CLOSE_ERROR:
	         cmd_direct(CBR_CON_UP, sock, from, NULL, 0, type);
		 // cmd_q(who, CBR_CON_UP, NULL, 0);
		 if ( who->status != CLT_ONLINE )
		 {	// hmmm... dunno if that's ok.
		     line->online++;
		     who->status = CLT_ONLINE;
                     if ( line->client_online[0] )
		         exec_dont_care_param(line->client_online, inet_ntoa(from->sin_addr));
		 }
	         break;
	     default:
	     // uh... don't dial -> status would be incorrect
	 }
	 if ( who->status == CLT_ONLINE )
	 {
	     syslog(LOG_INFO, "%s:%d online.", inet_ntoa(from->sin_addr), ntohs(from->sin_port));
	     who->started = time(NULL);
	 }
	 break;
     case CMD_BYE:
         kick_client(who, 1); // takes care about server->online
	 if ( (cltlist.count == 0) || (line->online == 0) ) call_con_dn(NULL, line);
         break;
     case CMD_OFFLINE:
	 if ( who->status == CLT_ONLINE )
	 {
	     line->online--;
	     client_log_times(who);
	     if ( line->online == 0 ) call_con_dn(who, line);
	     who->status = CLT_OFFLINE;
             if ( line->client_offline[0] )
	         exec_dont_care_param(line->client_offline, inet_ntoa(from->sin_addr));
	     who->started = 0;
	     syslog(LOG_INFO, "%s:%d offline.", inet_ntoa(from->sin_addr), ntohs(from->sin_port));
	 }
	 cmd_q(who, CMD_YOUROFFLINE, NULL, 0);
         break;
     case CMD_REFRESH:
         // ok, we refreshed its timeout already!
	 // so we only have to update it.
         if ( (pack->interval < LCC_MIN_TIMEOUT) ||
              (pack->interval > LCC_MAX_TIMEOUT) )
	          pack->interval = LCC_DEFAULT_TIMEOUT;
         who->interval = pack->interval;
	 break;
     case CMD_STAT_REQ:
         send_status(who);
         break;
     case CMD_ADDCHAN:
         add_isdn_channel(who, line);
         break;
     case CMD_RMCHAN:
         remove_isdn_channel(who, line);
         break;
     case CMD_INFO: break;	// we don't need infos, do we?
     case CMD_ERROR:
         kick_client(who, 1);	// your problem :)
	 syslog(LOG_INFO, "%s:%d sent an error - message", inet_ntoa(from->sin_addr), ntohs(from->sin_port));
	 if ( (cltlist.count == 0) || (line->online == 0) ) call_con_dn(NULL, line);
         break;
     case CMD_SHUTDOWN:
#ifdef SHUTDOWN_OK
	 if ( validate_ip(server->shtdn_ipl_type, &shtdn_ipl, from) )
	 { // no access to this command
	     cmd_q(who, CMD_REFUSED, NULL, 0);
	     break;
	 }
	 if ( !server->script_shutdown[0] )
	 {
             cmd_q(who, CMD_INVALID, NULL, 0);
	     break;
	 }
	 syslog(LOG_INFO, "%s:%d requested server shutdown.", inet_ntoa(from->sin_addr), ntohs(from->sin_port));
	 shutdown_server_machine();
	 // now the feedback... :)
         kick_client(who, 1); // takes care about server->online
	 break;
#endif
#ifndef SHUTDOWN_OK
         cmd_q(who, CMD_INVALID, NULL, 0);
         break;
#endif
     default:
         cmd_q(who, CMD_INVALID, NULL, 0);
	 syslog(LOG_INFO, "%s:%d invalid command (%d).", inet_ntoa(from->sin_addr), ntohs(from->sin_port), pack->cmd);
 }
 return(0);
}
