/* 
 * AppController.h created by phr on 2000-08-27 11:38:59 +0000
 *
 * Project TestApp
 *
 * Created with ProjectCenter - http://www.gnustep.org
 *
 * $Id: AppController.h,v 1.7 2003/06/29 17:28:34 probert Exp $
 */

#ifndef _APPCONTROLLER_H_
#define _APPCONTROLLER_H_

#include <AppKit/AppKit.h>

@class Inspector;
@class PrefController;

@interface AppController : NSObject
{
  NSMutableArray *images;

  Inspector *inspector;
  PrefController *preferences;
}

+ (void)initialize;

- (id)init;
- (void)dealloc;

- (void)applicationDidFinishLaunching:(NSNotification *)notif;

- (BOOL)applicationShouldTerminate:(id)sender;
- (void)applicationWillTerminate:(NSNotification *)notification;
- (BOOL)application:(NSApplication *)application openFile:(NSString *)fileName;

- (void)showPrefPanel:(id)sender;
- (void)showInfoPanel:(id)sender;
- (void)showInspector:(id)sender;

- (BOOL)openImageAtPath:(NSString *)path;
- (void)openImage:(id)sender;

- (BOOL)openImagesAtPath:(NSString *)path;
- (void)openImages:(id)sender;

- (void)imageWindowWillClose:(id)sender;

- (void)servicesOpenFileOrDirectory:(NSPasteboard *)pb     
			   userData:(NSString *)ud 
			      error:(NSString **)msg;

- (void)setDefaultSize:(id)sender;

@end

#endif // _APPCONTROLLER_H_
