/**
 * IceMC - a menu editor for IceWM
 * Copyright (c) 2000 Georg Mittendorfer
 */

// IceMainWindow.h - headerfile for IceMainWindow.cpp and IceMainWidget.cpp
// represents the GUI of IceMC
// don't forget to use the moc-compiler if changing the slots!

// created:  0009?? mig
// modified: 001002 mig

#ifndef ICEMAINWINDOW_H_USED
#define ICEMAINWINDOW_H_USED

#include "IceMC.h"

#include "IceClipboard.h"
#include "IceListView.h"

#include <qlineedit.h>
#include <qmainwindow.h>
#include <qcombobox.h>
#include <qstatusbar.h>

class IceMainWidget : public QWidget
{
  Q_OBJECT

 public:

  // constructor & destructor
  IceMainWidget( QWidget * parent=0, const char * name=0, WFlags f=0 );
  ~IceMainWidget();

  // public methods
  void setDefaultPaths();
  void setLibPath(QString userPath=0);
  void setIconPath(QString userPath=0);
  static QString getLibPath();
  static QString getIconPath();
  static QString getHomeDir();

  void clearLineEdits();
  void updateListItem(IceListViewItem* item, bool all=false);

  // global public data:
  IceListView* mainview;

 public slots:
  void displayListItem(QListViewItem*);
  void updateListAppl(const QString&);
  void updateListIcon(const QString&);
  void updateListExec(const QString&);
  void updateInfoStr(const QString&);
  void newExec();
  void newIcon();

 private:

  // private methods
  void popupMessage(QString caption, QString msg);

  // global private data
  static QString homeDir;
  static QString libPath;

  QLineEdit* applEdit;
  QLineEdit* iconEdit;
  QLineEdit* execEdit;
  QComboBox* infoCombo;

  QPainter* p;
  const QColorGroup* cg;
};

class IceMainWindow : public QMainWindow
{
  Q_OBJECT
public:
  IceMainWindow();
  ~IceMainWindow();
public slots:
  void popupEdit(QListViewItem*,const QPoint&,int);
  void open();
  void save();
  void save_as();
  void close();
  void exit();
  void cutItem();
  void copyItem();
  void pasteItem();
  void deleteItem();
  void insertApp();
  void insertRestart();
  void insertFolder();
  void insertSeparator();
  void unselect();
  void tool();
  void statusbar();
  void sort();
  void refresh();
  void setCustomPaths();
  void setCustomFont();
  void contents();
  void about();
private:
  // methods:
/*    void setLibPath(QString userPath=0); */
/*    void setIconPath(QString userPath=0); */
  void errorWarning(QString caption, QString msg);
  // global data:
  IceMainWidget* mainwidget;
  IceClipboard* clipboard;

  QToolBar* toolbar;
  QPopupMenu* view;
  QPopupMenu* edit;
	QString currentFile;
};  

#endif















