#include "hx_types.h"
#include <stdlib.h>
#include <netinet/in.h>
#include "hx.h"
#include "hxlib.h"
#include "list.h"
#include "screen.h"
#include "dhargs.h"
#include "xmalloc.h"

struct task *task_list = 0;

static void
task_error (void)
{
	dh_start(&(hx_buf[SIZEOF_HX_HDR]), hx_pos - SIZEOF_HX_HDR)
		if (ntohs(dh->type) == HTLS_DATA_TASKERROR) {
			CR2LF(dh->data, ntohs(dh->len));
			curscr_printf("\n[task error]: %.*s", ntohs(dh->len), dh->data);
		}
	dh_end()
}

void
rcv_task (void)
{
	struct hx_hdr *h = (struct hx_hdr *)hx_buf;
	register u_int32_t trans = ntohl(h->trans);
	register struct task *tp = task_list, *next;

	if (!tp) {
		curscr_printf("\n!task_list && got task 0x%lx", (unsigned long)ntohl(h->trans));
		if (h->flag)
			task_error();
		goto ret;
	}
	while (tp && tp->trans != trans) {
		next = tp->next;
		curscr_printf("\ntask %u timed out", tp->trans);
		if (tp->errfun)
			tp->errfun(tp->data);
		xfree(tp);
		tp = next;
	}
	if (!tp) {
		task_list = 0;
		curscr_printf("\n!task_list && got task 0x%lx", (unsigned long)ntohl(h->trans));
		if (h->flag)
			task_error();
		goto ret;
	}
	if (h->flag) {
		if (tp->errfun)
			tp->errfun(tp->data);
		task_error();
	} else if (tp->fun)
		tp->fun(tp->data);
	task_list = tp->next;
	xfree(tp);
ret:
	hx_reset();
}

void
task_new (u_int32_t trans, task_fn_t fun, task_fn_t errfun, void *data)
{
	struct task *tsk;

	tsk = xmalloc(sizeof *tsk);
	tsk->next = 0;
	tsk->trans = trans;
	tsk->fun = fun;
	tsk->errfun = errfun;
	tsk->data = data;

	LISTADD(struct task *, task_list, tsk)
}

int cmd_tasks (void);

int
cmd_tasks (void)
{
	register struct task *tp;

	for (tp = task_list; tp; tp = tp->next)
		curscr_printf("\n%u", tp->trans);

	return 0;
}
