#include "hx_types.h"
#include <netdb.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <stdio.h>
#include <getopt.h>
#include "hx.h"
#include "screen.h"
#include "hxlib.h"
#include "htlc.h"

void rcv_login_complete (void);
int cmd_server (int argc, char *const *argv);

void
rcv_login_complete (void)
{
	curscr_printf("\n <\xa5> login successful");
}

extern int getting_list;

static struct option server_opts[] = {
	{"login",	1, 0,	'l'},
	{"password",	1, 0,	'p'},
	{"nickname",	1, 0,	'n'},
	{"icon",	1, 0,	'i'},
	{0, 0, 0, 0}
};

int
cmd_server (int argc, char *const *argv)
{
	u_int16_t port = HTLS_TCPPORT, icon = hx_prefs.icon;
	char *login = 0, *pass = 0, *pstr = 0, *node = 0, *nick = hx_prefs.nick;
	int o, longind;
	register int i;

	optind = 0;
	for (i = 0; i < argc; i++)
		if (argv[i][0] != '-' && argv[i + 1] && argv[++i][0] != '-') {
			node = argv[i];
			if (argv[i + 1] && argv[i + 1][0] != '-')
				pstr = argv[++i];
		}

	while ((o = getopt_long(argc, argv, "l:p:n:i:", server_opts, &longind)) != EOF) {
		if (o == 0)
			o = server_opts[longind].val;
		switch (o) {
			case 'l':
				login = optarg;
				break;
			case 'p':
				pass = optarg;
				break;
			case 'n':
				nick = optarg;
				break;
			case 'i':
				icon = atou16(optarg);
				break;
			default:
				goto usage;
		}
	}

	if (!node) {
usage:
		curscr_printf("\nusage: %s [-l login] [-p password] [-n nickname] [-i icon]\n"
				"       <server address> [port]", argv[0]);
		return 1;
	}

	if (pstr) {
		struct servent *se;
		if (!(port = atou16(pstr))) {
			if ((se = getservbyname(pstr, "tcp")))
				port = ntohs(se->s_port);
			else {
				curscr_printf("\n%s: invalid port '%s'", argv[0], pstr);
				return -1;
			}
		}
	} else
		port = HTLS_TCPPORT;
	if (hx_sock >= 0)
		hx_conn_close();
	if (hx_conn_open(node, port) == -1)
		return -1;
	task_new(hx_trans, (task_fn_t)rcv_login_complete, 0, 0);
	htlc_snd_login(login, pass, nick, (u_int32_t)icon);
	task_new(hx_trans, rcv_user_list, 0, &user_list);
	htlc_snd_user_getlist();
	getting_list = 1;

	return 0;
}
