/* memmove -- copy memory to memory until the specified number of bytes
 * has been copied.  Overlap is handled correctly.
 */
#include "hx_types.h"

void *
memmove (void *dst, const void *src, size_t len)
{
	register unsigned char *sp = (unsigned char *)src + len, *start = (unsigned char *)src;
	register unsigned char *dp = (unsigned char *)dst + len;

	while (sp >= start)
		*dp-- = *sp--;

	return dst;
}
