/*
 *  Hubcot (USB-HUB MASCOT) driver for Linux
 *
 *  Copyright (C) 2001 Tomoaki MITSUYOSHI <micchan@geocities.co.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  This source made use of the result of uhubcot driver for NetBSD
 *  by Takuya SHIOZAKI <tshiozak@netbsd.org>.
 *
 *  "Hubcot" is trademarked by Dreams come true co.,Ltd.
 */

/* $Id: hubcot.h,v 1.2 2001/06/30 07:47:10 mitsu Exp mitsu $ */

#ifndef __HUBCOT_H__
#define __HUBCOT_H__

/* This is a temporary value. It's welcome to decide this value as you like. */
#define HUBCOT_MINOR  123

#define USB_VENDOR_HUBCOT_TORO	 0x054D
#define USB_PRODUCT_HUBCOT_TORO	 0x1B59
/*
 * V/PID for "KITTY" was brought
 * by Shingo Akagaki <dora@digitalfactory.co.jp>.
 */
#define USB_VENDOR_HUBCOT_KITTY	 0x0D74
#define USB_PRODUCT_HUBCOT_KITTY 0xD001


/*** Request code pool for Hubcot !! ***/
typedef enum {
  HUBCOT_REQ_NOOP         = 0x00,
  HUBCOT_REQ_RIGHT        = 0x01,
  HUBCOT_REQ_LEFT         = 0x02,
  HUBCOT_REQ_BOTH         = 0x03,
  HUBCOT_REQ_BOTH_QUAD    = 0x04,
  HUBCOT_REQ_LRLRLR       = 0x05,
  HUBCOT_REQ_RIGHT_TRIPLE = 0x06,
  HUBCOT_REQ_BOTH_TRIPLE  = 0x08,
  HUBCOT_REQ_RL           = 0x0B,
  HUBCOT_REQ_RLRLRL       = 0x0C
} hubcot_request_type_t;

#endif  /* __HUBCOT_H__ */
