<?php
/**
 * A script to redirect to a given URL, used for example in IMP to hide any
 * referrer data being passed to the remote server and potentially exposing any
 * session IDs.
 *
 * If an "untrusted" parameter is set, it passes the content of the given URL
 * through to the browser if it doesn't belong to the local site. This can be
 * used to avoid calling local URLs for example by image src attributes.
 *
 * Copyright 2003-2005 Marko Djukic <marko@oblo.com>
 *
 * See the enclosed file COPYING for license information (LGPL). If you did not
 * receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * $Horde: horde/services/go.php,v 1.6.2.1 2005/01/03 12:25:45 jan Exp $
 *
 * @author Marko Djukic <marko@oblo.com>
 * @version $Revision: 1.6.2.1 $
 */

if (empty($_GET['url'])) {
    exit;
}

if (get_magic_quotes_gpc()) {
    $url = @parse_url(stripslashes($_GET['url']));
} else {
    $url = @parse_url($_GET['url']);
}

if (empty($url) || empty($url['host'])) {
    exit;
}

// Do a little due diligence on the target URL. If it's on the same
// server that we're already on, display an intermediate page asking
// people if they're sure they want to click through.
if ((!empty($_SERVER['SERVER_NAME']) &&
     $_SERVER['SERVER_NAME'] == $url['host']) ||
    (!empty($_SERVER['HTTP_HOST']) &&
     $_SERVER['HTTP_HOST'] == $url['host'])) {
?>
<html>
<head>
<title>Potentially Dangerous URL</title>
</head>
<body>
 <h1>Potentially Dangerous URL</h1>

 <p>
  A referring site, an email you were reading, or some other
  untrusted source has attempted to send you to <?php echo
  htmlspecialchars($_GET['url']) ?>. This may be an attempt to
  delete data or change settings without your knowledge. If
  you have any concerns about this URL, please contact your
  System Administrator. If you are confident that it is safe,
  you may follow the link by clicking below.
 </p>

 <p>
  <a href="<?php echo htmlspecialchars($_GET['url']) ?>"><?php echo htmlspecialchars($_GET['url']) ?></a>
 </p>

</body>
</html>
<?php
    exit;
}

// Pass through image content if requested.
if (!empty($_GET['untrusted'])) {
    readfile($_GET['url']);
    exit;
}

// Otherwise we're issuing a refresh.
header('Refresh: 0; URL=' . $_GET['url']);
