# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

"""/***************************************************************************
 *            Editorwindows.py
 *
 *  Thu Apr  8 15:08:38 2004
 *  Copyright  2004  Stas Z
 *  stasz@linux.isbeter.nl
 ****************************************************************************/
These are the new editor window objects for gvr. 
""" 
import gvrparser
import os
import re
import keyword
import wx
from wxPython.wx import *
from wxPython.stc import *
from wx.stc import *
from utils import get_rootdir,isOsX,L2U

# Code window IDs
ID_LOADCODE    = wxNewId()
ID_SAVECODE    = wxNewId()
ID_SAVECODE_AS = wxNewId()
ID_CLOSECODE   = wxNewId()

# World Window IDs
ID_LOADWORLD    = wxNewId()
ID_SAVEWORLD    = wxNewId()
ID_SAVEWORLD_AS = wxNewId()
ID_CLOSEWORLD   = wxNewId()

# Used by the SaveTextAs method to determine the default directory for saving
# The "New" part is used as the default basename when saving something and is
# joined with self.ext to provide a default filename with the proper extension
if os.name == 'nt' or isOsX():
    BASEDIR = os.path.join(get_rootdir(),'examples','New')
else:
    if os.path.exists(os.path.expanduser('~/GvR')):
        BASEDIR = os.path.expanduser('~/GvR/New')
    else:
        BASEDIR = os.path.expanduser('~/New')
if wxPlatform == '__WXMSW__':
    faces = { 'times': 'Times New Roman',
              'mono' : 'Courier New',
              'helv' : 'Arial',
              'other': 'Comic Sans MS',
              'size' : 10,
              'size2': 8,
             }
else:
    faces = { 'times': 'Times',
              'mono' : 'Courier',
              'helv' : 'Helvetica',
              'other': 'new century schoolbook',
              'size' : 10,
              'size2': 8,
             }

class EditorWindow(wxFrame):
    """Super class, you should let your editorwindows inherit from this class."""
    def __init__(self, gui):
        wxFrame.__init__(self, gui, -1, '', wxDefaultPosition, wxSize(350,500))
        self.gui = gui
        if os.name == 'nt':
            self.lastDir = self.dirName() # see subclass
        else:
            self.lastDir = os.path.expanduser('~/GvR')
        self.cur_file_name = self.newFileName()
        self.filePath = BASEDIR
        self.fileWasOpened = 0
        self.textctrl = wxStyledTextCtrl(self, -1, wxDefaultPosition, \
                                            wxDefaultSize, 0)
        ############## Refactor part from Andre's gvreditor.py #####################
        # Global default styles for all languages
        self.textctrl.StyleSetSpec(STC_STYLE_DEFAULT,"face:%(mono)s,size:%(size)d" % faces)

        # folding and white spaces        
        self.textctrl.SetProperty("fold", "1")
        self.textctrl.SetProperty("tab.timmy.whinge.level", "1")
        self.textctrl.SetMargins(2,2)

        # Set up the numbers in the margin for margin #1
        self.textctrl.StyleSetSpec(STC_STYLE_LINENUMBER,"back:#99AACC,face:%(mono)s,size:%(size2)d" % faces)
        ## Default margin is fine trust wxPython --stas 
        ## Also the SetMarginType call leads to double line numbers (on Linux) --stas
        #self.textctrl.SetMarginType(1, STC_MARGIN_NUMBER)
        # Reasonable (?) value for 3 digits using a small mono font (25 pixels)
        #self.textctrl.SetMarginWidth(1, 33)

        # Setup a margin to hold fold markers
        self.textctrl.SetMarginType(2, STC_MARGIN_SYMBOL)
        self.textctrl.SetMarginMask(2, STC_MASK_FOLDERS)
        self.textctrl.SetMarginSensitive(2, True)
        self.textctrl.SetMarginWidth(2, 12)
        # and now set up the fold markers; squares for top level
        self.textctrl.MarkerDefine(STC_MARKNUM_FOLDER, STC_MARK_BOXPLUS, "white", "black")
        self.textctrl.MarkerDefine(STC_MARKNUM_FOLDEROPEN, STC_MARK_BOXMINUS, "white", "black")
        # circles for mid-levels to better distinguish from top-level        
        self.textctrl.MarkerDefine(STC_MARKNUM_FOLDEREND, STC_MARK_CIRCLEPLUSCONNECTED, "white", "black")
        self.textctrl.MarkerDefine(STC_MARKNUM_FOLDEROPENMID, STC_MARK_CIRCLEMINUSCONNECTED, "white", "black")
        # straight perpendicular lines to connect
        self.textctrl.MarkerDefine(STC_MARKNUM_FOLDERMIDTAIL, STC_MARK_TCORNER, "white", "black")
        self.textctrl.MarkerDefine(STC_MARKNUM_FOLDERTAIL, STC_MARK_LCORNER, "white", "black")
        self.textctrl.MarkerDefine(STC_MARKNUM_FOLDERSUB, STC_MARK_VLINE, "white", "black")

        # Indentation and tab stuff
        self.textctrl.SetIndent(4)               # Proscribed indent size for wx
        self.textctrl.SetIndentationGuides(True) # To help beginners, show indent guides
        self.textctrl.StyleSetSpec(STC_STYLE_INDENTGUIDE, "fore:#CCCCCC") 
        self.textctrl.SetBackSpaceUnIndents(True)# Backspace unindents rather than delete 1 space
        self.textctrl.SetTabIndents(True)        # Tab key indents
        self.textctrl.SetTabWidth(4)             # Proscribed tab size for wx
        self.textctrl.SetUseTabs(False)          # Use spaces rather than tabs, or TabTimmy will complain!
        self.textctrl.SetViewWhiteSpace(False)
        
        EVT_STC_MARGINCLICK(self, -1,self.OnMarginClick)
        ## No need for GUI update like in Andre's gvreditor.py because it has
        ## todo with braces etc. It's something gvr doesn't use.        
        # Python styles
        self.textctrl.SetLexer(STC_LEX_PYTHON)
        # Added some gvr keywords
        #self.textctrl.SetKeyWords(0, self.keywords())
        #self.textctrl.SetKeyWords(0, " ".join(("E","N","S","W")))
        # Default 
        self.textctrl.StyleSetSpec(STC_P_DEFAULT, "fore:#000000,face:%(mono)s,size:%(size)d" % faces)

        # changes from defaults: for pedagogical reasons, I chose to highlight python keywords (bold, blue),
        # all strings (including comments) in green and everything else in black.
        self.textctrl.StyleSetSpec(STC_P_WORD, "fore:#336699,bold,face:%(mono)s,size:%(size)d" % faces)# Keywords
        
        all_strings_style = "fore:#007F00,face:%(mono)s,size:%(size)d"  
        self.textctrl.StyleSetSpec(STC_P_COMMENTLINE, all_strings_style % faces) # Comments
        
        ## Rest not used in gvr --stas 
        self.textctrl.StyleSetSpec(STC_P_STRING, all_strings_style % faces)      # String
        self.textctrl.StyleSetSpec(STC_P_CHARACTER, all_strings_style % faces)   # Single quoted string
        self.textctrl.StyleSetSpec(STC_P_TRIPLE, all_strings_style % faces)      # Triple quotes
        self.textctrl.StyleSetSpec(STC_P_TRIPLEDOUBLE, all_strings_style % faces)# Triple double quotes
        self.textctrl.StyleSetSpec(STC_P_COMMENTBLOCK, all_strings_style % faces)# Comment-blocks
        
        ################## End of Andre's part  ########
        
        #self.textctrl.SetUseTabs(0)
        #self.textctrl.SetTabWidth(4)
        #self.textctrl.SetUseHorizontalScrollBar(0)
        #self.textctrl.StyleSetFaceName(10, "Courier")
        #~ self.textctrl.SetLexer(STC_LEX_PYTHON)
        self.textctrl.SetKeyWords(0, self.keywords())
        
        #~ self.textctrl.StyleSetSpec(STC_P_WORD, 'fore:#ff0000,bold')
        self.set_title(L2U(_("New %s")) % self.getWindowName())       
        self.question = 1    
    def __del__(self):
        #print "del called",self
        pass
    def keywords(self):
        kw = " ".join(self.kwords)
        return kw
    
    # The following has been copied vertabim from the wxPython demo --Andre
    # refactor for gvr with wxpython 2.4 --Stas
    def OnMarginClick(self, evt):
        # fold and unfold as needed
        if evt.GetMargin() == 2:
            if evt.GetShift() and evt.GetControl():# Not sure what evt.GetControl does --stas
                self.FoldAll()
            else:
                lineClicked = self.textctrl.LineFromPosition(evt.GetPosition())
                if self.textctrl.GetFoldLevel(lineClicked) & STC_FOLDLEVELHEADERFLAG:
                    if evt.GetShift():
                        self.textctrl.SetFoldExpanded(lineClicked, True)
                        self.Expand(lineClicked, True, True, 1)
                    elif evt.GetControl():
                        if self.textctrl.GetFoldExpanded(lineClicked):
                            self.textctrl.SetFoldExpanded(lineClicked, False)
                            self.Expand(lineClicked, False, True, 0)
                        else:
                            self.textctrl.SetFoldExpanded(lineClicked, True)
                            self.Expand(lineClicked, True, True, 100)
                    else:
                        self.textctrl.ToggleFold(lineClicked)
    
    # The following has been copied vertabim from the wxPython demo --Andre
    # refactor for gvr with wxpython 2.4 --Stas
    def FoldAll(self):
        lineCount = self.textctrl.GetLineCount()
        expanding = True
        # find out if we are folding or unfolding
        for lineNum in range(lineCount):
            if self.textctrl.GetFoldLevel(lineNum) & STC_FOLDLEVELHEADERFLAG:
                expanding = not self.textctrl.GetFoldExpanded(lineNum)
                break;
        lineNum = 0
        while lineNum < lineCount:
            level = self.textctrl.GetFoldLevel(lineNum)
            if level & STC_FOLDLEVELHEADERFLAG and \
               (level & STC_FOLDLEVELNUMBERMASK) == STC_FOLDLEVELBASE:
                if expanding:
                    self.textctrl.SetFoldExpanded(lineNum, True)
                    lineNum = self.textctrl.Expand(lineNum, True)
                    lineNum = lineNum - 1
                else:
                    lastChild = self.textctrl.GetLastChild(lineNum, -1)
                    self.textctrl.SetFoldExpanded(lineNum, False)
                    if lastChild > lineNum:
                        self.textctrl.HideLines(lineNum+1, lastChild)
            lineNum += 1

    # The following has been copied vertabim from the wxPython demo --Andre
    # refactor for gvr with wxpython 2.4 --Stas
    def Expand(self, line, doExpand, force=False, visLevels=0, level=-1):
        lastChild = self.textctrl.GetLastChild(line, level)
        line += 1
        while line <= lastChild:
            if force:
                if visLevels > 0:
                    self.textctrl.ShowLines(line, line)
                else:
                    self.textctrl.HideLines(line, line)
            else:
                if doExpand:
                    self.textctrl.ShowLines(line, line)
            if level == -1:
                level = self.textctrl.GetFoldLevel(line)
            if level & STC_FOLDLEVELHEADERFLAG:
                if force:
                    if visLevels > 1:
                        self.textctrl.SetFoldExpanded(line, True)
                    else:
                        self.textctrl.SetFoldExpanded(line, False)
                    line = self.Expand(line, doExpand, force, visLevels-1)
                else:
                    if doExpand and self.textctrl.GetFoldExpanded(line):
                        line = self.Expand(line, True, force, visLevels-1)
                    else:
                        line = self.Expand(line, False, force, visLevels-1)
            else:
                line += 1;
        return line

    def _windowmenu_toggle(self, toggle):
        self.windowToggleMenu().Check(toggle)
    def setTextCtrlMargin(self):
        self.textctrl.SetMarginType(0, wxSTC_MARGIN_NUMBER)
        self.textctrl.SetMarginWidth(0, \
                self.textctrl.TextWidth(wxSTC_STYLE_LINENUMBER,\
                    '9999'))
    def installMenuBar(self, file):
        menubar = wxMenuBar()
        menubar.Append(file, L2U(_("&File")))
        self.SetMenuBar(menubar)
    def set_title(self,title):
        self.SetTitle(title)
    def show_me(self):
        self.Show(1)
        self._windowmenu_toggle(1)
        self.setTextCtrlMargin()
    def hide_me(self):
        self.Show(0)
        self._windowmenu_toggle(0)
    def _reset_window(self):
        """Used to prevent TimeToQuit of starting the "save file" dialog."""
        self.question = None  
    def TimeToQuit(self, *args):
        # these retval things could be removed when all is working properly
        retval = 1#used as a return test value for the caller
        if self.fileWasOpened:
            try:
                ftxt = open(self.filePath).read()
            except Exception,info:
                print info
                ftxt = None
        else:
            ftxt = ''
        if self.textctrl.GetText() != ftxt:
            dlg = wxMessageDialog(self, \
                L2U(_('The %s file has been modified. Would you like to save it before exiting?'))\
                % self.cur_file_name,\
                L2U(_('Modified '))+ "%s" % self.cur_file_name, \
                wxYES_NO|wxCANCEL)
            choice = dlg.ShowModal()
            if choice == wxID_CANCEL: 
                return 0
            if choice == wxID_YES:
                self.SaveTextAs()
            if choice == wxID_YES or wxID_NO:
                retval = 1
        self.Show(0)
        self._windowmenu_toggle(0)
        # When the user quits gvr AND has a world AND code window open AND the
        # world file is saved already, then gvr wants to load a empty world as
        # a result of calling ResetEditorWindows.
        # This method is called from gvr.py on exit time with a argument which
        # we test here.
        if not args:
            self.gui.ResetEditorWindows(str(self))
        self.Destroy()
        return retval
        
    def OpenWithFile(self,event=None,title='',lastdir='',ext='',file=''):
        if not lastdir:
            lastdir = self.lastDir
        if not title:
            title = L2U(_("Open a file in the %s")) % self.getWindowName()
        if not ext:
            ext = self.wxext
        if file:
            path = file
        else:
            dlg = self.FileDialog(Title=title, Lastdir=lastdir,Ext=ext, Wxconst=wxOPEN)
            if dlg.ShowModal() == wxID_OK:
                path = dlg.GetPath()
            else:
                dlg.Destroy()
                return 
            dlg.Destroy()
        self.set_title(("%s : "+os.path.basename(path)) % self.getWindowName())
        try:
            # For some reason in Windows this actually loads
            # the lines properly and doesn't get thrown off by the ^Ms
            # which happens if you use self.textctrl.LoadFile() -- W
            lines = open(path).read()
            lines = re.sub('\r\n', '\n', lines)
            self.textctrl.SetText(lines)
        except Exception,info:
            print info
        self.gui.StuffAvailable(str(self),1)
        self.filePath = path
        self.cur_file_name = os.path.basename(path)
        self.fileWasOpened = 1
        return path
    
    def SaveText(self,*args):
        if self.filePath != BASEDIR:
            self.save_file(self.filePath)
        else:
            self.SaveTextAs()

    def SaveTextAs(self,*args):
        dlg = wxFileDialog(
            self,
            L2U(_("Choose a filename for your program")),
            os.path.dirname(self.filePath),
            os.path.basename(self.filePath+self.ext),
            self.wxext,
            wxSAVE | wxOVERWRITE_PROMPT)
        if dlg.ShowModal() == wxID_OK:
            path = dlg.GetPath()
            base, ext = os.path.splitext(path)
            if ext != self.ext:
                path = base+self.ext
            dlg.Destroy()
            self.save_file(path)
        else: dlg.Destroy()

    def FileDialog(self,Title="",Lastdir=os.getcwd(),Ext="",Wxconst=""):
        dlg = wxFileDialog(self,Title,Lastdir, "", Ext,eval(str(Wxconst)))
        return dlg

    def save_file(self,path):
        try:
            f = open(path, 'w')
            f.write(self.textctrl.GetText())
            f.close()
        except IOError:
            wxMessageBox(L2U(_("Can't save the file to chosen location,\nmake sure you have the proper permissions.")),"GvR-ERROR")
        else:
            self.cur_file_name = os.path.basename(path)
            self.filePath = path
            self.set_title(self.cur_file_name)
            self.fileWasOpened = 1
            self.gui.StuffAvailable(str(self),1)
    
    def selectLine(self, line):
        textctrl = self.textctrl
        start = textctrl.PositionFromLine(line)
        end = textctrl.GetLineEndPosition(line)
        textctrl.SetSelection(start, end)

class WorldEditorWindow(EditorWindow):
    def __init__(self,gui):
        self.wxext = "World files (*.wld)|*.wld| All files (*.*)|*.*"
        self.ext = ".wld"
        self.kwords = [_('Robot'), _('Wall'), _('Beepers'), _('Size')]
        EditorWindow.__init__(self,gui)
        file = wxMenu()
        file.Append(ID_LOADWORLD, L2U(_("&Open World for Editing...")),\
                                    L2U(_("Open a world and edit it")))
        file.Append(ID_SAVEWORLD,L2U(_("&Save World")),\
                            L2U(_("Save the world you are currently editing")))
        file.Append(ID_SAVEWORLD_AS, L2U(_("S&ave World As...")),\
          L2U(_("Save the world you are currently editing under another file name")))
        file.AppendSeparator()
        file.Append(ID_CLOSEWORLD, L2U(_("Close World Window")),\
                                L2U(_("Hides the World Window")))
        self.installMenuBar(file)
        EVT_MENU(self, ID_LOADWORLD,self.OpenWithFile)
        EVT_MENU(self, ID_SAVEWORLD, self.SaveText)
        EVT_MENU(self, ID_SAVEWORLD_AS, self.SaveTextAs)
        EVT_MENU(self, ID_CLOSEWORLD, self.TimeToQuit)
        EVT_CLOSE(self, self.TimeToQuit)
        self.show_me()
        self.gui.restartButton.Enable(1)
    def __str__(self):
        return "worldwindow"
    def getWindowName(self):
        return L2U(_("World window"))
    def windowToggleMenu(self):
        return self.gui.worldwindowmenu
    def dirName(self):
        return "worlds"
    def newFileName(self):
        return L2U(_("New world"))
    

class CodeEditorWindow(EditorWindow):
    def __init__(self,gui):
        self.wxext = "GvR files (*.gvr)|*.gvr| All files (*.*)|*.*"
        self.ext = ".gvr"
        self.kwords = gvrparser.TESTS+gvrparser.COMMANDS+gvrparser.DIV
        EditorWindow.__init__(self,gui)
        file = wxMenu()
        file.Append(ID_LOADCODE, L2U(_("&Open Program for Editing...")),\
                                    L2U(_("Open a program and edit it")))
        file.Append(ID_SAVECODE, L2U(_("&Save Program")), \
                            L2U(_("Save the program you are currently editing")))
        file.Append(ID_SAVECODE_AS, L2U(_("S&ave Program As...")),\
         L2U(_("Save the program you are currently editing to a specific file name")))
        file.AppendSeparator()
        file.Append(ID_CLOSECODE, L2U(_("Close Program Window")),\
                                    L2U(_("Hides the Program Window")))
        self.installMenuBar(file)
        EVT_MENU(self, ID_LOADCODE, self.OpenWithFile)
        EVT_MENU(self, ID_SAVECODE, self.SaveText)
        EVT_MENU(self, ID_SAVECODE_AS, self.SaveTextAs)
        EVT_MENU(self, ID_CLOSECODE, self.TimeToQuit)
        EVT_CLOSE(self, self.TimeToQuit)
        self.show_me()
    def __str__(self):
        return "codewindow"
    def getWindowName(self):
        return L2U(_("Code window"))
    def windowToggleMenu(self):
        return self.gui.codewindowmenu
    def dirName(self):
        return 'programs'
    def newFileName(self):
        return L2U(_("New program"))
    def getText(self):
        text = ''
        for x in range(self.textctrl.GetLineCount()):
            text += self.textctrl.GetLine(x)
        return text
    
