/*
 * GUI misc functions module
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <gdk/gdk.h>
#include "guimisc.h"

/** Misc exported functions **/
/**
 * is_rect_in_rect:
 * Return %TRUE if rectangle @obj is in rectangle @area.
 * This is based on RoachInRect() of xroach-1.5.
 **/
gboolean
is_rect_in_rect(const GdkRectangle *obj, const GdkRectangle *area)
{
	return ((obj->x >= area->x)
			&& (obj->y >= area->y)
			&& ((obj->x + obj->width) <= (area->x + area->width))
			&& ((obj->y + obj->height) <= (area->y + area->height)));
}

/**
 * is_rect_intersect:
 * Return %TRUE if two rectangles @obj1 and @obj2 intersect.
 * This is based on RoachOverRect() of xroach-1.5.
 **/
gboolean
is_rect_intersect(const GdkRectangle *obj1, const GdkRectangle *obj2)
{
	return ((obj1->x < (obj2->x + obj2->width))
			 && ((obj1->x + obj1->width) > obj2->x)
			 && (obj1->y < (obj2->y + obj2->height))
			 && ((obj1->y + obj1->height) > obj2->y));
}

/**
 * is_rect_point_in:
 * Return %TRUE if point(@x,@y) is in rectangle @rect.
 **/
gboolean
is_rect_point_in(const GdkRectangle *rect, gint x, gint y)
{
	return ((x >= rect->x)
			&& (y >= rect->y)
			&& (x <= (rect->x + rect->width))
			&& (y <= rect->y + rect->height));
}
