indexing

	description:

		"System clocks (precision to the second)"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 2001, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/06/26 20:05:29 $"
	revision: "$Revision: 1.9 $"

class KL_SYSTEM_CLOCK

inherit

	KI_SYSTEM_CLOCK













































creation

	make

feature {NONE} -- Initialization

	make is
			-- Create a new system clock.
		do



		end


feature -- Access

	year: INTEGER
			-- Year

	month: INTEGER
			-- Month

	day: INTEGER
			-- Day

	hour: INTEGER
			-- Hour

	minute: INTEGER
			-- Minute

	second: INTEGER
			-- Second


feature -- Setting

	set_local_time is
			-- Set clock to current local time.

		local
			tm_struct: POINTER
			time_t: INTEGER





		do





















			time_t := c_time
			tm_struct := tm_localtime ($time_t)
			year := 1900 + tm_year (tm_struct)
			month := tm_month (tm_struct) + 1
			day := tm_day (tm_struct)
			hour := tm_hour (tm_struct)
			minute := tm_minute (tm_struct)
			second := tm_second (tm_struct)

		end

	set_utc_time is
			-- Set clock to current UTC time.

		local
			tm_struct: POINTER
			time_t: INTEGER





		do





















			time_t := c_time
			tm_struct := tm_gmtime ($time_t)
			year := 1900 + tm_year (tm_struct)
			month := tm_month (tm_struct) + 1
			day := tm_day (tm_struct)
			hour := tm_hour (tm_struct)
			minute := tm_minute (tm_struct)
			second := tm_second (tm_struct)

		end


feature {NONE} -- Implementation







	c_time: INTEGER is
			-- System time in seconds since 1 January 1970 at 00:00:00 UTC
		external
			"C [macro <time.h>]: EIF_INTEGER"
		alias
			"time(NULL)"
		end

	tm_localtime (t: POINTER): POINTER is
			-- Convert `t' seconds since 1 January 1970 at 00:00:00 UTC
			-- to local time 'struct tm*'
		external
			"C (const time_t*): EIF_POINTER | <time.h>"
		alias
			"localtime"
		end

	tm_gmtime (t: POINTER): POINTER is
			-- Convert `t' seconds since 1 January 1970 at 00:00:00 UTC
			-- to Coordinated Universal Time (UTC) 'struct tm*'
		external
			"C (const time_t*): EIF_POINTER | <time.h>"
		alias
			"gmtime"
		end

	tm_year (p: POINTER): INTEGER is
			-- Years since 1900
		external
			"C [struct <time.h>] (struct tm): EIF_INTEGER"
		alias
			"tm_year"
		end

	tm_month (p: POINTER): INTEGER is
			-- Months since January - [0,11]
		external
			"C [struct <time.h>] (struct tm): EIF_INTEGER"
		alias
			"tm_mon"
		end

	tm_day (p: POINTER): INTEGER is
			-- Day of the month - [1,31]
		external
			"C [struct <time.h>] (struct tm): EIF_INTEGER"
		alias
			"tm_mday"
		end

	tm_hour (p: POINTER): INTEGER is
			-- Hours since midnight - [0,23]
		external
			"C [struct <time.h>] (struct tm): EIF_INTEGER"
		alias
			"tm_hour"
		end

	tm_minute (p: POINTER): INTEGER is
			-- Minutes after the hour - [0,59]
		external
			"C [struct <time.h>] (struct tm): EIF_INTEGER"
		alias
			"tm_min"
		end

	tm_second (p: POINTER): INTEGER is
			-- Seconds after the minute - [0,61]
		external
			"C [struct <time.h>] (struct tm): EIF_INTEGER"
		alias
			"tm_sec"
		end



end
