%define name gnometab
%define ver 0.7.3
%define prefix /usr
%define sysconfdir /etc

Summary: Gnometab aims to be a WYSIWIG guitar tablature editor.
Name: %name
Version: %ver
Release: 1
Copyright: GPL
Group: Applications/Productivity
Source: http://www.solutionm.com/gnometab/gnometab-%{ver}.tar.gz
BuildRoot: /var/tmp/%{name}-%{ver}-root
Requires: gtk2 >= 2.0.3
Requires: libgnomeui >= 2.0.0
Requires: libgnomecanvas >= 2.0.0
Requires: libgnomeprintui >= 1.0

%description
Gnometab aims to be a WYSIWYG (what you see is what you get) tablature editor.  
Gnometab's features include copying and pasting of tablature passages, a chord 
library (which the user must fill with chords), professional-looking rhythm 
notation (not perfect yet), the ability to create a variety of tablature symbols 
specific to the guitar -- bends, slurs (hammer-ons, pull-offs, etc.), etc. -- 
and, of course, clean-looking printed output, given any postscript-compatible 
printer.  Gnometab does not attempt to be "smart", i.e., it does not know how 
many beats are in a measure, nor does it know an E chord from an Am chord.  
Instead, the emphasis has been on the appearance of the output.

%prep
%setup -q

%build

if [ -x ./configure ]; then
  CFLAGS=$RPM_OPT_FLAGS ./configure --prefix=%{prefix} --sysconfdir=%{sysconfdir}
else 
  CFLAGS=$RPM_OPT_FLAGS ./autogen.sh --prefix=%{prefix} --sysconfdir=%{sysconfdir}
fi  
make

%install

rm -rf $RPM_BUILD_ROOT

export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
make install prefix=$RPM_BUILD_ROOT%{prefix} \
			sysconfdir=$RPM_BUILD_ROOT%{sysconfdir}
			
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL

%post

export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-install-rule %{sysconfdir}/gconf/schemas/gnometab.schemas

%clean

rm -fr $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc README TODO NEWS INSTALL ChangeLog AUTHORS
%{prefix}/bin/gnometab
%{prefix}/share/pixmaps/*
%{prefix}/share/gnome/apps/Applications/gnometab.desktop
%{sysconfdir}/gconf/schemas/gnometab.schemas
