.TH PSCOUPE l "1 Jan 2004"
.SH NAME
pscoupe \fR- Plot cross-sections of focal mechanisms.
.SH SYNOPSIS
.br
pscoupe \fIfiles\fR \fB\-J\fIparameters\fR \fB-R\fIwest/east/south/north\fR
\fB\-A\fIparameters\fR [ \fB\-B\fItickinfo\fR ] [ \fB\-F\fIfill\fR ]
[ \fB\-G\fIfill\fR ] [ \fB\-H\fR ]
[ \fB\-K\fR ] [ \fB\-L\fI[pen]\fR ] [\fB\-M\fR] [ \fB\-N\fR ] [ \fB\-O\fR ]
[ \fB\-P\fR ] [\fB\-S\fI<symbol><scale>\fR[/d] ]
[ \fB-s\fI<symbol><size>\fR[/d] ] [ \fB\-T\fIn\fR ] [ \fB\-U\fR[\fIlabel\fR] ]
[ \fB\-V\fR ] [ \fB\-W\fIpen\fR ] [ \fB\-X\fIx-shift\fR ]
[ \fB\-Y\fIy-shift\fR ] [ \fB\-Z<cpt>\fR ]
[ \fB\-a\fI[<size>\fR/[\fIP_symbol>\fR/[\fIT_symbol\fR]]] ]
[ \fB\-g\fIfill\fR ] [ \fB\-e\fIfill\fR ] [ \fB\-p\fIpen\fR ]
[ \fB\-t\fIpen\fR ] [ \fB\-:\fR ] [ \fB\-c\fI#copies\fR ]
.SH DESCRIPTION
.br
\fBpscoupe\fR reads data values from \fIfiles\fR [or standard input] and
generates \fIPostScript\fR code that will plot symbols, lines or polygons on a cross-section.
Focal mechanisms may be specified and require additional columns of data.
The \fIPostScript\fR code is written to standard output.
.sp
\fIfiles\fR list one or more file-names. If no files are given, \fBpscoupe\fR
will read standard input.
.sp
A \fInew file\fR is created with the new coordinates (\fBx\fR, \fBy\fR) and the
mechanism (from lower focal half-sphere for horizontal plane, to half-sphere
behind a vertical plane).
When the plane is not horizontal,
- north direction becomes upwards steepest descent direction of the plane (u)
- east direction becomes strike direction of the plane (s)
- down direction (= north^east) becomes u^s
.br
Axis angles are defined in the same way as in horizontal plane in the new system.
.br
Moment tensor (initially in r, t, f system that is up, south, east)
is defined in (-u^s, -u, s) system.
A \fI file\fR is created with extracted events.
.sp
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in .gmtdefaults, but this can be
overridden on the command line by appending the c, i, or m to the scale/width value.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest. To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
If frame is defined from cross-section parameters (see \fB-A\fR) this option is not taken into account,
but must be present.
.TP
\fB\-A\fR selects the cross-section.
.br
\fB\-Aa\fIlon1/lat1/lon2/lat2/dip/p_width/dmin/dmax[f]\fR
.br
\fIlon\fR and \fIlat\fR are the longitude and latitude of points 1 and 2 limiting the length ot the cross-section.
.br
\fIdip\fR is the dip of the plane on which the cross-section is made.
.br
\fIp_width\fR is the width of the cross-section on each side of a vertical plane
or above and under an oblique plane.
.br
\fIdmin\fR and \fIdmax\fR are the distances min and max from horizontal plane,
along steepest descent direction.
.br
Add \fBf\fR to get the frame from the cross-section parameters.
.br
\fB\-Ab\fIlon1/lat1/strike/p_length/dip/p_width/dmin/dmax[f]\fR
.br
\fIlon1\fR and \fIlat1\fR are the longitude and latitude of the beginning of the cross-section.
.br
\fIstrike\fR is the azimut of the direction of the cross-section.
.br
\fIp_length\fR is the length along which the cross-section is made.
.br
The other parameters are the same as for \fB-Aa\fR option.
.br
\fP\-Ac\fIx1/y1/x2/y2/dip/p_width/dmin/dmax[f]\fR
.br
The same as \fB-Aa\fR option with \fIx\fR and \fIy\fR cartesian coordinates.
.br
\fB\-Ad\fIx1/y1/strike/p_length/dip/p_width/dmin/dmax[f]\fR
.br
The same as \fB-Ab\fR option with \fIx\fR and \fIy\fR cartesian coordinates.
.br
.TP
.B \-S
selects the meaning of the columns in the data file and the figure to be plotted.
.TP
\fB\-Sa\fIscale[/fontsize[/offset[u]]]\fR
Focal mechanisms in Aki and Richard convention.
\fIscale\fP adjusts the scaling of the radius of the "beach ball",
which will be proportional to the magnitude. The \fIscale\fP is the size for
magnitude = 5 in MEASURE_UNIT (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is
appended to indicate that the size information is in units of cm, inches,
meters, or points, respectively). Use the \fB-T\fR option
to render the beach ball transparent by drawing only the nodal planes
and the circumference. The color or shade of the compressive
quadrants can be specified with the \fB-G\fR option. The color or shade
of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns:
.sp
.IP \fB1,2\fR:
longitude, latitude of event (\fB-:\fP option interchanges order)
.IP \fB3\fR:
depth of event in kilometers
.IP \fB4,5,6\fR:
strike, dip and rake
.IP \fB7\fR:
magnitude
.IP \fB8,9\fR:
not used; can be 0 0; allows use of the psmeca file format
.IP \fB10\fR:
text string to appear above the beach ball (default) or under (add u).
.sp
.TP
\fB\-Sc\fIscale\fR
Focal mechanisms in Harvard CMT convention.
\fIscale\fP adjusts the scaling of the radius of the "beach ball", which will
be proportional to the magnitude. The \fIscale\fP is the size for magnitude = 5
(that is M0 = 4E+23 dynes-cm.) in MEASURE_UNIT (unless \fBc\fP, \fBi\fP,
\fBm\fP, or \fBp\fP is appended to indicate that the size information is in
units of cm, inches, meters, or points, respectively). Use the \fB-T\fR option
to render the beach ball transparent by drawing only the nodal planes
and the circumference. The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option. The color or shade
of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns:
.IP \fB1,2\fR:
longitude, latitude of event (\fB-:\fP option interchanges order)
.IP \fB3\fR:
depth of event in kilometers
.IP \fB4,5,6\fR:
strike, dip, and slip of plane 1
.IP \fB7,8,9\fR:
strike, dip, and slip of plane 2
.IP \fB10,11\fR:
mantissa and exponent of moment in dyne-cm (if magnitude is uses instead of scalar moment, magnitude is in column 10 and 0 must be in column 11)
.IP \fB12,13\fR:
not used; can be 0 0; allows use of the psmeca file format
.IP \fB14\fR:
text string to appear above the beach ball (default) or under (add u).
.sp
.TP
\fB\-Sp\fIscale[/fontsize[/offset[u]]]\fR
Focal mechanisms given with partial data on both planes.
\fIscale\fP adjusts the scaling of the radius of the "beach ball", which will
be proportional to the magnitude. The \fIscale\fP is the size for magnitude
= 5 in MEASURE_UNIT (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended
to indicate that the size information is in units of cm, inches, meters, or
points, respectively). The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option. The color or shade of the extensive
quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns:
.IP \fB1,2\fR:
longitude, latitude of event (\fB-:\fP option interchanges order)
.IP \fB3\fR:
depth
.IP \fB4,5\fR:
strike, dip of plane 1
.IP \fB6\fR:
strike of plane 2
.IP \fB7\fR:
must be -1/+1 for a normal/inverse fault
.IP \fB8\fR:
magnitude
.IP \fB9,10\fR:
not used; can be 0 0; allows use of the psmeca file format
.IP \fB11\fR:
text string to appear above the beach ball (default) or under (add u).
.sp
.TP
\fB\-Sm\fIscale[/fontsize[/offset[u]]]\fR Seismic moment tensor.
\fIscale\fP adjusts the scaling of the radius of the "beach ball", which will
be proportional to the magnitude. The \fIscale\fR is the size for magnitude = 5
(that is seismic scalar moment = 4E+23 dynes-cm) in MEASURE_UNIT (unless
\fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended to indicate that the size
information is in units of cm, inches, meters, or points, respectively).
(\fB-T\fI0\fR option overlays best double couple transparently.) Put
\fB\-Sd\fIscale[/fontsize[/offset[u]]]\fR to plot the only double couple part
of moment tensor. Put \fB\-Sz\fIscale[/fontsize[/offset[u]]]\fR to plot
anisotropic part of moment tensor (zero trace). The color or shade of the
compressive quadrants can be specified with the \fB-G\fR option. The color or
shade of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns:
.IP \fB1,2\fR:
longitude, latitude of event (\fB-:\fR option interchanges order)
.IP \fB3\fR:
depth of event in kilometers
.IP \fB4,5,6,7,8,9\fR:
mrr, mtt, mff, mrt, mrf, mtf in 10*exponent dynes-cm
.IP \fB10\fR:
exponent
.IP \fB11,12\fR:
Not used; can be 0 0; allows use of the psmeca file format
.IP \fB13\fR:
Text string to appear above the beach ball (default) or under (add u).
.br
.sp
.TP
\fB\-Sx\fIscale[/fontsize[/offset[u]]]\fR Principal axis.
\fIscale\fP adjusts the scaling of the radius of the "beach ball", which will
be proportional to the magnitude. The \fIscale\fR is the size for magnitude = 5
(that is seismic scalar moment = 4*10e+23 dynes-cm) in MEASURE_UNIT (unless
\fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended to indicate that the size
information is in units of cm, inches, meters, or points, respectively).
(\fB-T\fI0\fR option overlays best double couple transparently.) Put
\fB\-Sy\fIscale[/fontsize[/offset[u]]]\fR to plot the only double couple part
of moment tensor. Put \fB\-St\fIscale[/fontsize[/offset[u]]]\fR to plot
anisotropic part of moment tensor (zero trace). The color or shade of the
compressive quadrants can be specified with the \fB-G\fR option. The color or
shade of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns:
.IP \fB1,2\fR:
longitude, latitude of event (\fB-:\fR option interchanges order)
.IP \fB3\fR:
depth of event in kilometers
.IP \fB4,5,6,7,8,9,10,11,12\fR:
value (in 10*exponent dynes-cm), azimuth, plunge of the T, N, and P axes.
.IP \fB13\fR:
exponent
.IP \fB14,15\fR:
longitude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fR option. Using 0,0 in columns
9 and 10 will plot the beach ball at the longitude, latitude given in
columns 1 and 2. The \fB-:\fR option will interchange the order of
columns (1,2) and (9,10).
.IP \fB16\fR:
Text string to appear above the beach ball (optional).
.br
.TP
\fB\-s\fIsymbol[size[/fontsize[/offset[u]]]\fR
selects a symbol instead of mechanism.
Choose from the following:
(\fIc\fP) circle, (\fPd\fP) diamond, (\fPi\fP) itriangle, (\fPs\fP) square, (\fPt\fP) triangle, (\fPx\fP) cross.
\fIsize\fR is the symbol size in MEASURE_UNIT (unless \fBc\fP, \fBi\fP,
\fBm\fP, or \fBp\fP is appended to indicate that the size information is in
units of cm, inches, meters, or points, respectively). If \fIsize\fR must be
read, it must be in column 4 and the text string will start in column 5.
Parameters are expected to be in the following columns:
.IP \fB1,2\fR:
longitude, latitude of event (\fB-:\fR option interchanges order)
.IP \fB3\fR:
depth of event in kilometers
.IP \fB4\fR:
Text string to appear above the beach ball (default) or under (add u).
.br
.sp
.br
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.br
.TP
\fB\-E\fP\fIfill\fP
\fRSelects filling of extensive quadrants. Usually white.
Set the shade (0\-255) or color (r/g/b) [Default is 255/255/255].
.br
.TP
\fB\-G\fP\fIfill\fP selects filling of focal mechanisms. By convention, the
compressional quadrants are shaded. Set the shade (0\-255) or color
(\fIr/g/b\fP) [Default is \fP0/0/0\fP]. Optionally, specify
\fB\-Gp\fIicon_size/pattern\fR, where \fPpattern\fP gives the
number of the image pattern (1-32) OR the name of a icon-format file.
\fPicon_size\fP sets the unit size in inches. To invert black and
white pixels, use \fB\-GP\fR instead of \fP\-Gp\fP. See
Appendix E for information on individual patterns.
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults file. If used, \fBGMT\fP default is 1 header record.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
\fB\-L\fR[\fIpen\fR]
\fRDraws the "beach ball" outline using current pen (see \fB\-W\fP) or sets pen attributes.
.br
.TP
.B \-M
Same size for any magnitude.
.br
.TP
\fB\-N
\fRDoes \fBNOT \fRskip symbols that fall outside map border [Default plots points inside border only].
.TP
.B \-bo
Selects binary output. Append \fBs\fP for single precision [Default is double].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.br
.TP
\fB\-T\fR[\fInum_of_planes\fR]
\fRPlots the nodal planes and outlines the bubble which is transparent.
If \fInum_of_planes\fR is
.br
      \fI0\fR: both nodal planes are plotted;
      \fI1\fR: only the first nodal plane is plotted;
      \fI2\fR: only the second nodal plane is plotted
[Default: 0].
.TP
.B \-U
Draw Unix System time stamp on plot. User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot. Optionally,
append a label, or \fBc\fP (which will plot the command string.). The GMT parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.br
.TP
.B \-W
set pen attributes for text string or default pen attributes for fault plane edges. [Defaults: width = \fI1\fP, color = \fP0/0/0\fP, texture = \fPsolid\fP].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
.TP
\fB\-Z\fIcptfile
\fRGive a color palette file and let compressive part color be determined by the z-value in the
third column.
.br
.TP
\fB\-a\fR[\fIsize\fR/[\fIP_axis_symbol\fR/[\fIT_axis_symbol\fR]]]
Computes and plots P and T axes with symbols. Optionally specify \fIsize\fP
and (separate) P and T axis symbols from the following:
(\fBc\fR) circle, (\fBd\fR) diamond, (\fBh\fR) hexagon,
(\fBi\fR) inverse triangle,
(\fBp\fR)point, (\fBs\fR) square, (\fBt\fR) triangle,
(\fBx\fR) cross. [Defaults: \fI0.2\fBc\fI/c/c\fR or \fI0.08\fBi/\fIc/c\fR.]
.br
.TP
\fB\-e\fP\fIfill\fP
\fRSelects filling of T axis symbol.
Set the shade (0\-255) or color (r/g/b) [Default is color of extensive parts.]
.br
.TP
\fB\-g\fP\fIfill\fP
\fRSelects filling of P axis symbol.
Set the shade (0\-255) or color (r/g/b) [Default is color of compressive parts.]
.br
.TP
\fB\-p\fR[\fIpen\fP]
\fRDraws the P axis outline using current pen (see \fB\-W\fP), or sets
pen attributes.
.br
.TP
\fB\-t\fR[\fIpen\fP]
\fRDraws the T axis outline using current pen (see \fB\-W\fP), or sets
pen attributes.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output. [Default is (longitude,latitude)].
Applies to geographic coordinates only.
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH "SEE ALSO"
.IR gmt (GMTMANSECTION),
.IR psbasemap (GMTMANSECTION)
.IR psmeca (GMTMANSECTION),
.IR psxy (GMTMANSECTION)
.sp
.SH REFERENCES
.br
Bomford, G., Geodesy, 4th ed., Oxford University Press, 1980.
.br
Aki, K. and P. Richards, Quantitative Seismology, Freeman, 1980.
.br
F. A. Dahlen and Jeoren Trom, Theoretical Seismology, Princeton, 1998, p.167.
Definition of scalar moment.
.br
Cliff Frohlich, Cliff'Nodes Concerning Plotting Nodal Lines for P, Sh and Sv'
.br
Seismological Research Letters, Volume 67, Number 1, January-February, 1996
.br
Thorne Lay, Terry C. Wallace, Modern Global Seismology, Academic Press, 1995, p.384.
.br
W.H. Press, S.A. Teukolsky, W.T. Vetterling, B.P. Flannery, Numerical Recipes in C, Cambridge University press (routine jacobi)
.br
.sp
.SH AUTHOR
.br
\fRGenevieve Patau
.br
CNRS UMR 7580
.br
Seismology Dept.
.br
Institut de Physique du Globe de Paris
.br
(patau@ipgp.jussieu.fr)
